/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.network;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.block.IAllomanticallyUsable;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.combat.CombatSetup;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.powers.data.AllomancerAttachment;
import com.legobmw99.allomancy.modules.powers.data.AllomancerData;
import com.legobmw99.allomancy.modules.powers.network.BlockPushPullPayload;
import com.legobmw99.allomancy.modules.powers.network.EmotionPayload;
import com.legobmw99.allomancy.modules.powers.network.EnhanceTimePayload;
import com.legobmw99.allomancy.modules.powers.network.EntityPushPullPayload;
import com.legobmw99.allomancy.modules.powers.network.Network;
import com.legobmw99.allomancy.modules.powers.network.ToggleBurnPayload;
import com.legobmw99.allomancy.modules.powers.util.Emotional;
import com.legobmw99.allomancy.modules.powers.util.Physical;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public final class ServerPayloadHandler {
    private ServerPayloadHandler() {
    }

    public static void changeEmotion(EmotionPayload data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer allomancer = (ServerPlayer)ctx.player();
            PathfinderMob target = (PathfinderMob)allomancer.level().getEntity(data.entityID());
            if (target == null) {
                return;
            }
            boolean enhanced = AllomancerAttachment.get((Player)allomancer).isEnhanced();
            ExtrasSetup.METAL_USED_ON_ENTITY_TRIGGER.get().trigger(allomancer, (Entity)target, data.makeAggressive() ? Metal.ZINC : Metal.BRASS, enhanced);
            if (data.makeAggressive()) {
                Emotional.riot(target, (Player)allomancer, enhanced);
            } else {
                Emotional.soothe(target, (Player)allomancer, enhanced);
            }
        }).exceptionally(e -> {
            Allomancy.LOGGER.error("Failed to handle changeEmotions", e);
            ctx.disconnect((Component)Component.translatable((String)"allomancy.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void tryPushPullBlock(BlockPushPullPayload data, IPayloadContext ctx) {
        BlockPos pos;
        ServerPlayer player = (ServerPlayer)ctx.player();
        ServerLevel level = player.level();
        if (level.isLoaded(pos = data.block())) {
            BlockState blockState = level.getBlockState(pos);
            IAllomanticallyUsable allomanticUseCap = (IAllomanticallyUsable)level.getCapability(ExtrasSetup.ALLOMANTICALLY_USABLE_BLOCK, pos, blockState, null, null);
            if (allomanticUseCap != null) {
                allomanticUseCap.useAllomantically((Player)player, data.isPush());
            } else if (Physical.isBlockStateMetallic(blockState) || player.isCrouching() && data.isPush() && player.getMainHandItem().getItem() == CombatSetup.COIN_BAG.get()) {
                Physical.lurch(data.direction(), (Entity)player, pos);
            } else {
                Allomancy.LOGGER.warn("Illegal use of iron/steel by player: {}!", (Object)player);
                ctx.disconnect((Component)Component.translatable((String)"allomancy.networking.kicked", (Object[])new Object[]{"Tried to push or pull against an non-metallic block!"}));
            }
        } else {
            Allomancy.LOGGER.warn("Illegal use of iron/steel by player: {}! Block not loaded at {}", (Object)player, (Object)pos);
            ctx.disconnect((Component)Component.translatable((String)"allomancy.networking.kicked", (Object[])new Object[]{"Tried to push or pull against an unloaded block!"}));
        }
    }

    public static void tryPushPullEntity(EntityPushPullPayload payload, IPayloadContext ctx) {
        Metal which;
        ServerPlayer player = (ServerPlayer)ctx.player();
        ServerLevel level = player.level();
        Entity target = level.getEntity(payload.entityID());
        AllomancerData data = AllomancerAttachment.get((Player)player);
        Metal metal = which = payload.isPush() ? Metal.STEEL : Metal.IRON;
        if (target != null && Physical.isEntityMetallic(target)) {
            ExtrasSetup.METAL_USED_ON_ENTITY_TRIGGER.get().trigger(player, target, which, data.isEnhanced());
            if (target instanceof IronGolem || target instanceof ItemFrame) {
                Physical.lurch(payload.force(), (Entity)player, target.blockPosition());
            } else if (target instanceof ItemEntity || target instanceof FallingBlockEntity || target instanceof ArmorStand || target instanceof AbstractMinecart && target.getControllingPassenger() != player) {
                Physical.lurch((double)payload.force() / 2.0, target, player.blockPosition());
            } else if (!(target instanceof ThrowableItemProjectile)) {
                Physical.lurch((double)payload.force() / 2.0, target, player.blockPosition());
                Physical.lurch((double)payload.force() / 2.0, (Entity)player, target.blockPosition());
            }
        }
    }

    public static void toggleBurnRequest(ToggleBurnPayload payload, IPayloadContext ctx) {
        assert (ctx.flow().isServerbound());
        ctx.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            Metal mt = payload.metal();
            AllomancerData data = AllomancerAttachment.get((Player)player);
            boolean value = payload.on();
            if (!data.hasPower(mt) || data.getStored(mt) <= 0) {
                value = false;
            }
            data.setBurning(mt, value);
            if (!value && mt == Metal.DURALUMIN) {
                data.drainMetals((Metal[])Arrays.stream(Metal.values()).filter(data::isBurning).toArray(Metal[]::new));
            }
            if (!value && data.isEnhanced()) {
                data.drainMetals(mt);
            }
            AllomancerAttachment.sync((Player)player);
        }).exceptionally(e -> {
            Allomancy.LOGGER.error("Failed to handle toggleBurn", e);
            ctx.disconnect((Component)Component.translatable((String)"allomancy.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void updateEnhanced(EnhanceTimePayload payload, IPayloadContext ctx) {
        assert (ctx.flow().isServerbound());
        ctx.enqueueWork(() -> {
            ServerPlayer target;
            ServerPlayer source = (ServerPlayer)ctx.player();
            AllomancerData data = AllomancerAttachment.get((Player)source);
            if (!data.isBurning(Metal.NICROSIL)) {
                Allomancy.LOGGER.warn("Illegal use of Nicrosil by player: {}!", (Object)source);
                ctx.disconnect((Component)Component.translatable((String)"allomancy.networking.kicked", (Object[])new Object[]{"Tried to mark other player as enhanced while not burning Nicrosil!"}));
                return;
            }
            Player player = source.level().getPlayerByUUID(payload.player());
            ExtrasSetup.METAL_USED_ON_ENTITY_TRIGGER.get().trigger(source, (Entity)player, Metal.NICROSIL, data.isEnhanced());
            if (player instanceof ServerPlayer && !Emotional.hasTinFoilHat((LivingEntity)(target = (ServerPlayer)player))) {
                AllomancerAttachment.get((Player)target).setEnhanced(payload.enhanceTime());
                Network.sync(payload, target);
            }
        }).exceptionally(e -> {
            Allomancy.LOGGER.error("Failed to handle sever updateEnhanced", e);
            ctx.disconnect((Component)Component.translatable((String)"allomancy.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

