/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.util;

import com.legobmw99.allomancy.api.data.IAllomancerData;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.powers.data.AllomancerAttachment;
import com.legobmw99.allomancy.modules.powers.data.AllomancerData;
import com.legobmw99.allomancy.modules.powers.util.Emotional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class Enhancement {
    private Enhancement() {
    }

    public static void wipePlayer(ServerPlayer player) {
        AllomancerData data = AllomancerAttachment.get((Player)player);
        data.drainMetals(Metal.values());
        player.removeAllEffects();
        AllomancerAttachment.sync((Player)player);
    }

    private static void teleport(ServerPlayer player, ServerLevel world, ResourceKey<Level> dimension, BlockPos pos) {
        if (player != null) {
            if (player.isPassenger()) {
                player.stopRiding();
            }
            if (player.level().dimension() != dimension) {
                player = player.teleport(new TeleportTransition(world.getServer().getLevel(dimension), Vec3.atBottomCenterOf((Vec3i)pos), Vec3.ZERO, player.getXRot(), player.getYRot(), TeleportTransition.DO_NOTHING));
            }
            Vec3 center = pos.above().getCenter();
            player.teleportTo(center.x(), center.y(), center.z());
            player.fallDistance = 0.0;
        }
    }

    public static void teleportToLastDeath(ServerPlayer curPlayer, ServerLevel level, IAllomancerData data) {
        curPlayer.getLastDeathLocation().ifPresent(death -> {
            Enhancement.teleport(curPlayer, level, (ResourceKey<Level>)death.dimension(), death.pos());
            if (data.isBurning(Metal.DURALUMIN)) {
                data.drainMetals(Metal.DURALUMIN);
            }
            data.drainMetals(Metal.GOLD);
        });
    }

    public static void teleportToSpawn(ServerPlayer curPlayer, ServerLevel level, IAllomancerData data) {
        GlobalPos spawn = data.getSpawnLoc();
        if (spawn == null) {
            spawn = GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)level.getLevelData().getSpawnPos());
        }
        Enhancement.teleport(curPlayer, level, (ResourceKey<Level>)spawn.dimension(), spawn.pos());
        if (data.isBurning(Metal.DURALUMIN)) {
            data.drainMetals(Metal.DURALUMIN);
        }
        data.drainMetals(Metal.ELECTRUM);
    }

    public static void wipeNearby(ServerPlayer curPlayer, ServerLevel level) {
        int max = 20;
        Vec3 negative = curPlayer.position().add((double)(-max), (double)(-max), (double)(-max));
        Vec3 positive = curPlayer.position().add((double)max, (double)max, (double)max);
        level.getEntitiesOfClass(ServerPlayer.class, new AABB(negative, positive)).forEach(player -> {
            ExtrasSetup.METAL_USED_ON_ENTITY_TRIGGER.get().trigger(curPlayer, (Entity)player, Metal.CHROMIUM, true);
            if (!Emotional.hasTinFoilHat((LivingEntity)player)) {
                Enhancement.wipePlayer(player);
            }
        });
    }
}

