/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.util;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.modules.combat.CombatSetup;
import com.legobmw99.allomancy.modules.combat.entity.ProjectileNuggetEntity;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.powers.PowersConfig;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;

public final class Physical {
    private static final Pattern ACTIVE_METAL_REGEX = Pattern.compile(".*(iron|steel|tin_|pewter|zinc|brass|copper|bronze|duralumin|chromium|nicrosil|gold|electrum|cadmium|bendalloy|lead_|silver|platinum|nickle).*");
    private static HashSet<String> defaultSet;
    private static List<String> defaultList;

    private Physical() {
    }

    public static boolean isBlockStateMetallic(BlockState state) {
        return Physical.isBlockMetallic(state.getBlock());
    }

    public static boolean isBlockMetallic(Block block) {
        return Physical.isOnWhitelist(BuiltInRegistries.BLOCK.getKey((Object)block).toString());
    }

    public static boolean isItemMetallic(ItemStack item) {
        return Physical.isOnWhitelist(BuiltInRegistries.ITEM.getKey((Object)item.getItem()).toString());
    }

    private static boolean isOnWhitelist(String s) {
        return PowersConfig.whitelist.contains(s);
    }

    public static boolean isEntityMetallic(Entity entity) {
        Entity entity2 = entity;
        Objects.requireNonNull(entity2);
        Entity entity3 = entity2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemEntity.class, ItemFrame.class, FallingBlockEntity.class, ProjectileNuggetEntity.class, AbstractMinecart.class, IronGolem.class, LivingEntity.class}, (Object)entity3, n)) {
            case 0 -> {
                ItemEntity item = (ItemEntity)entity3;
                yield Physical.isItemMetallic(item.getItem());
            }
            case 1 -> {
                ItemFrame itemFrame = (ItemFrame)entity3;
                yield Physical.isItemMetallic(itemFrame.getItem());
            }
            case 2 -> {
                FallingBlockEntity fbe = (FallingBlockEntity)entity3;
                yield Physical.isBlockStateMetallic(fbe.getBlockState());
            }
            case 3 -> {
                ProjectileNuggetEntity ignored = (ProjectileNuggetEntity)entity3;
                yield true;
            }
            case 4 -> {
                AbstractMinecart ignored = (AbstractMinecart)entity3;
                yield true;
            }
            case 5 -> {
                IronGolem ignored = (IronGolem)entity3;
                yield true;
            }
            case 6 -> {
                LivingEntity ent = (LivingEntity)entity3;
                for (EquipmentSlot slot : EquipmentSlot.VALUES) {
                    ItemStack itemStack = ent.getItemBySlot(slot);
                    if (!Physical.isItemMetallic(itemStack)) continue;
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static boolean doesResourceContainMetal(ResourceLocation input) {
        return ACTIVE_METAL_REGEX.matcher(input.getPath()).matches();
    }

    public static void lurch(double directionScalar, Entity toMove, BlockPos block) {
        if (toMove.isPassenger()) {
            toMove = toMove.getVehicle();
        }
        Vec3 motion = toMove.position().subtract(Vec3.atCenterOf((Vec3i)block)).normalize().scale(directionScalar * 1.1);
        Vec3 mod = Physical.clamp(Physical.cutoff(motion.add(toMove.getDeltaMovement()), 0.1), Physical.abs(motion).reverse(), Physical.abs(motion));
        toMove.setDeltaMovement(mod);
        toMove.hurtMarked = true;
        if (toMove instanceof ServerPlayer) {
            toMove.fallDistance = 0.0;
        }
    }

    private static Vec3 clamp(Vec3 value, Vec3 min, Vec3 max) {
        return new Vec3(Mth.clamp((double)value.x, (double)min.x, (double)max.x), Mth.clamp((double)value.y, (double)min.y, (double)max.y), Mth.clamp((double)value.z, (double)min.z, (double)max.z));
    }

    private static Vec3 abs(Vec3 vec) {
        return new Vec3(Math.abs(vec.x), Math.abs(vec.y), Math.abs(vec.z));
    }

    private static Vec3 cutoff(Vec3 value, double e) {
        Vec3 mag = Physical.abs(value);
        return new Vec3(mag.x < e ? 0.0 : value.x, mag.y < e ? 0.0 : value.y, mag.z < e ? 0.0 : value.z);
    }

    public static List<String> default_whitelist() {
        if (defaultList != null) {
            return defaultList;
        }
        defaultSet = new HashSet();
        Physical.add(Items.BUCKET);
        Physical.add(Items.LAVA_BUCKET);
        Physical.add(Items.MILK_BUCKET);
        Physical.add(Items.COD_BUCKET);
        Physical.add(Items.PUFFERFISH_BUCKET);
        Physical.add(Items.SALMON_BUCKET);
        Physical.add(Items.TROPICAL_FISH_BUCKET);
        Physical.add(Items.WATER_BUCKET);
        Physical.add(Items.TADPOLE_BUCKET);
        Physical.add(Items.AXOLOTL_BUCKET);
        Physical.add(Items.POWDER_SNOW_BUCKET);
        Physical.add(Items.COMPASS);
        Physical.add(Items.RECOVERY_COMPASS);
        Physical.add(Items.CHAINMAIL_HELMET);
        Physical.add(Items.CHAINMAIL_CHESTPLATE);
        Physical.add(Items.CHAINMAIL_LEGGINGS);
        Physical.add(Items.CHAINMAIL_BOOTS);
        Physical.add(Items.MINECART);
        Physical.add(Items.CHEST_MINECART);
        Physical.add(Items.HOPPER_MINECART);
        Physical.add(Items.FURNACE_MINECART);
        Physical.add(Items.TNT_MINECART);
        Physical.add(Items.CLOCK);
        Physical.add(Items.SHEARS);
        Physical.add(Items.SHIELD);
        Physical.add(Items.NETHERITE_INGOT);
        Physical.add(Items.NETHERITE_HELMET);
        Physical.add(Items.NETHERITE_CHESTPLATE);
        Physical.add(Items.NETHERITE_LEGGINGS);
        Physical.add(Items.NETHERITE_BOOTS);
        Physical.add(Items.NETHERITE_HOE);
        Physical.add(Items.NETHERITE_PICKAXE);
        Physical.add(Items.NETHERITE_SHOVEL);
        Physical.add(Items.NETHERITE_SWORD);
        Physical.add(Items.NETHERITE_AXE);
        Physical.add(Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE);
        Physical.add(Items.CROSSBOW);
        Physical.add(Items.BRUSH);
        Physical.add(Items.MUSIC_DISC_CREATOR);
        Physical.add(Items.MUSIC_DISC_CREATOR_MUSIC_BOX);
        Physical.add(Items.TRIAL_KEY);
        Physical.add(Items.OMINOUS_TRIAL_KEY);
        Physical.add(Items.MACE);
        Physical.add(Items.SPYGLASS);
        Physical.add(Items.BOLT_ARMOR_TRIM_SMITHING_TEMPLATE);
        Physical.add(Blocks.ANVIL);
        Physical.add(Blocks.CHIPPED_ANVIL);
        Physical.add(Blocks.DAMAGED_ANVIL);
        Physical.add(Blocks.CAULDRON);
        Physical.add(Blocks.POWDER_SNOW_CAULDRON);
        Physical.add(Blocks.LAVA_CAULDRON);
        Physical.add(Blocks.WATER_CAULDRON);
        Physical.add(Blocks.SMITHING_TABLE);
        Physical.add(Blocks.STONECUTTER);
        Physical.add(Blocks.CHAIN);
        Physical.add(Blocks.HOPPER);
        Physical.add(Blocks.PISTON_HEAD);
        Physical.add(Blocks.MOVING_PISTON);
        Physical.add(Blocks.STICKY_PISTON);
        Physical.add(Blocks.BLAST_FURNACE);
        Physical.add(Blocks.BELL);
        Physical.add(Blocks.PISTON);
        Physical.add(Blocks.LIGHT_WEIGHTED_PRESSURE_PLATE);
        Physical.add(Blocks.HEAVY_WEIGHTED_PRESSURE_PLATE);
        Physical.add(Blocks.RAIL);
        Physical.add(Blocks.ACTIVATOR_RAIL);
        Physical.add(Blocks.DETECTOR_RAIL);
        Physical.add(Blocks.POWERED_RAIL);
        Physical.add(Blocks.LANTERN);
        Physical.add(Blocks.TRAPPED_CHEST);
        Physical.add(Blocks.TRIPWIRE_HOOK);
        Physical.add(Blocks.SOUL_LANTERN);
        Physical.add(Blocks.NETHERITE_BLOCK);
        Physical.add(Blocks.LODESTONE);
        Physical.add(Blocks.GILDED_BLACKSTONE);
        Physical.add(Blocks.LIGHTNING_ROD);
        Physical.add(Blocks.CRAFTER);
        Physical.add(Blocks.HEAVY_CORE);
        WoodType.values().forEach(wt -> {
            Physical.add("minecraft:" + wt.name() + "_hanging_sign");
            Physical.add("minecraft:" + wt.name() + "_wall_hanging_sign");
        });
        Physical.add((Item)ConsumeSetup.VIAL.get());
        Physical.add((Item)ConsumeSetup.LERASIUM_NUGGET.get());
        Physical.add((Item)ConsumeSetup.ALLOMANTIC_GRINDER.get());
        Physical.add((Item)CombatSetup.COIN_BAG.get());
        Physical.add((Item)ExtrasSetup.BRONZE_EARRING.get());
        Physical.add((Block)WorldSetup.LIQUID_LERASIUM.get());
        BuiltInRegistries.ITEM.keySet().stream().filter(Objects::nonNull).filter(Physical::doesResourceContainMetal).forEach(Physical::add);
        BuiltInRegistries.BLOCK.keySet().stream().filter(Objects::nonNull).filter(Physical::doesResourceContainMetal).forEach(Physical::add);
        defaultList = new ArrayList<String>(defaultSet);
        defaultList.sort(String::compareTo);
        return defaultList;
    }

    private static void add(String s) {
        Allomancy.LOGGER.info("Adding {} to the default whitelist!", (Object)s);
        defaultSet.add(s);
    }

    private static void add(ResourceLocation r) {
        Physical.add(r.toString());
    }

    private static void add(Block block) {
        Physical.add(BuiltInRegistries.BLOCK.getKey((Object)block));
    }

    private static void add(Item item) {
        Physical.add(BuiltInRegistries.ITEM.getKey((Object)item));
    }

    static {
        defaultList = null;
    }
}

