/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.world.block;

import com.legobmw99.allomancy.modules.world.WorldSetup;
import com.legobmw99.allomancy.modules.world.recipe.InvestingRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import org.jetbrains.annotations.Nullable;

public class LiquidLerasiumBlock
extends LiquidBlock {
    public LiquidLerasiumBlock(FlowingFluid fluid, BlockBehaviour.Properties properties) {
        super(fluid, properties);
    }

    public ItemStack pickupBlock(@Nullable LivingEntity entity, LevelAccessor level, BlockPos pos, BlockState state) {
        if (entity instanceof Player) {
            Player p = (Player)entity;
            if (p.getAbilities().instabuild) {
                return super.pickupBlock(entity, level, pos, state);
            }
        }
        return ItemStack.EMPTY;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier eff) {
        super.entityInside(state, level, pos, entity, eff);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)entity;
                InvestingRecipe.InvestingWrapper input = new InvestingRecipe.InvestingWrapper(item.getItem());
                serverLevel.recipeAccess().getRecipeFor(WorldSetup.INVESTING_RECIPE.get(), (RecipeInput)input, (Level)serverLevel).ifPresent(recipe -> {
                    item.setItem(((InvestingRecipe)recipe.value()).assemble(input, (HolderLookup.Provider)serverLevel.registryAccess()));
                    serverLevel.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS);
                    for (int i = 0; i < 16; ++i) {
                        float f4 = Mth.cos((float)i) * 0.3f;
                        float f5 = Mth.sin((float)i) * 0.3f;
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, entity.getX() + (double)f4, entity.getY() + (double)0.4f, entity.getZ() + (double)f5, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                });
            }
        }
    }
}

