/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.world.client;

import com.legobmw99.allomancy.modules.world.WorldSetup;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public final class WorldClientSetup {
    public static void register(IEventBus bus) {
        bus.addListener(WorldClientSetup::clientInit);
        bus.addListener(WorldClientSetup::registerClientExtensions);
    }

    private static void clientInit(FMLClientSetupEvent e) {
        e.enqueueWork(() -> ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)WorldSetup.LERASIUM_FLUID.get()), (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT));
    }

    private static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType((IClientFluidTypeExtensions)new LerasiumFluidExtension(), new FluidType[]{WorldSetup.LERAS_TYPE.get()});
    }

    private WorldClientSetup() {
    }

    private static class LerasiumFluidExtension
    implements IClientFluidTypeExtensions {
        private static final ResourceLocation LERASIUM_FLUID_TEXTURE = ResourceLocation.withDefaultNamespace((String)"block/water_still");
        private static final ResourceLocation LERASIUM_FLUID_FLOWING = ResourceLocation.withDefaultNamespace((String)"block/water_flow");
        private static final ResourceLocation LERASIUM_FLUID_ROVERLAY = ResourceLocation.withDefaultNamespace((String)"textures/misc/underwater.png");
        private static final ResourceLocation LERASIUM_FLUID_OVERLAY = ResourceLocation.withDefaultNamespace((String)"block/water_overlay");

        private LerasiumFluidExtension() {
        }

        public ResourceLocation getStillTexture() {
            return LERASIUM_FLUID_TEXTURE;
        }

        public ResourceLocation getFlowingTexture() {
            return LERASIUM_FLUID_FLOWING;
        }

        @Nullable
        public ResourceLocation getOverlayTexture() {
            return LERASIUM_FLUID_OVERLAY;
        }

        public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
            return LERASIUM_FLUID_ROVERLAY;
        }

        public int getTintColor() {
            return -2889217;
        }
    }
}

