/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.world.loot;

import com.google.common.base.Suppliers;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.powers.data.AllomancerAttachment;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class LerasiumLootModifier
extends LootModifier {
    private final int chance_one_in;
    public static final Supplier<MapCodec<LerasiumLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> LerasiumLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.INT.fieldOf("chance_one_in").forGetter(t -> t.chance_one_in)).apply((Applicative)inst, LerasiumLootModifier::new)));

    public LerasiumLootModifier(LootItemCondition[] conditionsIn, int chance_one_in) {
        super(conditionsIn);
        this.chance_one_in = chance_one_in;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Player player;
        Entity ent;
        if (context.getQueriedLootTableId().getPath().startsWith("archaeology") && (ent = (Entity)context.getOptionalParameter(LootContextParams.THIS_ENTITY)) instanceof Player && AllomancerAttachment.get(player = (Player)ent).isMistborn()) {
            return generatedLoot;
        }
        if (context.getRandom().nextInt(this.chance_one_in) == 0) {
            generatedLoot.addFirst((Object)new ItemStack((ItemLike)ConsumeSetup.LERASIUM_NUGGET.get()));
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

