/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.util;

import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.combat.CombatSetup;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.consumables.item.VialItem;
import com.legobmw99.allomancy.modules.consumables.item.component.FlakeStorage;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ItemDisplay {
    private static final DeferredRegister<CreativeModeTab> CREATIVETABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"allomancy");
    private static final Supplier<CreativeModeTab> ALLOMANCY_CREATIVE_TAB = CREATIVETABS.register("main_tab", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)CombatSetup.MISTCLOAK.get())).title((Component)Component.translatable((String)"tabs.allomancy.main_tab")).displayItems((featureFlags, output) -> {
        output.accept((ItemLike)ConsumeSetup.LERASIUM_NUGGET.get());
        output.accept((ItemLike)CombatSetup.ALUMINUM_HELMET.get());
        output.accept((ItemLike)CombatSetup.MISTCLOAK.get());
        output.accept((ItemLike)CombatSetup.COIN_BAG.get());
        output.accept((ItemLike)ConsumeSetup.ALLOMANTIC_GRINDER.get());
        output.accept((ItemLike)ConsumeSetup.VIAL.get());
        ItemStack fullVial = new ItemStack((ItemLike)ConsumeSetup.VIAL.get());
        FlakeStorage.Mutable storage = new FlakeStorage.Mutable();
        for (Metal metal : Metal.values()) {
            storage.add(metal);
        }
        VialItem.fillVial(fullVial, storage.toImmutable());
        output.accept(fullVial);
        output.accept((ItemLike)CombatSetup.KOLOSS_BLADE.get());
        output.accept((ItemLike)CombatSetup.OBSIDIAN_DAGGER.get());
        output.accept((ItemLike)ExtrasSetup.BRONZE_EARRING.get());
        output.accept((ItemLike)ExtrasSetup.CHARGED_BRONZE_EARRING.get());
        output.accept((ItemLike)ExtrasSetup.IRON_LEVER.get());
        output.accept((ItemLike)ExtrasSetup.IRON_BUTTON.get());
        output.accept((ItemLike)ExtrasSetup.INVERTED_IRON_BUTTON.get());
        for (DeferredBlock deferredBlock : WorldSetup.STORAGE_BLOCKS) {
            if (deferredBlock == null) continue;
            output.accept((ItemLike)deferredBlock.get());
        }
        for (DeferredItem deferredItem : WorldSetup.INGOTS) {
            if (deferredItem == null) continue;
            output.accept((ItemLike)deferredItem.get());
        }
        for (DeferredItem deferredItem : WorldSetup.NUGGETS) {
            if (deferredItem == null) continue;
            output.accept((ItemLike)deferredItem.get());
        }
        for (DeferredItem deferredItem : WorldSetup.FLAKES) {
            if (deferredItem == null) continue;
            output.accept((ItemLike)deferredItem.get());
        }
        for (Metal metal : Metal.values()) {
            output.accept((ItemLike)ExtrasSetup.PATTERN_ITEMS.get(metal.getIndex()).get());
        }
        for (DeferredBlock deferredBlock : WorldSetup.ORE_BLOCKS) {
            output.accept((ItemLike)deferredBlock.get());
        }
        for (DeferredBlock deferredBlock : WorldSetup.DEEPSLATE_ORE_BLOCKS) {
            output.accept((ItemLike)deferredBlock.get());
        }
        for (DeferredBlock deferredBlock : WorldSetup.RAW_ORE_BLOCKS) {
            output.accept((ItemLike)deferredBlock.get());
        }
        for (DeferredItem deferredItem : WorldSetup.RAW_ORE_ITEMS) {
            output.accept((ItemLike)deferredItem.get());
        }
    }).build());

    private ItemDisplay() {
    }

    private static void addTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.COMBAT) {
            event.accept(CombatSetup.ALUMINUM_HELMET);
            event.accept(CombatSetup.MISTCLOAK);
            event.accept(CombatSetup.OBSIDIAN_DAGGER);
            event.accept(CombatSetup.KOLOSS_BLADE);
        } else if (event.getTabKey() == CreativeModeTabs.REDSTONE_BLOCKS) {
            event.accept(ExtrasSetup.IRON_LEVER);
            event.accept(ExtrasSetup.IRON_BUTTON);
            event.accept(ExtrasSetup.INVERTED_IRON_BUTTON);
        }
    }

    public static void register(IEventBus bus) {
        CREATIVETABS.register(bus);
        bus.addListener(ItemDisplay::addTabContents);
    }

    public static MutableComponent addColorToText(String translationKey, ChatFormatting color) {
        MutableComponent lore = Component.translatable((String)translationKey);
        return ItemDisplay.addColor(lore, color);
    }

    public static MutableComponent addColorToText(String translationKey, ChatFormatting color, Object ... fmting) {
        MutableComponent lore = Component.translatable((String)translationKey, (Object[])fmting);
        return ItemDisplay.addColor(lore, color);
    }

    private static MutableComponent addColor(MutableComponent text, ChatFormatting color) {
        text.setStyle(text.getStyle().withColor(color));
        return text;
    }
}

