/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.datagen;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BlockLootTables
implements LootTableSubProvider {
    protected static void addSimpleBlock(BiConsumer<ResourceLocation, LootTable.Builder> writer, String name, Block block) {
        Allomancy.LOGGER.debug("Creating Loot Table for block " + String.valueOf(ForgeRegistries.BLOCKS.getKey((Object)block)));
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block));
        writer.accept(new ResourceLocation("allomancy", "blocks/" + name), LootTable.m_79147_().m_79161_(builder));
    }

    protected static void addSilkTouchBlock(BiConsumer<ResourceLocation, LootTable.Builder> writer, String name, Block block, Item lootItem, float min, float max) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)block).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))), LootItem.m_79579_((ItemLike)lootItem).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)1)).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_())}));
        writer.accept(new ResourceLocation("allomancy", "blocks/" + name), LootTable.m_79147_().m_79161_(builder));
    }

    public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> writer) {
        for (int i = 0; i < WorldSetup.ORE_METALS.length; ++i) {
            Block ore = (Block)WorldSetup.ORE_BLOCKS.get(i).get();
            Block ds = (Block)WorldSetup.DEEPSLATE_ORE_BLOCKS.get(i).get();
            Item raw = (Item)WorldSetup.RAW_ORE_ITEMS.get(i).get();
            Block rawb = (Block)WorldSetup.RAW_ORE_BLOCKS.get(i).get();
            BlockLootTables.addSilkTouchBlock(writer, ForgeRegistries.BLOCKS.getKey((Object)ore).m_135815_(), ore, raw, 1.0f, 1.0f);
            BlockLootTables.addSilkTouchBlock(writer, ForgeRegistries.BLOCKS.getKey((Object)ds).m_135815_(), ds, raw, 1.0f, 1.0f);
            BlockLootTables.addSimpleBlock(writer, ForgeRegistries.BLOCKS.getKey((Object)rawb).m_135815_(), rawb);
        }
        BlockLootTables.addSimpleBlock(writer, "iron_button", (Block)ExtrasSetup.IRON_BUTTON.get());
        BlockLootTables.addSimpleBlock(writer, "inverted_iron_button", (Block)ExtrasSetup.INVERTED_IRON_BUTTON.get());
        BlockLootTables.addSimpleBlock(writer, "iron_lever", (Block)ExtrasSetup.IRON_LEVER.get());
        for (RegistryObject<Block> rblock : WorldSetup.STORAGE_BLOCKS) {
            if (rblock == null) continue;
            Block block = (Block)rblock.get();
            BlockLootTables.addSimpleBlock(writer, ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), block);
        }
    }
}

