/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.datagen;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.extras.block.IronButtonBlock;
import com.legobmw99.allomancy.modules.extras.block.IronLeverBlock;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import java.util.function.BiConsumer;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BlockStates
extends BlockStateProvider {
    public BlockStates(PackOutput gen, ExistingFileHelper exFileHelper) {
        super(gen, "allomancy", exFileHelper);
    }

    protected void registerStatesAndModels() {
        String path;
        Block block;
        for (RegistryObject<Block> rblock : WorldSetup.ORE_BLOCKS) {
            block = (Block)rblock.get();
            path = rblock.getId().m_135815_();
            this.singleTextureBlock(block, path, "block/" + path);
        }
        for (RegistryObject<Block> rblock : WorldSetup.DEEPSLATE_ORE_BLOCKS) {
            block = (Block)rblock.get();
            path = rblock.getId().m_135815_();
            this.singleTextureBlock(block, path, "block/" + path);
        }
        for (RegistryObject<Block> rblock : WorldSetup.RAW_ORE_BLOCKS) {
            block = (Block)rblock.get();
            path = rblock.getId().m_135815_();
            this.singleTextureBlock(block, path, "block/" + path);
        }
        for (RegistryObject<Block> rblock : WorldSetup.STORAGE_BLOCKS) {
            if (rblock == null) continue;
            block = (Block)rblock.get();
            path = rblock.getId().m_135815_();
            this.singleTextureBlock(block, path, "block/" + path);
        }
        this.createIronLeverBlock();
        this.createIronButtonBlock((IronButtonBlock)ExtrasSetup.IRON_BUTTON.get());
        this.createIronButtonBlock((IronButtonBlock)ExtrasSetup.INVERTED_IRON_BUTTON.get());
        this.simpleBlock((Block)WorldSetup.LIQUID_LERASIUM.get(), (ModelFile)this.models().getExistingFile(this.mcLoc("block/water")));
    }

    private void singleTextureBlock(Block block, String model, String texture) {
        Allomancy.LOGGER.debug("Creating Block Data for " + String.valueOf(ForgeRegistries.BLOCKS.getKey((Object)block)));
        this.simpleBlock(block);
    }

    private void createIronButtonBlock(IronButtonBlock block) {
        Allomancy.LOGGER.debug("Creating Block Data for allomancy:iron_button");
        ModelBuilder inventory = ((BlockModelBuilder)this.models().withExistingParent("allomancy:iron_button_inventory", this.mcLoc("block/button_inventory"))).texture("texture", this.mcLoc("block/iron_block"));
        ModelBuilder button = ((BlockModelBuilder)this.models().withExistingParent("allomancy:iron_button", this.mcLoc("block/button"))).texture("texture", this.mcLoc("block/iron_block"));
        ModelBuilder pressed = ((BlockModelBuilder)this.models().withExistingParent("allomancy:iron_button_pressed", this.mcLoc("block/button_pressed"))).texture("texture", this.mcLoc("block/iron_block"));
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
        for (Boolean powered : IronButtonBlock.f_51045_.m_6908_()) {
            ModelBuilder model = powered.booleanValue() == block.activatedOnPush() ? pressed : button;
            for (AttachFace face : IronButtonBlock.f_53179_.m_6908_()) {
                int xangle = face == AttachFace.CEILING ? 180 : (face == AttachFace.WALL ? 90 : 0);
                boolean uvlock = face == AttachFace.WALL;
                for (Direction dir : IronButtonBlock.f_54117_.m_6908_()) {
                    int yangle = (int)dir.m_122435_();
                    yangle = face != AttachFace.CEILING ? (yangle + 180) % 360 : yangle;
                    builder.partialState().with((Property)IronButtonBlock.f_51045_, (Comparable)powered).with((Property)IronButtonBlock.f_53179_, (Comparable)face).with((Property)IronButtonBlock.f_54117_, (Comparable)dir).modelForState().modelFile((ModelFile)model).uvLock(uvlock).rotationY(yangle).rotationX(xangle).addModel();
                }
            }
        }
    }

    private void createIronLeverBlock() {
        Allomancy.LOGGER.debug("Creating Block Data for allomancy:iron_lever");
        BiConsumer<Direction, ModelBuilder.ElementBuilder.FaceBuilder> base_generator = (dir, facebuilder) -> {
            switch (dir) {
                case UP: {
                    facebuilder.uvs(5.0f, 4.0f, 11.0f, 12.0f).texture("#base").end();
                    break;
                }
                case DOWN: {
                    facebuilder.uvs(5.0f, 4.0f, 11.0f, 12.0f).texture("#base").cullface(Direction.DOWN).end();
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    facebuilder.uvs(5.0f, 0.0f, 11.0f, 3.0f).texture("#base").end();
                    break;
                }
                case WEST: 
                case EAST: {
                    facebuilder.uvs(4.0f, 0.0f, 12.0f, 3.0f).texture("#base").end();
                }
            }
        };
        BiConsumer<Direction, ModelBuilder.ElementBuilder.FaceBuilder> lever_generator = (dir, facebuilder) -> {
            switch (dir) {
                case UP: {
                    facebuilder.uvs(7.0f, 6.0f, 9.0f, 8.0f).texture("#lever").end();
                    break;
                }
                case NORTH: 
                case SOUTH: 
                case WEST: 
                case EAST: {
                    facebuilder.uvs(7.0f, 6.0f, 9.0f, 16.0f).texture("#lever").end();
                    break;
                }
                case DOWN: {
                    facebuilder.end();
                }
            }
        };
        ModelBuilder lever_on = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("allomancy:iron_lever")).ao(false)).texture("particle", this.mcLoc("block/iron_block"))).texture("base", this.mcLoc("block/iron_block"))).texture("lever", this.modLoc("block/iron_lever"))).element().from(5.0f, 0.0f, 4.0f).to(11.0f, 3.0f, 12.0f).allFaces(base_generator).end()).element().from(7.0f, 1.0f, 7.0f).to(9.0f, 11.0f, 9.0f).rotation().origin(8.0f, 1.0f, 8.0f).axis(Direction.Axis.X).angle(-45.0f).end().allFaces(lever_generator).end();
        ModelBuilder lever_off = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("allomancy:iron_lever_off")).ao(false)).texture("particle", this.mcLoc("block/iron_block"))).texture("base", this.mcLoc("block/iron_block"))).texture("lever", this.modLoc("block/iron_lever"))).element().from(5.0f, 0.0f, 4.0f).to(11.0f, 3.0f, 12.0f).allFaces(base_generator).end()).element().from(7.0f, 1.0f, 7.0f).to(9.0f, 11.0f, 9.0f).rotation().origin(8.0f, 1.0f, 8.0f).axis(Direction.Axis.X).angle(45.0f).end().allFaces(lever_generator).end();
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)ExtrasSetup.IRON_LEVER.get());
        for (Boolean powered : IronLeverBlock.f_54622_.m_6908_()) {
            ModelBuilder model = powered != false ? lever_on : lever_off;
            for (AttachFace face : IronLeverBlock.f_53179_.m_6908_()) {
                int xangle = face == AttachFace.CEILING ? 180 : (face == AttachFace.WALL ? 90 : 0);
                for (Direction dir2 : IronLeverBlock.f_54117_.m_6908_()) {
                    int yangle = (int)dir2.m_122435_();
                    yangle = face != AttachFace.CEILING ? (yangle + 180) % 360 : yangle;
                    builder.partialState().with((Property)IronLeverBlock.f_54622_, (Comparable)powered).with((Property)IronLeverBlock.f_53179_, (Comparable)face).with((Property)IronLeverBlock.f_54117_, (Comparable)dir2).modelForState().modelFile((ModelFile)model).rotationY(yangle).rotationX(xangle).addModel();
                }
            }
        }
    }

    public String m_6055_() {
        return "Allomancy Blockstates";
    }
}

