/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.datagen;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockTags
extends BlockTagsProvider {
    public BlockTags(PackOutput gen, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper exFileHelper) {
        super(gen, lookupProvider, "allomancy", exFileHelper);
    }

    protected void m_6577_(HolderLookup.Provider pProvider) {
        for (int i = 0; i < WorldSetup.ORE_METALS.length; ++i) {
            ResourceKey block = WorldSetup.ORE_BLOCKS.get(i).getKey();
            ResourceKey ds = WorldSetup.DEEPSLATE_ORE_BLOCKS.get(i).getKey();
            ResourceKey raw = WorldSetup.RAW_ORE_BLOCKS.get(i).getKey();
            this.addForgeTag("ores/" + String.valueOf(WorldSetup.ORE_METALS[i]), block, ds);
            this.addForgeTag("ores", block, ds);
            this.addForgeTag("ores_in_ground/stone", block);
            this.addForgeTag("ores_in_ground/deepslate", ds);
            this.addForgeTag("storage_blocks", raw);
            this.addForgeTag("storage_blocks/raw_" + String.valueOf(WorldSetup.ORE_METALS[i]), raw);
            this.makePickaxeMineable(block, ds, raw);
        }
        for (Metal mt : Metal.values()) {
            if (mt.isVanilla()) continue;
            ResourceKey block = WorldSetup.STORAGE_BLOCKS.get(mt.getIndex()).getKey();
            this.addForgeTag("storage_blocks/" + mt.getName(), block);
            this.addForgeTag("storage_blocks", block);
            this.makePickaxeMineable(block);
            if (mt == Metal.ALUMINUM) continue;
            this.addBeacon(block);
        }
        ResourceKey lead = WorldSetup.STORAGE_BLOCKS.get(WorldSetup.LEAD).getKey();
        this.addForgeTag("storage_blocks/lead", lead);
        ResourceKey silver = WorldSetup.STORAGE_BLOCKS.get(WorldSetup.SILVER).getKey();
        this.addForgeTag("storage_blocks/silver", silver);
        this.addBeacon(silver);
        this.makePickaxeMineable(lead, silver);
        this.addForgeTag("storage_blocks", lead, silver);
    }

    private void addForgeTag(String name, ResourceKey<Block> ... items) {
        Allomancy.LOGGER.debug("Creating block tag for forge:" + name);
        this.m_206424_(net.minecraft.tags.BlockTags.create((ResourceLocation)new ResourceLocation("forge", name))).replace(false).m_211101_(items);
    }

    private void makePickaxeMineable(ResourceKey<Block> ... items) {
        this.m_206424_(net.minecraft.tags.BlockTags.f_144282_).replace(false).m_211101_(items);
        this.m_206424_(net.minecraft.tags.BlockTags.f_144286_).replace(false).m_211101_(items);
    }

    private void addBeacon(ResourceKey<Block> ... items) {
        this.m_206424_(net.minecraft.tags.BlockTags.f_13079_).replace(false).m_211101_(items);
    }

    public String m_6055_() {
        return "Allomancy Block Tags";
    }
}

