/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.datagen;

import com.legobmw99.allomancy.datagen.Advancements;
import com.legobmw99.allomancy.datagen.BlockLootTables;
import com.legobmw99.allomancy.datagen.BlockStates;
import com.legobmw99.allomancy.datagen.BlockTags;
import com.legobmw99.allomancy.datagen.DatapackEntries;
import com.legobmw99.allomancy.datagen.DungeonLootTables;
import com.legobmw99.allomancy.datagen.ItemModels;
import com.legobmw99.allomancy.datagen.ItemTagProvider;
import com.legobmw99.allomancy.datagen.Languages;
import com.legobmw99.allomancy.datagen.Recipes;
import com.legobmw99.allomancy.datagen.TagProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookup = event.getLookupProvider();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeServer(), (DataProvider)new Recipes(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTables::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(DungeonLootTables::new, LootContextParamSets.f_81410_))));
        BlockTags blocktags = new BlockTags(packOutput, lookup, fileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blocktags);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagProvider(packOutput, lookup, blocktags.m_274426_(), fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ForgeAdvancementProvider(packOutput, lookup, fileHelper, List.of(new Advancements())));
        DatapackEntries datapackProvider = new DatapackEntries(packOutput, lookup);
        CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(event.includeServer(), (DataProvider)datapackProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new TagProvider.Banners(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new TagProvider.Biomes(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new TagProvider.DamageTypes(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new TagProvider.Structures(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new TagProvider.EntityTypes(packOutput, lookupProvider, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new Languages(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStates(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(packOutput, fileHelper));
    }
}

