/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.datagen;

import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.combat.CombatSetup;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;

public class Languages
extends LanguageProvider {
    public Languages(PackOutput gen) {
        super(gen, "allomancy", "en_us");
    }

    private static String getDisplayName(Metal mt) {
        return Languages.toTitleCase(mt.getName());
    }

    private static String toTitleCase(String in) {
        return in.substring(0, 1).toUpperCase(Locale.US) + in.substring(1);
    }

    private static String getDisplayName(DyeColor color) {
        String[] trans = color.m_41065_().split("_");
        return Arrays.stream(trans).map(Languages::toTitleCase).collect(Collectors.joining(" "));
    }

    protected void addTranslations() {
        this.add("tabs.allomancy.main_tab", "Allomancy");
        for (int i = 0; i < WorldSetup.ORE_METALS.length; ++i) {
            String metal = WorldSetup.ORE_METALS[i].name();
            Block ore = (Block)WorldSetup.ORE_BLOCKS.get(i).get();
            Block block = (Block)WorldSetup.DEEPSLATE_ORE_BLOCKS.get(i).get();
            Block rawb = (Block)WorldSetup.RAW_ORE_BLOCKS.get(i).get();
            Item raw = (Item)WorldSetup.RAW_ORE_ITEMS.get(i).get();
            this.add(ore, Languages.toTitleCase(metal) + " Ore");
            this.add(block, "Deepslate " + Languages.toTitleCase(metal) + " Ore");
            this.add(rawb, "Block of Raw " + Languages.toTitleCase(metal));
            this.add(raw, "Raw " + Languages.toTitleCase(metal));
        }
        this.add((Block)ExtrasSetup.IRON_BUTTON.get(), "Iron Button");
        this.add((Block)ExtrasSetup.INVERTED_IRON_BUTTON.get(), "Inverted Iron Button");
        this.add((Block)ExtrasSetup.IRON_LEVER.get(), "Iron Lever");
        this.add("block.allomancy.iron_activation.lore", "This item seems too heavy to activate by ordinary means");
        this.add((Block)WorldSetup.LIQUID_LERASIUM.get(), "Concentrated Leras");
        this.add("fluid_type.allomancy.lerasium", "Concentrated Leras");
        this.add((Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), "Hand Grinder");
        this.add((Item)ConsumeSetup.LERASIUM_NUGGET.get(), "Lerasium Nugget");
        this.add("item.allomancy.lerasium_nugget.lore", "This item is endowed with strange powers, perhaps you should ingest it?");
        this.add((Item)CombatSetup.MISTCLOAK.get(), "Mistcloak");
        this.add((Item)ExtrasSetup.BRONZE_EARRING.get(), "Bronze Earring");
        this.add("item.allomancy.bronze_earring.lore", "Useless, but sharp...");
        this.add((Item)ExtrasSetup.CHARGED_BRONZE_EARRING.get(), "Charged Bronze Earring");
        this.add("item.allomancy.charged_bronze_earring.lore", "You hear a pulsing in the distance...");
        this.add((Item)CombatSetup.ALUMINUM_HELMET.get(), "Aluminum Helmet");
        this.add((Item)CombatSetup.COIN_BAG.get(), "Coin Bag");
        this.add((Item)CombatSetup.OBSIDIAN_DAGGER.get(), "Obsidian Dagger");
        this.add((Item)CombatSetup.KOLOSS_BLADE.get(), "Koloss Blade");
        this.add("item.allomancy.koloss_blade.lore", "This item is too heavy for the average person to wield.");
        this.add((Item)ConsumeSetup.VIAL.get(), "Allomantic Vial");
        this.add("allomancy.flake_storage.lore_single", "Contains %s");
        this.add("allomancy.flake_storage.lore_count", "Contains %s metals");
        this.add("allomancy.flake_storage.lore_inst", "Hold SHIFT to view");
        this.add("death.attack.allomancy.coin", "%1$s was perforated by coins from %2$s");
        for (Metal metal : Metal.values()) {
            this.add("metals." + metal.getName(), Languages.getDisplayName(metal));
            this.add("key.metals." + metal.getName(), "Toggle " + Languages.getDisplayName(metal));
            this.add((Item)WorldSetup.FLAKES.get(metal.getIndex()).get(), Languages.getDisplayName(metal) + " Flakes");
            this.add((Item)ExtrasSetup.PATTERN_ITEMS.get(metal.getIndex()).get(), "Banner Pattern");
            this.add("item.allomancy." + metal.getName() + "_pattern.desc", Languages.getDisplayName(metal) + " Symbol");
            if (metal.isVanilla()) continue;
            this.add((Item)WorldSetup.NUGGETS.get(metal.getIndex()).get(), Languages.getDisplayName(metal) + " Nugget");
            this.add((Item)WorldSetup.INGOTS.get(metal.getIndex()).get(), Languages.getDisplayName(metal) + " Ingot");
            this.add((Block)WorldSetup.STORAGE_BLOCKS.get(metal.getIndex()).get(), Languages.getDisplayName(metal) + " Block");
        }
        this.add((Item)WorldSetup.FLAKES.get(WorldSetup.LEAD).get(), "Lead Flakes");
        this.add((Item)WorldSetup.NUGGETS.get(WorldSetup.LEAD).get(), "Lead Nugget");
        this.add((Item)WorldSetup.INGOTS.get(WorldSetup.LEAD).get(), "Lead Ingot");
        this.add((Block)WorldSetup.STORAGE_BLOCKS.get(WorldSetup.LEAD).get(), "Lead Block");
        this.add((Item)WorldSetup.FLAKES.get(WorldSetup.SILVER).get(), "Silver Flakes");
        this.add((Item)WorldSetup.NUGGETS.get(WorldSetup.SILVER).get(), "Silver Nugget");
        this.add((Item)WorldSetup.INGOTS.get(WorldSetup.SILVER).get(), "Silver Ingot");
        this.add((Block)WorldSetup.STORAGE_BLOCKS.get(WorldSetup.SILVER).get(), "Silver Block");
        this.add((EntityType)CombatSetup.NUGGET_PROJECTILE.get(), "Nugget Projectile");
        this.add("advancements.allomancy.local_metallurgist.title", "Local Metallurgist!");
        this.add("advancements.allomancy.local_metallurgist.desc", "Craft a grinder to begin mixing metals");
        this.add("advancements.allomancy.dna_entangled.title", "Spiritual DNA Entanglement");
        this.add("advancements.allomancy.dna_entangled.desc", "Your DNA is too entangled with the spiritual realm to use Lerasium");
        this.add("advancements.allomancy.blinged_out.title", "A small gift");
        this.add("advancements.allomancy.blinged_out.desc", "What harm could a simple earring do?");
        this.add("advancements.allomancy.bloody.title", "Local... Hemalurgist?");
        this.add("advancements.allomancy.bloody.desc", "You now have blood on your hands (and ears)");
        this.add("advancements.allomancy.well.title", "Ascendant");
        this.add("advancements.allomancy.well.desc", "A well of great power");
        this.add("advancements.allomancy.become_mistborn.title", "Mistborn.");
        this.add("advancements.allomancy.become_mistborn.desc", "You have a power most people envy...");
        this.add("advancements.allomancy.metallic_collector.title", "Metallic Collector");
        this.add("advancements.allomancy.metallic_collector.desc", "Collect every single metallic flake, even the useless ones");
        this.add("advancements.allomancy.coinshot.title", "Coinshot");
        this.add("advancements.allomancy.coinshot.desc", "Kill a mob with the bag of coins.");
        this.add("advancements.allomancy.tin_foil_hat.title", "Tin foil hat");
        this.add("advancements.allomancy.tin_foil_hat.desc", "Protect yourself, and be a bit paranoid too");
        this.add("advancements.allomancy.time_warp.title", "Sub-time bubble?");
        this.add("advancements.allomancy.time_warp.desc", "Time travel? Not quite!");
        this.add("advancements.allomancy.consequences.title", "Consequences, Vin");
        this.add("advancements.allomancy.consequences.desc", "Learn what happens when you push on a much heavier target.");
        this.add("advancements.allomancy.going_loud.title", "Going Loud");
        this.add("advancements.allomancy.going_loud.desc", "Allomancy can grant great stealth, unless you do that!");
        this.add("key.categories.allomancy", "Allomancy");
        this.add("key.burn", "Burn Metals");
        this.add("key.hud", "Show Vial HUD");
        this.add("allomancy.gui", "Select Metal");
        this.add("commands.allomancy.getpowers", "%s currently has Allomantic powers: %s");
        this.add("commands.allomancy.addpower", "%s added Allomantic power %s");
        this.add("commands.allomancy.removepower", "%s removed Allomantic power %s");
        this.add("commands.allomancy.unrecognized", "Unrecognized Allomancy power: '%s'");
        this.add("commands.allomancy.err_add", "Unable to add power %s, already had");
        this.add("commands.allomancy.err_remove", "Unable to remove power %s, did not have");
        for (Metal metal : DyeColor.values()) {
            for (Metal mt : Metal.values()) {
                this.add("block.minecraft.banner.allomancy." + mt.getName() + "." + metal.m_41065_(), Languages.getDisplayName((DyeColor)metal) + " " + Languages.getDisplayName(mt) + " Symbol");
            }
        }
        this.add("config.jade.plugin_allomancy.waila_bronze", "Allomancy: Show burning metals when seeking");
        this.add("allomancy.jei.investing", "Investing");
        this.add("allomancy.jei.investing.description", "Seek the Well...");
        this.add("allomancy.jei.charged_earring.1", "This earring contains the life force of a magical entity.");
        this.add("allomancy.jei.charged_earring.2", "Obtaining it requires killing one of the more powerful monsters with the pointy end of an earring.");
        this.add("allomancy.jei.charged_earring.3", "Slip it in your ear once you've done this dirty work.");
        this.add("allomancy.jei.flake_input", "Multiple types of flake can be added at once.");
        this.add("allomancy.jei.vial_input", "Vials can have pre-existing contents, as long as they are not the same as the new flakes.");
        this.add("allomancy.jei.vial_output", "Will contain both the new flakes and any old ones.");
        this.add("allomancy.networking.failed", "Allomancy packet failed to play: %s");
        this.add("allomancy.networking.kicked", "Requested illegal action: %s");
    }
}

