/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.combat.entity;

import com.legobmw99.allomancy.modules.combat.CombatSetup;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class ProjectileNuggetEntity
extends ThrowableItemProjectile
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.m_135353_(ProjectileNuggetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private float damage;
    private boolean dropItem = true;

    public ProjectileNuggetEntity(double x, double y, double z, Level worldIn, ItemStack itemIn, float damageIn) {
        super((EntityType)CombatSetup.NUGGET_PROJECTILE.get(), x, y, z, worldIn);
        this.damage = damageIn;
        if (!itemIn.m_41619_()) {
            this.f_19804_.m_135381_(ITEM, (Object)itemIn.m_41777_());
        }
    }

    public ProjectileNuggetEntity(LivingEntity livingEntityIn, Level worldIn, ItemStack itemIn, float damageIn) {
        super((EntityType)CombatSetup.NUGGET_PROJECTILE.get(), livingEntityIn, worldIn);
        if (livingEntityIn instanceof Player) {
            Player player = (Player)livingEntityIn;
            if (player.m_150110_().f_35937_) {
                this.dropItem = false;
            }
        }
        if (!itemIn.m_41619_()) {
            this.f_19804_.m_135381_(ITEM, (Object)itemIn.m_41777_());
        }
        this.damage = damageIn;
    }

    public ProjectileNuggetEntity(EntityType<ProjectileNuggetEntity> entityEntityType, Level world) {
        super((EntityType)CombatSetup.NUGGET_PROJECTILE.get(), world);
        this.damage = 0.0f;
    }

    public ProjectileNuggetEntity(Level world, Entity other) {
        this((EntityType<ProjectileNuggetEntity>)((EntityType)CombatSetup.NUGGET_PROJECTILE.get()), world);
        if (other instanceof ProjectileNuggetEntity) {
            ProjectileNuggetEntity nugget = (ProjectileNuggetEntity)other;
            this.f_19804_.m_135381_(ITEM, (Object)nugget.m_7846_().m_41777_());
            this.damage = nugget.getDamage();
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ITEM, (Object)ItemStack.f_41583_);
    }

    protected void m_6532_(HitResult rayTraceResult) {
        if (rayTraceResult.m_6662_() == HitResult.Type.ENTITY && ((EntityHitResult)rayTraceResult).m_82443_() == this.m_19749_()) {
            return;
        }
        if (rayTraceResult.m_6662_() == HitResult.Type.ENTITY) {
            ((EntityHitResult)rayTraceResult).m_82443_().m_6469_(this.makeDamage(), this.damage);
        }
        if (!this.m_9236_().f_46443_) {
            ItemStack ammo = new ItemStack((ItemLike)((ItemStack)this.f_19804_.m_135370_(ITEM)).m_41720_(), 1);
            if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46136_) && rayTraceResult.m_6662_() != HitResult.Type.ENTITY && this.dropItem) {
                this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), ammo));
            }
            this.m_6074_();
        }
    }

    public ItemStack m_7846_() {
        return ((ItemStack)this.f_19804_.m_135370_(ITEM)).m_41619_() ? new ItemStack((ItemLike)this.m_7881_()) : (ItemStack)this.f_19804_.m_135370_(ITEM);
    }

    public float getDamage() {
        return this.damage;
    }

    protected Item m_7881_() {
        return Items.f_42587_;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private DamageSource makeDamage() {
        return new DamageSource((Holder)this.m_9236_().m_9598_().m_255025_(Registries.f_268580_).m_255043_(CombatSetup.COIN_DAMAGE), (Entity)this, this.m_19749_());
    }
}

