/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.consumables.item.recipe;

import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;

public class VialItemRecipe
extends CustomRecipe {
    private static final Ingredient INGREDIENT_FLAKES = Ingredient.m_43929_((ItemLike[])((ItemLike[])WorldSetup.FLAKES.subList(0, Metal.values().length).stream().map(RegistryObject::get).toArray(Item[]::new)));
    private static final Ingredient INGREDIENT_VIAL = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ConsumeSetup.VIAL.get()});
    private ItemStack item_result = ItemStack.f_41583_;

    public VialItemRecipe(ResourceLocation idIn, CraftingBookCategory catIn) {
        super(idIn, catIn);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        this.item_result = ItemStack.f_41583_;
        boolean[] metals = new boolean[Metal.values().length];
        Arrays.fill(metals, false);
        boolean[] ingredients = new boolean[]{false, false};
        for (int i = 0; i < inv.m_6643_(); ++i) {
            Metal mt;
            int n;
            int n2;
            Metal[] metalArray;
            ItemStack itemstack = inv.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            if (INGREDIENT_FLAKES.test(itemstack)) {
                metalArray = Metal.values();
                n2 = metalArray.length;
                for (n = 0; n < n2; ++n) {
                    mt = metalArray[n];
                    if (itemstack.m_41720_() != WorldSetup.FLAKES.get(mt.getIndex()).get()) continue;
                    if (metals[mt.getIndex()]) {
                        return false;
                    }
                    metals[mt.getIndex()] = true;
                    ingredients[1] = true;
                }
                continue;
            }
            if (INGREDIENT_VIAL.test(itemstack)) {
                if (itemstack.m_41783_() != null) {
                    metalArray = Metal.values();
                    n2 = metalArray.length;
                    for (n = 0; n < n2; ++n) {
                        mt = metalArray[n];
                        if (!itemstack.m_41783_().m_128441_(mt.getName())) continue;
                        boolean hasMetalAlready = itemstack.m_41783_().m_128471_(mt.getName());
                        if (metals[mt.getIndex()] && hasMetalAlready) {
                            return false;
                        }
                        metals[mt.getIndex()] = metals[mt.getIndex()] || hasMetalAlready;
                    }
                }
                ingredients[0] = true;
                continue;
            }
            return false;
        }
        if (ingredients[0] && ingredients[1]) {
            this.item_result = new ItemStack((ItemLike)ConsumeSetup.VIAL.get(), 1);
            CompoundTag nbt = new CompoundTag();
            for (Metal mt : Metal.values()) {
                nbt.m_128379_(mt.getName(), metals[mt.getIndex()]);
            }
            nbt.m_128405_("CustomModelData", 1);
            this.item_result.m_41751_(nbt);
            return true;
        }
        return false;
    }

    public ItemStack assemble(CraftingContainer p_44001_, RegistryAccess p_267165_) {
        return this.item_result.m_41777_();
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ConsumeSetup.VIAL_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    extends SimpleCraftingRecipeSerializer<VialItemRecipe> {
        public Serializer() {
            super(VialItemRecipe::new);
        }
    }
}

