/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.extras;

import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.extras.block.IronButtonBlock;
import com.legobmw99.allomancy.modules.extras.block.IronLeverBlock;
import com.legobmw99.allomancy.modules.extras.command.AllomancyPowerCommand;
import com.legobmw99.allomancy.modules.extras.command.AllomancyPowerType;
import com.legobmw99.allomancy.modules.extras.item.BronzeEarringItem;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ExtrasSetup {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"allomancy");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"allomancy");
    private static final DeferredRegister<BannerPattern> BP = DeferredRegister.create((ResourceKey)Registries.f_256969_, (String)"allomancy");
    public static final RegistryObject<BronzeEarringItem> BRONZE_EARRING = ITEMS.register("bronze_earring", BronzeEarringItem::new);
    public static final RegistryObject<BronzeEarringItem> CHARGED_BRONZE_EARRING = ITEMS.register("charged_bronze_earring", BronzeEarringItem::new);
    public static final RegistryObject<IronButtonBlock> IRON_BUTTON = BLOCKS.register("iron_button", () -> new IronButtonBlock(true));
    public static final RegistryObject<Item> IRON_BUTTON_ITEM = ITEMS.register("iron_button", () -> new BlockItem((Block)IRON_BUTTON.get(), new Item.Properties()));
    public static final RegistryObject<IronButtonBlock> INVERTED_IRON_BUTTON = BLOCKS.register("inverted_iron_button", () -> new IronButtonBlock(false));
    public static final RegistryObject<Item> INVERTED_IRON_BUTTON_ITEM = ITEMS.register("inverted_iron_button", () -> new BlockItem((Block)INVERTED_IRON_BUTTON.get(), new Item.Properties()));
    public static final RegistryObject<IronLeverBlock> IRON_LEVER = BLOCKS.register("iron_lever", IronLeverBlock::new);
    public static final RegistryObject<Item> IRON_LEVER_ITEM = ITEMS.register("iron_lever", () -> new BlockItem((Block)IRON_LEVER.get(), new Item.Properties()));
    public static final List<RegistryObject<BannerPattern>> PATTERNS = new ArrayList<RegistryObject<BannerPattern>>();
    public static final List<TagKey<BannerPattern>> PATTERN_KEYS = new ArrayList<TagKey<BannerPattern>>();
    public static final List<RegistryObject<BannerPatternItem>> PATTERN_ITEMS = new ArrayList<RegistryObject<BannerPatternItem>>();
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256982_, (String)"allomancy");
    private static final Supplier<SingletonArgumentInfo<AllomancyPowerType>> CONTAINER_CLASS = COMMAND_ARGUMENT_TYPES.register("allomancy_power", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(AllomancyPowerType.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(AllomancyPowerType::allomancyPowerType)));

    public static void register() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(bus);
        ITEMS.register(bus);
        BP.register(bus);
        COMMAND_ARGUMENT_TYPES.register(bus);
    }

    public static void registerCommands(RegisterCommandsEvent e) {
        AllomancyPowerCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    static {
        for (Metal mt : Metal.values()) {
            String name = mt.getName();
            RegistryObject pattern = BP.register(mt.getName(), () -> new BannerPattern("ALLOMANCY" + mt.name()));
            PATTERNS.add((RegistryObject<BannerPattern>)pattern);
            TagKey pattern_key = TagKey.m_203882_((ResourceKey)Registries.f_256969_, (ResourceLocation)new ResourceLocation("allomancy", name));
            PATTERN_KEYS.add((TagKey<BannerPattern>)pattern_key);
            RegistryObject pattern_item = ITEMS.register(name + "_pattern", () -> new BannerPatternItem(pattern_key, new Item.Properties().m_41487_(1)));
            PATTERN_ITEMS.add((RegistryObject<BannerPatternItem>)pattern_item);
        }
    }
}

