/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.extras.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.util.AllomancyTags;
import com.legobmw99.allomancy.util.ItemDisplay;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class BronzeEarringItem
extends ArmorItem {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public BronzeEarringItem() {
        super((ArmorMaterial)new BronzeMaterial(), ArmorItem.Type.HELMET, new Item.Properties().m_41487_(1));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 2.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.0, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (target.m_21224_() && target.m_6095_().m_204039_(AllomancyTags.HEMALURGIC_CHARGERS) && stack.m_41720_() != ExtrasSetup.CHARGED_BRONZE_EARRING.get()) {
            ItemStack itemstack = new ItemStack((ItemLike)ExtrasSetup.CHARGED_BRONZE_EARRING.get());
            CompoundTag compoundtag = stack.m_41783_();
            if (compoundtag != null) {
                itemstack.m_41751_(compoundtag.m_6426_());
            }
            attacker.m_21008_(InteractionHand.MAIN_HAND, itemstack);
        }
        return false;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        MutableComponent lore = pStack.m_41720_() == ExtrasSetup.BRONZE_EARRING.get() ? ItemDisplay.addColorToText("item.allomancy.bronze_earring.lore", ChatFormatting.GRAY) : ItemDisplay.addColorToText("item.allomancy.charged_bronze_earring.lore", ChatFormatting.BLUE);
        pTooltipComponents.add((Component)lore);
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return entity instanceof Player && armorType == EquipmentSlot.HEAD && stack.m_41720_() == ExtrasSetup.CHARGED_BRONZE_EARRING.get();
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        if (stack.m_41720_() == ExtrasSetup.CHARGED_BRONZE_EARRING.get()) {
            return EquipmentSlot.HEAD;
        }
        return null;
    }

    public Rarity m_41460_(ItemStack pStack) {
        if (pStack.m_41720_() == ExtrasSetup.CHARGED_BRONZE_EARRING.get()) {
            return Rarity.RARE;
        }
        return Rarity.COMMON;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND && stack.m_41720_() == ExtrasSetup.BRONZE_EARRING.get() ? this.defaultModifiers : super.getAttributeModifiers(slot, stack);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return stack.m_41720_() == ExtrasSetup.BRONZE_EARRING.get() && ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    private static class BronzeMaterial
    implements ArmorMaterial {
        private BronzeMaterial() {
        }

        public int m_266425_(ArmorItem.Type type) {
            return 0;
        }

        public int m_7366_(ArmorItem.Type type) {
            return 0;
        }

        public int m_6646_() {
            return 0;
        }

        public SoundEvent m_7344_() {
            return SoundEvents.f_11672_;
        }

        public Ingredient m_6230_() {
            return Ingredient.f_43901_;
        }

        public String m_6082_() {
            return "allomancy:bronze";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }
}

