/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers;

import com.legobmw99.allomancy.modules.powers.client.gui.MetalOverlay;
import com.legobmw99.allomancy.modules.powers.util.Physical;
import com.legobmw99.allomancy.util.AllomancyConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public class PowersConfig {
    public static final Set<String> whitelist = new HashSet<String>();
    public static ForgeConfigSpec.IntValue max_metal_detection;
    public static ForgeConfigSpec.BooleanValue animate_selection;
    public static ForgeConfigSpec.BooleanValue enable_overlay;
    public static ForgeConfigSpec.EnumValue<MetalOverlay.SCREEN_LOC> overlay_position;
    public static ForgeConfigSpec.BooleanValue random_mistings;
    public static ForgeConfigSpec.BooleanValue generate_whitelist;
    public static ForgeConfigSpec.BooleanValue respect_player_UUID;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> cfg_whitelist;

    public static void init(ForgeConfigSpec.Builder server_builder, ForgeConfigSpec.Builder common_builder, ForgeConfigSpec.Builder client_builder) {
        common_builder.comment("Settings for the gameplay elements of the mod").push("gameplay");
        random_mistings = common_builder.comment("Spawn players as a random Misting").define("random_mistings", true);
        respect_player_UUID = common_builder.comment("Decides whether your spawn metal is based off your UUID (this will cause it to be consistent across worlds)").define("respect_player_UUID", false);
        common_builder.pop();
        server_builder.comment("Settings for the gameplay elements of the mod").push("gameplay");
        generate_whitelist = server_builder.comment("Regenerate the metal whitelist").define("regenerate_whitelist", true);
        cfg_whitelist = server_builder.comment("List of registry names of items and blocks that are counted as 'metal'").defineList("whitelist", new ArrayList(), o -> o instanceof String);
        server_builder.pop();
        client_builder.push("graphics");
        max_metal_detection = client_builder.comment("Maximum iron/steelsight distance. Can have a HUGE impact on performance").defineInRange("max_metal_distance", 15, 3, 30);
        animate_selection = client_builder.comment("Animate the selection wheel").define("animate_selection", true);
        enable_overlay = client_builder.comment("Enable the screen overlay").define("overlay_enabled", true);
        overlay_position = client_builder.comment("Screen Overlay Position").defineEnum("overlay_position", (Enum)MetalOverlay.SCREEN_LOC.TOP_LEFT);
        client_builder.pop();
    }

    public static void refresh(ModConfigEvent e) {
        ModConfig cfg = e.getConfig();
        if (cfg.getSpec() == AllomancyConfig.SERVER_CONFIG) {
            PowersConfig.refresh_whitelist();
        }
    }

    private static void refresh_whitelist() {
        whitelist.clear();
        whitelist.addAll((Collection)cfg_whitelist.get());
    }

    public static void load_whitelist(ModConfigEvent.Loading e) {
        ModConfig cfg = e.getConfig();
        if (cfg.getSpec() == AllomancyConfig.SERVER_CONFIG) {
            if (((Boolean)generate_whitelist.get()).booleanValue()) {
                cfg_whitelist.set(Physical.default_whitelist());
                generate_whitelist.set((Object)false);
            }
            PowersConfig.refresh_whitelist();
        }
    }
}

