/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.client;

import com.legobmw99.allomancy.api.data.IAllomancerData;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.powers.client.gui.MetalSelectScreen;
import com.legobmw99.allomancy.modules.powers.client.network.PowerRequests;
import com.legobmw99.allomancy.modules.powers.client.util.Inputs;
import com.legobmw99.allomancy.modules.powers.client.util.Rendering;
import com.legobmw99.allomancy.modules.powers.client.util.Sounds;
import com.legobmw99.allomancy.modules.powers.client.util.Tracking;
import com.legobmw99.allomancy.modules.powers.data.AllomancerCapability;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEventHandler {
    private static final Tracking tracking = new Tracking();

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.phase != TickEvent.Phase.END || mc.m_91104_() || mc.f_91074_ == null || !mc.f_91074_.m_6084_()) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
            HitResult trace;
            int dist_modifier;
            if (data.isUninvested()) {
                return;
            }
            int n = dist_modifier = data.isEnhanced() ? 2 : 1;
            if (mc.f_91066_.f_92096_.m_90857_()) {
                trace = Inputs.getMouseOverExtended(20.0f * (float)dist_modifier);
                PowerRequests.metallicPushPull(data, trace, Metal.IRON);
                PowerRequests.emotionPushPull(data, trace, Metal.ZINC);
            }
            if (mc.f_91066_.f_92095_.m_90857_()) {
                trace = Inputs.getMouseOverExtended(20.0f * (float)dist_modifier);
                PowerRequests.metallicPushPull(data, trace, Metal.STEEL);
                PowerRequests.emotionPushPull(data, trace, Metal.BRASS);
                PowerRequests.nicrosilEnhance(data, trace);
            }
            tracking.tick();
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        if (event.getAction() == 1) {
            Inputs.acceptAllomancyKeybinds();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton.Pre event) {
        if (event.getAction() == 1) {
            Inputs.acceptAllomancyKeybinds();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || !player.m_6084_() || mc.f_91066_.m_92176_().m_90613_()) {
            return;
        }
        player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(arg_0 -> ClientEventHandler.lambda$onRenderLevelStage$5(event, (Player)player, mc, arg_0));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onFovCompute(ComputeFovModifierEvent event) {
        event.getPlayer().getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
            if (data.isBurning(Metal.TIN) && data.isEnhanced()) {
                event.setNewFovModifier(0.2f);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onSound(PlaySoundEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        SoundInstance sound = event.getSound();
        if (player == null || sound == null || !player.m_6084_()) {
            return;
        }
        player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(arg_0 -> ClientEventHandler.lambda$onSound$7((Player)player, sound, arg_0));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void updateInputEvent(MovementInputUpdateEvent event) {
        if (Minecraft.m_91087_().f_91080_ instanceof MetalSelectScreen) {
            Inputs.fakeMovement(event.getInput());
        }
    }

    private static /* synthetic */ void lambda$onSound$7(Player player, SoundInstance sound, IAllomancerData data) {
        if (data.isBurning(Metal.TIN)) {
            Sounds.spawnParticleForSound(player, sound);
        }
    }

    private static /* synthetic */ void lambda$onRenderLevelStage$5(RenderLevelStageEvent event, Player player, Minecraft mc, IAllomancerData data) {
        GlobalPos seeking;
        if (data.isUninvested()) {
            return;
        }
        float partialTick = event.getPartialTick();
        PoseStack stack = Rendering.prepareToDrawLines(event.getPoseStack(), partialTick);
        double rho = 1.0;
        float theta = (float)((double)(player.m_5675_(partialTick) + 90.0f) * Math.PI / 180.0);
        float phi = Mth.m_14036_((float)((float)((double)(player.m_5686_(partialTick) + 90.0f) * Math.PI / 180.0)), (float)1.0E-4f, (float)3.14f);
        Vec3 playervec = mc.f_91075_.m_20299_(partialTick).m_82520_(rho * (double)Mth.m_14031_((float)phi) * (double)Mth.m_14089_((float)theta), rho * (double)Mth.m_14089_((float)phi) - (double)0.35f, rho * (double)Mth.m_14031_((float)phi) * (double)Mth.m_14031_((float)theta));
        if (data.isBurning(Metal.IRON) || data.isBurning(Metal.STEEL)) {
            tracking.forEachMetallicEntity(entity -> Rendering.drawMetalLine(stack, playervec, entity.m_20182_(), 1.5f, 0.0f, 0.6f, 1.0f));
            tracking.forEachMetalBlob(blob -> Rendering.drawMetalLine(stack, playervec, blob.getCenter(), Mth.m_14036_((float)(0.3f + (float)blob.size() * 0.4f), (float)0.5f, (float)7.5f), 0.0f, 0.6f, 1.0f));
        }
        if ((seeking = data.getSpecialSeekingLoc()) != null && player.m_9236_().m_46472_() == seeking.m_122640_()) {
            Rendering.drawMetalLine(stack, playervec, seeking.m_122646_().m_252807_(), 5.0f, 0.7f, 0.15f, 0.15f);
        }
        if (data.isBurning(Metal.BRONZE) && (data.isEnhanced() || !data.isBurning(Metal.COPPER))) {
            tracking.forEachSeeked(playerEntity -> Rendering.drawMetalLine(stack, playervec, playerEntity.m_20182_(), 5.0f, 0.7f, 0.15f, 0.15f));
        }
        if (data.isBurning(Metal.GOLD)) {
            player.m_219759_().ifPresent(death -> {
                if (player.m_9236_().m_46472_() == death.m_122640_()) {
                    Rendering.drawMetalLine(stack, playervec, Vec3.m_82512_((Vec3i)death.m_122646_()), 3.0f, 0.9f, 0.85f, 0.0f);
                }
            });
        }
        if (data.isBurning(Metal.ELECTRUM)) {
            GlobalPos spawn = data.getSpawnLoc();
            if (spawn == null && player.m_9236_().m_46472_() == Level.f_46428_) {
                LevelData levelData = player.m_9236_().m_6106_();
                BlockPos spawnLoc = new BlockPos(levelData.m_6789_(), levelData.m_6527_(), levelData.m_6526_());
                Rendering.drawMetalLine(stack, playervec, Vec3.m_82512_((Vec3i)spawnLoc), 3.0f, 0.7f, 0.8f, 0.2f);
            } else if (spawn != null && player.m_9236_().m_46472_() == spawn.m_122640_()) {
                Rendering.drawMetalLine(stack, playervec, Vec3.m_82512_((Vec3i)spawn.m_122646_()), 3.0f, 0.7f, 0.8f, 0.2f);
            }
        }
        Rendering.doneDrawingLines(stack);
    }
}

