/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.client.gui;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.powers.PowersConfig;
import com.legobmw99.allomancy.modules.powers.client.gui.MetalSelectScreen;
import com.legobmw99.allomancy.modules.powers.data.AllomancerCapability;
import java.awt.Point;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public final class MetalOverlay
implements IGuiOverlay {
    private static final ResourceLocation METER_TEXTURE = Allomancy.rl("textures/gui/overlay/meter.png");
    private static final int OUTLINE_COLOR = -10132123;
    private static final Point[] BURNING_FRAMES = new Point[4];
    private int currentFrame = 0;

    private MetalOverlay() {
    }

    public static void registerGUI(RegisterGuiOverlaysEvent evt) {
        evt.registerAboveAll("metal_display", (IGuiOverlay)new MetalOverlay());
    }

    private static void blit(GuiGraphics graphics, int x, int y, float uOffset, float vOffset, int uWidth, int vHeight) {
        graphics.m_280398_(METER_TEXTURE, x, y, 0, uOffset, vOffset, uWidth, vHeight, 128, 128);
    }

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (mc.f_91066_.f_92062_ || !player.m_6084_()) {
            return;
        }
        if (!((Boolean)PowersConfig.enable_overlay.get()).booleanValue() && !(mc.f_91080_ instanceof MetalSelectScreen)) {
            return;
        }
        player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
            if (data.isUninvested()) {
                return;
            }
            Metal highlight = null;
            Screen patt2515$temp = mc.f_91080_;
            if (patt2515$temp instanceof MetalSelectScreen) {
                MetalSelectScreen select = (MetalSelectScreen)patt2515$temp;
                highlight = select.selectedMetal;
            }
            int renderX = ((SCREEN_LOC)((Object)((Object)PowersConfig.overlay_position.get()))).getX(screenWidth);
            int renderY = ((SCREEN_LOC)((Object)((Object)PowersConfig.overlay_position.get()))).getY(screenHeight);
            for (Metal mt : Metal.values()) {
                if (!data.hasPower(mt)) continue;
                int metalY = 9 - data.getStored(mt);
                int i = mt.getIndex();
                int offset = i / 2 * 4;
                int xCorner = renderX + 7 * i + offset;
                MetalOverlay.blit(guiGraphics, xCorner + 1, renderY + 5 + metalY, 7 + 6 * i, 1 + metalY, 3, 10 - metalY);
                MetalOverlay.blit(guiGraphics, xCorner, renderY, 0.0f, 0.0f, 5, 20);
                if (data.isBurning(mt)) {
                    int frameCount = (this.currentFrame + i) % 4;
                    Point frame = BURNING_FRAMES[frameCount];
                    MetalOverlay.blit(guiGraphics, xCorner, renderY + 4 + metalY, frame.x, frame.y, 5, 3);
                }
                if (highlight != mt) continue;
                guiGraphics.m_280637_(xCorner - 1, renderY - 1, 7, 21, -10132123);
            }
            if (mc.f_91065_.m_93079_() % 6 == 0) {
                ++this.currentFrame;
                if (this.currentFrame > 3) {
                    this.currentFrame = 0;
                }
            }
        });
    }

    static {
        int x = 0;
        int firsty = 22;
        for (int i = 0; i < 4; ++i) {
            MetalOverlay.BURNING_FRAMES[i] = new Point(x, firsty + 4 * i);
        }
    }

    public static enum SCREEN_LOC {
        TOP_RIGHT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        BOTTOM_LEFT;


        private int getX(int screenWidth) {
            return switch (this) {
                case TOP_RIGHT, BOTTOM_RIGHT -> screenWidth - 145;
                default -> 5;
            };
        }

        private int getY(int screenHeight) {
            return switch (this) {
                case BOTTOM_RIGHT, BOTTOM_LEFT -> screenHeight - 50;
                default -> 10;
            };
        }
    }
}

