/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.client.util;

import com.legobmw99.allomancy.api.data.IAllomancerData;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.powers.PowersConfig;
import com.legobmw99.allomancy.modules.powers.data.AllomancerCapability;
import com.legobmw99.allomancy.modules.powers.util.Physical;
import com.legobmw99.allomancy.util.DoubleBufferList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Tracking {
    private final List<Entity> metal_entities = new ArrayList<Entity>();
    private final DoubleBufferList<MetalBlockBlob> metal_blobs = new DoubleBufferList();
    private final List<Player> nearby_allomancers = new ArrayList<Player>();
    private final Deque<BlockPos> to_consider = new ArrayDeque<BlockPos>(400);
    private final Set<Long> seen = new LongOpenHashSet(400);
    private Future<?> blobFuture = null;

    public void forEachSeeked(Consumer<Player> f) {
        this.nearby_allomancers.forEach(f);
    }

    public void forEachMetallicEntity(Consumer<Entity> f) {
        this.metal_entities.forEach(f);
    }

    public void forEachMetalBlob(Consumer<MetalBlockBlob> f) {
        this.metal_blobs.forEach(f);
    }

    public void tick() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(arg_0 -> this.lambda$tick$4((Player)player, arg_0));
    }

    private void searchNearbyMetalBlocks(BlockPos origin, int range, BlockPos starter, Level level) {
        BlockState starterState = level.m_8055_(starter);
        if (!this.seen.add(starter.m_121878_()) || !Physical.isBlockStateMetallic(starterState)) {
            return;
        }
        MetalBlockBlob blob = new MetalBlockBlob(starter, starterState);
        int range_sqr = 4 * range * range;
        this.to_consider.clear();
        this.to_consider.addFirst(starter);
        while (!this.to_consider.isEmpty()) {
            BlockPos pos = this.to_consider.removeLast();
            for (BlockPos next : BlockPos.m_121925_((BlockPos)pos, (int)1, (int)1, (int)1)) {
                BlockState nextState;
                if (!this.seen.add(next.m_121878_()) || !(origin.m_203193_((Position)next.m_252807_()) < (double)range_sqr) || !Physical.isBlockStateMetallic(nextState = level.m_8055_(next))) continue;
                blob.add(next, nextState);
                this.to_consider.add(next.m_7949_());
            }
        }
        this.metal_blobs.add(blob);
    }

    private boolean seek(IAllomancerData data, Player otherPlayer) {
        return otherPlayer.getCapability(AllomancerCapability.PLAYER_CAP).map(otherData -> {
            if (otherData.isBurning(Metal.COPPER) && (!data.isEnhanced() || otherData.isEnhanced())) {
                return false;
            }
            if (Arrays.stream(Metal.values()).anyMatch(otherData::isBurning)) {
                this.nearby_allomancers.add(otherPlayer);
            }
            return true;
        }).orElse(true);
    }

    private /* synthetic */ void lambda$tick$4(Player player, IAllomancerData data) {
        if (data.isBurning(Metal.IRON) || data.isBurning(Metal.STEEL)) {
            int max = (Integer)PowersConfig.max_metal_detection.get();
            BlockPos negative = player.m_20183_().m_7918_(-max, -max, -max);
            BlockPos positive = player.m_20183_().m_7918_(max, max, max);
            this.metal_entities.clear();
            this.metal_entities.addAll(player.m_9236_().m_6443_(Entity.class, AABB.m_82321_((BoundingBox)BoundingBox.m_162375_((Vec3i)negative, (Vec3i)positive)), e -> Physical.isEntityMetallic(e) && !e.equals((Object)player)));
            if (this.blobFuture == null || this.blobFuture.isDone()) {
                this.blobFuture = Util.m_183991_().submit(() -> {
                    this.seen.clear();
                    BlockPos.m_121976_((int)negative.m_123341_(), (int)negative.m_123342_(), (int)negative.m_123343_(), (int)positive.m_123341_(), (int)positive.m_123342_(), (int)positive.m_123343_()).forEach(starter -> this.searchNearbyMetalBlocks(player.m_20183_(), max, (BlockPos)starter, player.m_9236_()));
                    this.metal_blobs.commitAndClear();
                });
            }
        } else if (this.blobFuture != null) {
            this.blobFuture = null;
            this.metal_blobs.clearBothAsync(Util.m_183991_());
            this.metal_entities.clear();
        }
        this.nearby_allomancers.clear();
        if (data.isBurning(Metal.BRONZE) && (data.isEnhanced() || !data.isBurning(Metal.COPPER))) {
            Vec3 negative = player.m_20182_().m_82520_(-30.0, -30.0, -30.0);
            Vec3 positive = player.m_20182_().m_82520_(30.0, 30.0, 30.0);
            List nearby_players = player.m_9236_().m_6443_(Player.class, new AABB(negative, positive), entity -> entity != null && entity != player);
            for (Player otherPlayer : nearby_players) {
                if (this.seek(data, otherPlayer)) continue;
                this.nearby_allomancers.clear();
                break;
            }
        }
    }

    public static class MetalBlockBlob {
        private static final Level level = Minecraft.m_91087_().f_91073_;
        private int blocks = 1;
        private Vec3 center;

        private MetalBlockBlob(BlockPos initial, BlockState initialState) {
            this.center = MetalBlockBlob.getCenterOfBlock(initial, initialState);
        }

        private static Vec3 getCenterOfBlock(BlockPos pos, BlockState state) {
            VoxelShape shape = state.m_60808_((BlockGetter)level, pos);
            if (shape.m_83281_()) {
                return Vec3.m_82512_((Vec3i)pos);
            }
            return Vec3.m_82528_((Vec3i)pos).m_82549_(shape.m_83215_().m_82399_());
        }

        public int size() {
            return this.blocks;
        }

        private void add(BlockPos pos, BlockState state) {
            ++this.blocks;
            this.center = this.center.m_82490_((double)(this.blocks - 1)).m_82549_(MetalBlockBlob.getCenterOfBlock(pos, state)).m_82490_(1.0 / (double)this.blocks);
        }

        public Vec3 getCenter() {
            return this.center;
        }

        public String toString() {
            return "MetalBlockBlob{blocks=" + this.blocks + ", center=" + String.valueOf(this.center) + "}";
        }
    }
}

