/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.data;

import com.legobmw99.allomancy.api.data.IAllomancerData;
import com.legobmw99.allomancy.api.enums.Metal;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DefaultAllomancerData
implements IAllomancerData {
    private static final int[] MAX_BURN_TIME = new int[]{1800, 1800, 3600, 600, 1800, 1800, 2400, 1600, 100, 20, 300, 40, 1000, 10000, 3600, 160};
    private final boolean[] allomantic_powers;
    private final int[] burn_time;
    private final int[] metal_amounts;
    private final boolean[] burning_metals;
    private int damage_stored;
    private GlobalPos spawn_pos;
    private GlobalPos seeking_pos;
    private int enhanced_time;

    public DefaultAllomancerData() {
        int powers = Metal.values().length;
        this.allomantic_powers = new boolean[powers];
        Arrays.fill(this.allomantic_powers, false);
        this.metal_amounts = new int[powers];
        Arrays.fill(this.metal_amounts, 0);
        this.burn_time = Arrays.copyOf(MAX_BURN_TIME, powers);
        this.burning_metals = new boolean[powers];
        Arrays.fill(this.burning_metals, false);
        this.enhanced_time = 0;
        this.damage_stored = 0;
        this.seeking_pos = null;
        this.spawn_pos = null;
    }

    @Override
    public boolean tickBurning() {
        boolean sync = false;
        for (Metal metal : Metal.values()) {
            if (!this.isBurning(metal)) continue;
            if (!this.hasPower(metal)) {
                this.setBurning(metal, false);
                sync = true;
                continue;
            }
            int n = metal.getIndex();
            this.burn_time[n] = this.burn_time[n] - 1;
            if (this.burn_time[metal.getIndex()] > 0) continue;
            if (this.getStored(metal) <= 0) {
                this.setBurning(metal, false);
            } else {
                this.decrementStored(metal);
            }
            sync = true;
            this.burn_time[metal.getIndex()] = MAX_BURN_TIME[metal.getIndex()];
        }
        return sync;
    }

    @Override
    public boolean hasPower(Metal metal) {
        return this.allomantic_powers[metal.getIndex()];
    }

    @Override
    public int getPowerCount() {
        int count = 0;
        for (boolean power : this.allomantic_powers) {
            if (!power) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Metal[] getPowers() {
        return (Metal[])Arrays.stream(Metal.values()).filter(this::hasPower).toArray(Metal[]::new);
    }

    @Override
    public boolean isMistborn() {
        for (boolean power : this.allomantic_powers) {
            if (power) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setMistborn() {
        Arrays.fill(this.allomantic_powers, true);
    }

    @Override
    public boolean isUninvested() {
        for (boolean power : this.allomantic_powers) {
            if (!power) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setUninvested() {
        Arrays.fill(this.allomantic_powers, false);
    }

    @Override
    public void addPower(Metal metal) {
        this.allomantic_powers[metal.getIndex()] = true;
    }

    @Override
    public void revokePower(Metal metal) {
        this.allomantic_powers[metal.getIndex()] = false;
    }

    @Override
    public boolean isBurning(Metal metal) {
        return this.burning_metals[metal.getIndex()];
    }

    @Override
    public void setBurning(Metal metal, boolean metalBurning) {
        this.burning_metals[metal.getIndex()] = metalBurning;
    }

    @Override
    public int getStored(Metal metal) {
        return this.metal_amounts[metal.getIndex()];
    }

    @Override
    public void incrementStored(Metal metal) {
        if (this.metal_amounts[metal.getIndex()] < 10) {
            int n = metal.getIndex();
            this.metal_amounts[n] = this.metal_amounts[n] + 1;
        }
    }

    @Override
    public void decrementStored(Metal metal) {
        if (this.metal_amounts[metal.getIndex()] > 0) {
            int n = metal.getIndex();
            this.metal_amounts[n] = this.metal_amounts[n] - 1;
        }
    }

    @Override
    public void drainMetals(Metal ... metals) {
        for (Metal mt : metals) {
            this.metal_amounts[mt.getIndex()] = 0;
            this.burn_time[mt.getIndex()] = 1;
        }
    }

    @Override
    public int getDamageStored() {
        return this.damage_stored;
    }

    @Override
    public void setDamageStored(int damageStored) {
        this.damage_stored = damageStored;
    }

    @Override
    public void setSpawnLoc(BlockPos pos, ResourceKey<Level> dim) {
        if (pos != null && dim != null) {
            this.spawn_pos = GlobalPos.m_122643_(dim, (BlockPos)pos);
        }
    }

    @Override
    @Nullable
    public GlobalPos getSpawnLoc() {
        return this.spawn_pos;
    }

    @Override
    public void setSpecialSeekingLoc(BlockPos pos, ResourceKey<Level> dim) {
        this.seeking_pos = pos != null && dim != null ? GlobalPos.m_122643_(dim, (BlockPos)pos) : null;
    }

    @Override
    @Nullable
    public GlobalPos getSpecialSeekingLoc() {
        return this.seeking_pos;
    }

    @Override
    public void decrementEnhanced() {
        if (this.isEnhanced()) {
            --this.enhanced_time;
        }
    }

    @Override
    public boolean isEnhanced() {
        return this.enhanced_time > 0;
    }

    @Override
    public void setEnhanced(int time) {
        this.enhanced_time = time;
    }

    @Override
    public CompoundTag save() {
        CompoundTag allomancy_data = new CompoundTag();
        CompoundTag abilities = new CompoundTag();
        for (Metal mt : Metal.values()) {
            abilities.m_128379_(mt.getName(), this.hasPower(mt));
        }
        allomancy_data.m_128365_("abilities", (Tag)abilities);
        CompoundTag metal_storage = new CompoundTag();
        for (Metal mt : Metal.values()) {
            metal_storage.m_128405_(mt.getName(), this.getStored(mt));
        }
        allomancy_data.m_128365_("metal_storage", (Tag)metal_storage);
        CompoundTag metal_burning = new CompoundTag();
        for (Metal mt : Metal.values()) {
            metal_burning.m_128379_(mt.getName(), this.isBurning(mt));
        }
        allomancy_data.m_128365_("metal_burning", (Tag)metal_burning);
        CompoundTag position = new CompoundTag();
        if (this.spawn_pos != null) {
            position.m_128359_("spawn_dimension", this.spawn_pos.m_122640_().m_135782_().toString());
            BlockPos spawn_block = this.spawn_pos.m_122646_();
            position.m_128405_("spawn_x", spawn_block.m_123341_());
            position.m_128405_("spawn_y", spawn_block.m_123342_());
            position.m_128405_("spawn_z", spawn_block.m_123343_());
        }
        if (this.seeking_pos != null) {
            position.m_128359_("seeking_dimension", this.seeking_pos.m_122640_().m_135782_().toString());
            BlockPos spawn_block = this.seeking_pos.m_122646_();
            position.m_128405_("seeking_x", spawn_block.m_123341_());
            position.m_128405_("seeking_y", spawn_block.m_123342_());
            position.m_128405_("seeking_z", spawn_block.m_123343_());
        }
        allomancy_data.m_128365_("position", (Tag)position);
        return allomancy_data;
    }

    @Override
    public void load(CompoundTag allomancy_data) {
        CompoundTag abilities = allomancy_data.m_128469_("abilities");
        for (Metal mt : Metal.values()) {
            if (abilities.m_128471_(mt.getName())) {
                this.addPower(mt);
                continue;
            }
            this.revokePower(mt);
        }
        CompoundTag metal_storage = allomancy_data.m_128469_("metal_storage");
        for (Metal mt : Metal.values()) {
            this.metal_amounts[mt.getIndex()] = metal_storage.m_128451_(mt.getName());
        }
        CompoundTag metal_burning = allomancy_data.m_128469_("metal_burning");
        for (Metal mt : Metal.values()) {
            this.setBurning(mt, metal_burning.m_128471_(mt.getName()));
        }
        CompoundTag position = allomancy_data.m_128469_("position");
        if (position.m_128441_("spawn_dimension")) {
            this.setSpawnLoc(new BlockPos(position.m_128451_("spawn_x"), position.m_128451_("spawn_y"), position.m_128451_("spawn_z")), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(position.m_128461_("spawn_dimension"))));
        }
        if (position.m_128441_("seeking_dimension")) {
            this.setSpecialSeekingLoc(new BlockPos(position.m_128451_("seeking_x"), position.m_128451_("seeking_y"), position.m_128451_("seeking_z")), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(position.m_128461_("seeking_dimension"))));
        } else {
            this.setSpecialSeekingLoc(null, null);
        }
    }
}

