/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.network;

import com.legobmw99.allomancy.api.data.IAllomancerData;
import com.legobmw99.allomancy.modules.powers.data.AllomancerCapability;
import com.legobmw99.allomancy.modules.powers.util.Emotional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ChangeEmotionPacket {
    private final int entityID;
    private final boolean make_aggressive;

    public ChangeEmotionPacket(int entityID, boolean make_aggressive) {
        this.entityID = entityID;
        this.make_aggressive = make_aggressive;
    }

    public static ChangeEmotionPacket decode(FriendlyByteBuf buf) {
        return new ChangeEmotionPacket(buf.readInt(), buf.readBoolean());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.make_aggressive);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer allomancer = ((NetworkEvent.Context)ctx.get()).getSender();
            PathfinderMob target = (PathfinderMob)allomancer.m_9236_().m_6815_(this.entityID);
            if (target == null) {
                return;
            }
            boolean enhanced = allomancer.getCapability(AllomancerCapability.PLAYER_CAP).filter(IAllomancerData::isEnhanced).isPresent();
            if (this.make_aggressive) {
                Emotional.riot(target, (Player)allomancer, enhanced);
            } else {
                Emotional.soothe(target, (Player)allomancer, enhanced);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

