/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.util;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.modules.combat.CombatSetup;
import com.legobmw99.allomancy.modules.combat.entity.ProjectileNuggetEntity;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.powers.PowersConfig;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;

public class Physical {
    private static final Pattern ACTIVE_METAL_REGEX = Pattern.compile(".*(iron|steel|tin_|pewter|zinc|brass|copper|bronze|duralumin|chromium|nicrosil|gold|electrum|cadmium|bendalloy|lead_|silver|platinum|nickle).*");
    private static HashSet<String> defaultList;

    public static boolean isBlockStateMetallic(BlockState state) {
        return Physical.isBlockMetallic(state.m_60734_());
    }

    public static boolean isBlockMetallic(Block block) {
        return Physical.isOnWhitelist(BuiltInRegistries.f_256975_.m_7981_((Object)block).toString());
    }

    public static boolean isItemMetallic(ItemStack item) {
        return Physical.isOnWhitelist(BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_()).toString());
    }

    private static boolean isOnWhitelist(String s) {
        return PowersConfig.whitelist.contains(s);
    }

    public static boolean isEntityMetallic(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            return Physical.isItemMetallic(item.m_32055_());
        }
        if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            return Physical.isItemMetallic(itemFrame.m_31822_());
        }
        if (entity instanceof FallingBlockEntity) {
            FallingBlockEntity fbe = (FallingBlockEntity)entity;
            return Physical.isBlockStateMetallic(fbe.m_31980_());
        }
        if (entity instanceof ProjectileNuggetEntity) {
            return true;
        }
        if (entity instanceof AbstractMinecart) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity ent = (LivingEntity)entity;
            if (ent instanceof IronGolem) {
                return true;
            }
            if (Physical.isItemMetallic(ent.m_21120_(InteractionHand.MAIN_HAND)) || Physical.isItemMetallic(ent.m_21120_(InteractionHand.OFF_HAND))) {
                return true;
            }
            for (ItemStack itemStack : ent.m_6168_()) {
                if (!Physical.isItemMetallic(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean doesResourceContainMetal(ResourceLocation input) {
        return ACTIVE_METAL_REGEX.matcher(input.m_135815_()).matches();
    }

    public static void lurch(double directionScalar, Entity toMove, BlockPos block) {
        if (toMove.m_20159_()) {
            toMove = toMove.m_20202_();
        }
        Vec3 motion = toMove.m_20182_().m_82546_(Vec3.m_82512_((Vec3i)block)).m_82541_().m_82490_(directionScalar * 1.1);
        Vec3 mod = Physical.clamp(Physical.cutoff(motion.m_82549_(toMove.m_20184_()), 0.1), Physical.abs(motion).m_82548_(), Physical.abs(motion));
        toMove.m_20256_(mod);
        toMove.f_19864_ = true;
        if (toMove instanceof ServerPlayer) {
            toMove.f_19789_ = 0.0f;
        }
    }

    private static Vec3 clamp(Vec3 value, Vec3 min, Vec3 max) {
        return new Vec3(Mth.m_14008_((double)value.f_82479_, (double)min.f_82479_, (double)max.f_82479_), Mth.m_14008_((double)value.f_82480_, (double)min.f_82480_, (double)max.f_82480_), Mth.m_14008_((double)value.f_82481_, (double)min.f_82481_, (double)max.f_82481_));
    }

    private static Vec3 abs(Vec3 vec) {
        return new Vec3(Math.abs(vec.f_82479_), Math.abs(vec.f_82480_), Math.abs(vec.f_82481_));
    }

    private static Vec3 cutoff(Vec3 value, double e) {
        Vec3 mag = Physical.abs(value);
        return new Vec3(mag.f_82479_ < e ? 0.0 : value.f_82479_, mag.f_82480_ < e ? 0.0 : value.f_82480_, mag.f_82481_ < e ? 0.0 : value.f_82481_);
    }

    public static List<String> default_whitelist() {
        defaultList = new HashSet();
        Physical.add(Items.f_42446_);
        Physical.add(Items.f_42448_);
        Physical.add(Items.f_42455_);
        Physical.add(Items.f_42458_);
        Physical.add(Items.f_42456_);
        Physical.add(Items.f_42457_);
        Physical.add(Items.f_42459_);
        Physical.add(Items.f_42447_);
        Physical.add(Items.f_220210_);
        Physical.add(Items.f_151057_);
        Physical.add(Items.f_151055_);
        Physical.add(Items.f_42522_);
        Physical.add(Items.f_220211_);
        Physical.add(Items.f_42464_);
        Physical.add(Items.f_42465_);
        Physical.add(Items.f_42466_);
        Physical.add(Items.f_42467_);
        Physical.add(Items.f_42449_);
        Physical.add(Items.f_42519_);
        Physical.add(Items.f_42694_);
        Physical.add(Items.f_42520_);
        Physical.add(Items.f_42693_);
        Physical.add(Items.f_42524_);
        Physical.add(Items.f_42574_);
        Physical.add(Items.f_42740_);
        Physical.add(Items.f_42418_);
        Physical.add(Items.f_42480_);
        Physical.add(Items.f_42481_);
        Physical.add(Items.f_42482_);
        Physical.add(Items.f_42483_);
        Physical.add(Items.f_42397_);
        Physical.add(Items.f_42395_);
        Physical.add(Items.f_42394_);
        Physical.add(Items.f_42393_);
        Physical.add(Items.f_42396_);
        Physical.add(Items.f_265918_);
        Physical.add(Items.f_42717_);
        Physical.add(Items.f_271356_);
        Physical.add(Blocks.f_50322_);
        Physical.add(Blocks.f_50323_);
        Physical.add(Blocks.f_50324_);
        Physical.add(Blocks.f_50256_);
        Physical.add(Blocks.f_152478_);
        Physical.add(Blocks.f_152477_);
        Physical.add(Blocks.f_152476_);
        Physical.add(Blocks.f_50625_);
        Physical.add(Blocks.f_50679_);
        Physical.add(Blocks.f_50184_);
        Physical.add(Blocks.f_50332_);
        Physical.add(Blocks.f_50040_);
        Physical.add(Blocks.f_50110_);
        Physical.add(Blocks.f_50032_);
        Physical.add(Blocks.f_50620_);
        Physical.add(Blocks.f_50680_);
        Physical.add(Blocks.f_50039_);
        Physical.add(Blocks.f_50326_);
        Physical.add(Blocks.f_50327_);
        Physical.add(Blocks.f_50156_);
        Physical.add(Blocks.f_50285_);
        Physical.add(Blocks.f_50031_);
        Physical.add(Blocks.f_50030_);
        Physical.add(Blocks.f_50681_);
        Physical.add(Blocks.f_50325_);
        Physical.add(Blocks.f_50266_);
        Physical.add(Blocks.f_50682_);
        Physical.add(Blocks.f_50721_);
        Physical.add(Blocks.f_50729_);
        Physical.add(Blocks.f_50706_);
        Physical.add(Blocks.f_152587_);
        WoodType.m_61843_().forEach(wt -> {
            Physical.add("minecraft:" + wt.f_61839_() + "_hanging_sign");
            Physical.add("minecraft:" + wt.f_61839_() + "_wall_hanging_sign");
        });
        Physical.add((Item)ConsumeSetup.VIAL.get());
        Physical.add((Item)ConsumeSetup.LERASIUM_NUGGET.get());
        Physical.add((Item)ConsumeSetup.ALLOMANTIC_GRINDER.get());
        Physical.add((Item)CombatSetup.COIN_BAG.get());
        Physical.add((Item)ExtrasSetup.BRONZE_EARRING.get());
        Physical.add((Block)WorldSetup.LIQUID_LERASIUM.get());
        BuiltInRegistries.f_257033_.m_6566_().stream().filter(Objects::nonNull).filter(Physical::doesResourceContainMetal).forEach(Physical::add);
        BuiltInRegistries.f_256975_.m_6566_().stream().filter(Objects::nonNull).filter(Physical::doesResourceContainMetal).forEach(Physical::add);
        ArrayList<String> list = new ArrayList<String>(defaultList);
        list.sort(String::compareTo);
        return list;
    }

    private static void add(String s) {
        Allomancy.LOGGER.info("Adding " + s + " to the default whitelist!");
        defaultList.add(s);
    }

    private static void add(ResourceLocation r) {
        Physical.add(r.toString());
    }

    private static void add(Block block) {
        Physical.add(BuiltInRegistries.f_256975_.m_7981_((Object)block));
    }

    private static void add(Item item) {
        Physical.add(BuiltInRegistries.f_257033_.m_7981_((Object)item));
    }
}

