/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.datagen;

import com.legobmw99.allomancy.datagen.Advancements;
import com.legobmw99.allomancy.datagen.BlockLootTables;
import com.legobmw99.allomancy.datagen.DatapackEntries;
import com.legobmw99.allomancy.datagen.EquipmentAssets;
import com.legobmw99.allomancy.datagen.Languages;
import com.legobmw99.allomancy.datagen.LootModifiers;
import com.legobmw99.allomancy.datagen.ModelFiles;
import com.legobmw99.allomancy.datagen.ParticleDescriptions;
import com.legobmw99.allomancy.datagen.Recipes;
import com.legobmw99.allomancy.datagen.StructureLootTables;
import com.legobmw99.allomancy.datagen.TagProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="allomancy", value={Dist.CLIENT})
public final class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        event.createDatapackRegistryObjects(DatapackEntries.BUILDER);
        CompletableFuture lookup = event.getLookupProvider();
        event.addProvider((DataProvider)new Languages(packOutput));
        event.addProvider((DataProvider)new ModelFiles(packOutput));
        event.addProvider((DataProvider)new EquipmentAssets(packOutput));
        event.addProvider((DataProvider)new ParticleDescriptions(packOutput));
        event.addProvider((DataProvider)new Recipes.Runner(packOutput, lookup));
        event.addProvider((DataProvider)new AdvancementProvider(packOutput, lookup, List.of(new Advancements())));
        event.addProvider((DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTables::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(StructureLootTables::new, LootContextParamSets.CHEST)), lookup));
        event.addProvider((DataProvider)new LootModifiers(packOutput, lookup));
        TagProvider.Blocks blocktags = (TagProvider.Blocks)event.addProvider((DataProvider)new TagProvider.Blocks(packOutput, lookup));
        event.addProvider((DataProvider)new TagProvider.Items(packOutput, lookup, blocktags.contentsGetter()));
        event.addProvider((DataProvider)new TagProvider.Biomes(packOutput, lookup));
        event.addProvider((DataProvider)new TagProvider.Structures(packOutput, lookup));
        event.addProvider((DataProvider)new TagProvider.DamageTypes(packOutput, lookup));
        event.addProvider((DataProvider)new TagProvider.Banners(packOutput, lookup));
        event.addProvider((DataProvider)new TagProvider.EntityTypes(packOutput, lookup));
    }

    private DataGenerators() {
    }
}

