/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.datagen;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.combat.CombatSetup;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.extras.block.IronButtonBlock;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.template.ExtendedModelTemplate;
import net.neoforged.neoforge.registries.DeferredItem;

class ModelFiles
extends ModelProvider {
    private static final ExtendedModelTemplate FLAT_HANDHELD_LARGE = ModelTemplates.FLAT_ITEM.extend().transform(ItemDisplayContext.GROUND, builder -> builder.scale(1.2f).translation(0.0f, 5.0f, 0.0f)).transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, builder -> builder.scale(1.2f).rotation(0.0f, -90.0f, 55.0f).translation(0.0f, 8.0f, 0.5f)).transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, builder -> builder.scale(1.2f).rotation(0.0f, 90.0f, -55.0f).translation(0.0f, 8.0f, 0.5f)).transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, builder -> builder.scale(1.0f).rotation(0.0f, -90.0f, 25.0f).translation(0.5f, 5.0f, 0.5f)).transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, builder -> builder.scale(1.0f).rotation(0.0f, 90.0f, -25.0f).translation(0.5f, 5.0f, 0.5f)).build();

    ModelFiles(PackOutput gen) {
        super(gen, "allomancy");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        ModelFiles.createBlockModels(blockModels);
        ModelFiles.createItemModels(itemModels);
    }

    private static void createItemModels(ItemModelGenerators itemModels) {
        itemModels.generateTrimmableItem((Item)CombatSetup.MISTCLOAK.get(), CombatSetup.WOOL, ItemModelGenerators.TRIM_PREFIX_CHESTPLATE, false);
        itemModels.generateTrimmableItem((Item)CombatSetup.ALUMINUM_HELMET.get(), CombatSetup.ALUMINUM, ItemModelGenerators.TRIM_PREFIX_HELMET, false);
        itemModels.generateFlatItem((Item)CombatSetup.COIN_BAG.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)CombatSetup.OBSIDIAN_DAGGER.get(), ModelTemplates.FLAT_HANDHELD_ITEM);
        itemModels.generateFlatItem((Item)CombatSetup.KOLOSS_BLADE.get(), (ModelTemplate)FLAT_HANDHELD_LARGE);
        itemModels.generateFlatItem((Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)ConsumeSetup.LERASIUM_NUGGET.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)ExtrasSetup.BRONZE_EARRING.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)ExtrasSetup.CHARGED_BRONZE_EARRING.get(), ModelTemplates.FLAT_ITEM);
        for (DeferredItem<Item> ritem : WorldSetup.RAW_ORE_ITEMS) {
            itemModels.generateFlatItem((Item)ritem.get(), ModelTemplates.FLAT_ITEM);
        }
        for (int i = 0; i < WorldSetup.METAL_ITEM_LEN; ++i) {
            Item flake = (Item)WorldSetup.FLAKES.get(i).get();
            itemModels.generateFlatItem(flake, ModelTemplates.FLAT_ITEM);
            if (i <= Metal.BENDALLOY.getIndex()) {
                Item pattern_item = (Item)ExtrasSetup.PATTERN_ITEMS.get(i).get();
                itemModels.generateFlatItem(pattern_item, ModelTemplates.FLAT_ITEM);
                if (Metal.getMetal(i).isVanilla()) continue;
            }
            Item nugget = (Item)WorldSetup.NUGGETS.get(i).get();
            itemModels.generateFlatItem(nugget, ModelTemplates.FLAT_ITEM);
            Item ingot = (Item)WorldSetup.INGOTS.get(i).get();
            itemModels.generateFlatItem(ingot, ModelTemplates.FLAT_ITEM);
        }
        Allomancy.LOGGER.debug("Creating Item Model for allomancy:vial (filled)");
        Item vial = (Item)ConsumeSetup.VIAL.get();
        ItemModel.Unbaked base_vial = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(vial, ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked full_vial = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(vial, "_filled", ModelTemplates.FLAT_ITEM));
        itemModels.generateBooleanDispatch(vial, ItemModelUtils.hasComponent(ConsumeSetup.FLAKE_STORAGE.get()), full_vial, base_vial);
    }

    private static void createBlockModels(BlockModelGenerators blockModels) {
        Allomancy.LOGGER.debug("Creating Block Data for allomancy:iron_lever");
        ModelFiles.createLever(blockModels, (Block)ExtrasSetup.IRON_LEVER.get(), TextureMapping.getBlockTexture((Block)Blocks.IRON_BLOCK));
        ModelFiles.createIronButtonBlocks(blockModels);
        blockModels.createNonTemplateModelBlock((Block)WorldSetup.LIQUID_LERASIUM.get(), Blocks.WATER);
        Stream.of(WorldSetup.ORE_BLOCKS, WorldSetup.DEEPSLATE_ORE_BLOCKS, WorldSetup.RAW_ORE_BLOCKS, WorldSetup.STORAGE_BLOCKS).flatMap(Collection::stream).forEach(rblock -> {
            if (rblock != null) {
                blockModels.createTrivialCube((Block)rblock.get());
            }
        });
    }

    private static void createIronButtonBlocks(BlockModelGenerators blockModels) {
        IronButtonBlock block = (IronButtonBlock)((Object)ExtrasSetup.IRON_BUTTON.get());
        TextureMapping iron = TextureMapping.defaultTexture((Block)Blocks.IRON_BLOCK);
        ResourceLocation extended = ModelTemplates.BUTTON.create((Block)block, iron, blockModels.modelOutput);
        ResourceLocation sunken = ModelTemplates.BUTTON_PRESSED.create((Block)block, iron, blockModels.modelOutput);
        ResourceLocation inventory = ModelTemplates.BUTTON_INVENTORY.create((Block)block, iron, blockModels.modelOutput);
        MultiVariant sunken_variant = BlockModelGenerators.plainVariant((ResourceLocation)sunken);
        MultiVariant extended_variant = BlockModelGenerators.plainVariant((ResourceLocation)extended);
        Allomancy.LOGGER.debug("Creating Block Data for allomancy:iron_button");
        blockModels.blockStateOutput.accept(BlockModelGenerators.createButton((Block)block, (MultiVariant)extended_variant, (MultiVariant)sunken_variant));
        blockModels.registerSimpleItemModel((Block)block, inventory);
        IronButtonBlock inverted = (IronButtonBlock)((Object)ExtrasSetup.INVERTED_IRON_BUTTON.get());
        Allomancy.LOGGER.debug("Creating Block Data for allomancy:inverted_iron_button");
        blockModels.blockStateOutput.accept(BlockModelGenerators.createButton((Block)inverted, (MultiVariant)sunken_variant, (MultiVariant)extended_variant));
        blockModels.registerSimpleItemModel((Block)inverted, inventory);
    }

    private static void createLever(BlockModelGenerators blockModels, Block block, ResourceLocation base) {
        TextureSlot base_slot = TextureSlot.create((String)"base");
        TextureSlot lever_slot = TextureSlot.create((String)"lever");
        ModelTemplate lever_template = ModelTemplates.create((String)"lever", (TextureSlot[])new TextureSlot[]{TextureSlot.PARTICLE, base_slot, lever_slot});
        ModelTemplate lever_on_template = ModelTemplates.create((String)"lever_on", (String)"_on", (TextureSlot[])new TextureSlot[]{TextureSlot.PARTICLE, base_slot, lever_slot});
        TextureMapping textures = new TextureMapping();
        textures.put(TextureSlot.PARTICLE, base);
        textures.put(base_slot, base);
        textures.put(lever_slot, TextureMapping.getBlockTexture((Block)block));
        ResourceLocation lever = lever_template.create(block, textures, blockModels.modelOutput);
        ResourceLocation lever_on = lever_on_template.create(block, textures, blockModels.modelOutput);
        MultiVariant lever_variant = BlockModelGenerators.plainVariant((ResourceLocation)lever);
        MultiVariant lever_on_variant = BlockModelGenerators.plainVariant((ResourceLocation)lever_on);
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with(BlockModelGenerators.createBooleanModelDispatch((BooleanProperty)BlockStateProperties.POWERED, (MultiVariant)lever_variant, (MultiVariant)lever_on_variant)).with((PropertyDispatch)PropertyDispatch.modify((Property)BlockStateProperties.ATTACH_FACE, (Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)AttachFace.CEILING, (Comparable)Direction.NORTH, (Object)BlockModelGenerators.X_ROT_180.then(BlockModelGenerators.Y_ROT_180)).select((Comparable)AttachFace.CEILING, (Comparable)Direction.EAST, (Object)BlockModelGenerators.X_ROT_180.then(BlockModelGenerators.Y_ROT_270)).select((Comparable)AttachFace.CEILING, (Comparable)Direction.SOUTH, (Object)BlockModelGenerators.X_ROT_180).select((Comparable)AttachFace.CEILING, (Comparable)Direction.WEST, (Object)BlockModelGenerators.X_ROT_180.then(BlockModelGenerators.Y_ROT_90)).select((Comparable)AttachFace.FLOOR, (Comparable)Direction.NORTH, (Object)BlockModelGenerators.NOP).select((Comparable)AttachFace.FLOOR, (Comparable)Direction.EAST, (Object)BlockModelGenerators.Y_ROT_90).select((Comparable)AttachFace.FLOOR, (Comparable)Direction.SOUTH, (Object)BlockModelGenerators.Y_ROT_180).select((Comparable)AttachFace.FLOOR, (Comparable)Direction.WEST, (Object)BlockModelGenerators.Y_ROT_270).select((Comparable)AttachFace.WALL, (Comparable)Direction.NORTH, (Object)BlockModelGenerators.X_ROT_90).select((Comparable)AttachFace.WALL, (Comparable)Direction.EAST, (Object)BlockModelGenerators.X_ROT_90.then(BlockModelGenerators.Y_ROT_90)).select((Comparable)AttachFace.WALL, (Comparable)Direction.SOUTH, (Object)BlockModelGenerators.X_ROT_90.then(BlockModelGenerators.Y_ROT_180)).select((Comparable)AttachFace.WALL, (Comparable)Direction.WEST, (Object)BlockModelGenerators.X_ROT_90.then(BlockModelGenerators.Y_ROT_270))));
        blockModels.registerSimpleFlatItemModel(block);
    }
}

