/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.datagen;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.combat.CombatSetup;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.consumables.item.recipe.VialItemRecipe;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import com.legobmw99.allomancy.modules.world.recipe.InvestingRecipe;
import com.legobmw99.allomancy.util.AllomancyTags;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

final class Recipes
extends RecipeProvider {
    private final Map<Character, Ingredient> defaultIngredients = new HashMap<Character, Ingredient>();
    private final HolderGetter<Item> items;

    private Recipes(HolderLookup.Provider registries, RecipeOutput output) {
        super(registries, output);
        this.items = registries.lookupOrThrow(Registries.ITEM);
        this.add('i', (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.add('g', (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.add('s', (ItemLike)Items.STICK);
        this.add('S', (TagKey<Item>)ItemTags.WOODEN_SLABS);
        this.add('G', (ItemLike)Items.GLASS);
        this.add('I', (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_IRON);
        this.add('W', (ItemLike)Items.GRAY_WOOL);
        this.add('O', (TagKey<Item>)Tags.Items.OBSIDIANS);
        this.add('C', (ItemLike)Items.COBBLESTONE);
        this.add('A', this.ing("c:ingots/aluminum"));
        this.add('B', this.ing("c:storage_blocks/bronze"));
        this.add('b', this.ing("c:ingots/bronze"));
        this.add('n', this.ing("c:nuggets/bronze"));
    }

    private void buildShapeless(RecipeOutput consumer, RecipeCategory cat, ItemLike result, int count, Item criterion, Ingredient ... ingredients) {
        this.buildShapeless(consumer, cat, result, count, criterion, "", ingredients);
    }

    private void buildShapeless(RecipeOutput consumer, RecipeCategory cat, ItemLike result, int count, Item criterion, String save, Ingredient ... ingredients) {
        Allomancy.LOGGER.debug("Creating Shapeless Recipe for {}", (Object)(String.valueOf(BuiltInRegistries.ITEM.getKey((Object)result.asItem())) + " " + save));
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)cat, (ItemLike)result, (int)count);
        builder.unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)criterion).getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{criterion}));
        for (Ingredient ingredient : ingredients) {
            builder.requires(ingredient);
        }
        if (save.isEmpty()) {
            builder.save(consumer);
        } else {
            builder.save(consumer, "allomancy:" + save);
        }
    }

    private void buildSmeltingAndBlasting(ItemLike result, List<ItemLike> ingredient, float xp) {
        String name = BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath();
        Allomancy.LOGGER.debug("Creating Smelting and Blasting Recipe for {}", (Object)name);
        this.oreBlasting(ingredient, RecipeCategory.MISC, result, xp, 100, name);
        this.oreSmelting(ingredient, RecipeCategory.MISC, result, xp, 200, name);
    }

    private static String mixing_save(String metal) {
        return metal + "_flakes_from_mixing";
    }

    private static String alloy_save(String metal) {
        return metal + "_ingot_from_alloying";
    }

    private Ingredient ing(String tag) {
        return this.tag(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)tag)));
    }

    private Ingredient ing(TagKey<Item> tag) {
        return this.tag(tag);
    }

    private static Ingredient ing(ItemLike itemProvider) {
        return Ingredient.of((ItemLike)itemProvider);
    }

    private static Ingredient[] repeat(Ingredient ing, int n) {
        return Recipes.repeatWith(ing, n, new Ingredient[0]);
    }

    private static Ingredient[] repeatWith(Ingredient ing, int n, Ingredient ... extras) {
        int size = n + extras.length;
        Ingredient[] out = new Ingredient[size];
        for (int i = 0; i < n; ++i) {
            out[i] = ing;
        }
        if (extras.length > 0) {
            System.arraycopy(extras, 0, out, n, size - n);
        }
        return out;
    }

    protected void buildRecipes() {
        int i;
        RecipeOutput consumer = this.output;
        this.buildShaped(consumer, RecipeCategory.REDSTONE, (ItemLike)ExtrasSetup.IRON_LEVER.get(), Items.IRON_INGOT, "s", "I");
        this.buildShaped(consumer, RecipeCategory.REDSTONE, (ItemLike)ExtrasSetup.IRON_BUTTON.get(), Items.IRON_INGOT, "i", "I");
        this.buildShapeless(consumer, RecipeCategory.REDSTONE, (ItemLike)ExtrasSetup.INVERTED_IRON_BUTTON.get(), 1, (Item)ExtrasSetup.IRON_BUTTON_ITEM.get(), "inverted_from_iron_button", Recipes.ing((ItemLike)ExtrasSetup.IRON_BUTTON.get()));
        this.buildShapeless(consumer, RecipeCategory.REDSTONE, (ItemLike)ExtrasSetup.IRON_BUTTON.get(), 1, (Item)ExtrasSetup.INVERTED_IRON_BUTTON_ITEM.get(), "iron_button_from_inverted", Recipes.ing((ItemLike)ExtrasSetup.INVERTED_IRON_BUTTON.get()));
        this.buildShaped(consumer, RecipeCategory.FOOD, (ItemLike)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Items.IRON_INGOT, "ggg", "iii", "ggg");
        this.buildShaped(consumer, RecipeCategory.FOOD, (ItemLike)ConsumeSetup.VIAL.get(), 4, Items.GLASS, " S ", "G G", " G ");
        this.buildShaped(consumer, RecipeCategory.COMBAT, (ItemLike)CombatSetup.MISTCLOAK.get(), (Item)ConsumeSetup.VIAL.get(), "W W", "WWW", "WWW");
        this.buildShaped(consumer, RecipeCategory.COMBAT, (ItemLike)CombatSetup.ALUMINUM_HELMET.get(), (Item)WorldSetup.INGOTS.get(Metal.ALUMINUM.getIndex()).get(), "AAA", "A A");
        this.buildShaped(consumer, RecipeCategory.COMBAT, (ItemLike)CombatSetup.OBSIDIAN_DAGGER.get(), (Item)CombatSetup.MISTCLOAK.get(), "  O", " O ", "s  ");
        this.buildShaped(consumer, RecipeCategory.COMBAT, (ItemLike)CombatSetup.KOLOSS_BLADE.get(), (Item)ConsumeSetup.LERASIUM_NUGGET.get(), "CC", "CC", "sC");
        this.buildShaped(consumer, RecipeCategory.MISC, (ItemLike)ExtrasSetup.BRONZE_EARRING.get(), (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), " b ", "B n");
        int[] ore_metal_indexes = new int[]{Metal.ALUMINUM.getIndex(), Metal.CADMIUM.getIndex(), Metal.CHROMIUM.getIndex(), WorldSetup.LEAD, WorldSetup.SILVER, Metal.TIN.getIndex(), Metal.ZINC.getIndex()};
        float[] ore_metal_xp = new float[]{0.6f, 0.7f, 0.7f, 0.4f, 1.0f, 0.6f, 0.6f};
        for (i = 0; i < WorldSetup.ORE_METALS.length; ++i) {
            Item raw = (Item)WorldSetup.RAW_ORE_ITEMS.get(i).get();
            BlockItem rawBlock = (BlockItem)WorldSetup.RAW_ORE_BLOCKS_ITEMS.get(i).get();
            BlockItem ore = (BlockItem)WorldSetup.ORE_BLOCKS_ITEMS.get(i).get();
            BlockItem deep_ore = (BlockItem)WorldSetup.DEEPSLATE_ORE_BLOCKS_ITEMS.get(i).get();
            Item ingot = (Item)WorldSetup.INGOTS.get(ore_metal_indexes[i]).get();
            this.buildSmeltingAndBlasting((ItemLike)ingot, List.of(raw, ore, deep_ore), ore_metal_xp[i]);
            this.buildShapeless(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)rawBlock, 1, raw, Recipes.repeat(Recipes.ing((ItemLike)raw), 9));
            this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)raw, 9, (Item)rawBlock, BuiltInRegistries.ITEM.getKey((Object)raw).getPath() + "_from_block", Recipes.ing((ItemLike)rawBlock));
        }
        for (i = 0; i < WorldSetup.METAL_ITEM_LEN; ++i) {
            Item flake = (Item)WorldSetup.FLAKES.get(i).get();
            String flakeType = BuiltInRegistries.ITEM.getKey((Object)flake).getPath().substring(0, BuiltInRegistries.ITEM.getKey((Object)flake).getPath().indexOf(95));
            this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)flake, 2, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.ing((ItemLike)ConsumeSetup.ALLOMANTIC_GRINDER.get()), this.ing("c:ingots/" + flakeType));
            if (i < Metal.values().length && Metal.getMetal(i).isVanilla()) continue;
            Item block = (Item)WorldSetup.STORAGE_BLOCK_ITEMS.get(i).get();
            Item ingot = (Item)WorldSetup.INGOTS.get(i).get();
            Item nugget = (Item)WorldSetup.NUGGETS.get(i).get();
            this.buildShapeless(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, 1, ingot, Recipes.repeat(Recipes.ing((ItemLike)ingot), 9));
            this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)ingot, 1, nugget, BuiltInRegistries.ITEM.getKey((Object)ingot).getPath() + "_from_nuggets", Recipes.repeat(Recipes.ing((ItemLike)nugget), 9));
            this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)ingot, 9, block, BuiltInRegistries.ITEM.getKey((Object)ingot).getPath() + "_from_block", Recipes.ing((ItemLike)block));
            this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)nugget, 9, ingot, Recipes.ing((ItemLike)ingot));
        }
        for (Metal mt : Metal.values()) {
            this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)ExtrasSetup.PATTERN_ITEMS.get(mt.getIndex()).get(), 1, (Item)WorldSetup.FLAKES.get(mt.getIndex()).get(), Recipes.ing((ItemLike)Items.PAPER), Recipes.ing((ItemLike)WorldSetup.FLAKES.get(mt.getIndex()).get()));
        }
        this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.FLAKES.get(Metal.STEEL.getIndex()).get(), 2, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("steel"), Recipes.ing((ItemLike)Items.COAL), Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.IRON.getIndex()).get()));
        this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.FLAKES.get(Metal.PEWTER.getIndex()).get(), 3, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("pewter"), Recipes.repeatWith(Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.TIN.getIndex()).get()), 2, Recipes.ing((ItemLike)WorldSetup.FLAKES.get(WorldSetup.LEAD).get())));
        this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.FLAKES.get(Metal.BRASS.getIndex()).get(), 4, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("brass"), Recipes.repeatWith(Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.COPPER.getIndex()).get()), 3, Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.ZINC.getIndex()).get())));
        this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.FLAKES.get(Metal.BRONZE.getIndex()).get(), 4, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("bronze"), Recipes.repeatWith(Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.COPPER.getIndex()).get()), 3, Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.TIN.getIndex()).get())));
        this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.FLAKES.get(Metal.DURALUMIN.getIndex()).get(), 4, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("duralumin"), Recipes.repeatWith(Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.ALUMINUM.getIndex()).get()), 3, Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.COPPER.getIndex()).get())));
        this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.FLAKES.get(Metal.ELECTRUM.getIndex()).get(), 2, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("electrum"), Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.GOLD.getIndex()).get()), Recipes.ing((ItemLike)WorldSetup.FLAKES.get(WorldSetup.SILVER).get()));
        this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.FLAKES.get(Metal.BENDALLOY.getIndex()).get(), 3, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("bendalloy"), Recipes.repeatWith(Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.CADMIUM.getIndex()).get()), 2, Recipes.ing((ItemLike)WorldSetup.FLAKES.get(WorldSetup.LEAD).get())));
        this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.FLAKES.get(Metal.NICROSIL.getIndex()).get(), 4, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("nicrosil"), Recipes.repeatWith(Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.CHROMIUM.getIndex()).get()), 3, Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.IRON.getIndex()).get())));
        this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.INGOTS.get(Metal.STEEL.getIndex()).get(), 4, Items.COAL, Recipes.alloy_save("steel"), Recipes.repeatWith(Recipes.ing((ItemLike)Items.IRON_INGOT), 3, Recipes.ing((ItemLike)Items.COAL)));
        this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.INGOTS.get(Metal.PEWTER.getIndex()).get(), 3, (Item)WorldSetup.INGOTS.get(Metal.TIN.getIndex()).get(), Recipes.alloy_save("pewter"), Recipes.repeatWith(this.ing("c:ingots/tin"), 2, this.ing("c:ingots/lead")));
        this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.INGOTS.get(Metal.BRASS.getIndex()).get(), 4, (Item)WorldSetup.INGOTS.get(Metal.ZINC.getIndex()).get(), Recipes.alloy_save("brass"), Recipes.repeatWith(Recipes.ing((ItemLike)Items.COPPER_INGOT), 3, this.ing("c:ingots/zinc")));
        this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.INGOTS.get(Metal.BRONZE.getIndex()).get(), 4, (Item)WorldSetup.INGOTS.get(Metal.TIN.getIndex()).get(), Recipes.alloy_save("bronze"), Recipes.repeatWith(Recipes.ing((ItemLike)Items.COPPER_INGOT), 3, this.ing("c:ingots/tin")));
        this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.INGOTS.get(Metal.DURALUMIN.getIndex()).get(), 4, (Item)WorldSetup.INGOTS.get(Metal.ALUMINUM.getIndex()).get(), Recipes.alloy_save("duralumin"), Recipes.repeatWith(this.ing("c:ingots/aluminum"), 3, Recipes.ing((ItemLike)Items.COPPER_INGOT)));
        this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.INGOTS.get(Metal.ELECTRUM.getIndex()).get(), 2, (Item)WorldSetup.INGOTS.get(WorldSetup.SILVER).get(), Recipes.alloy_save("electrum"), this.ing("c:ingots/silver"), Recipes.ing((ItemLike)Items.GOLD_INGOT));
        this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.INGOTS.get(Metal.BENDALLOY.getIndex()).get(), 3, (Item)WorldSetup.INGOTS.get(Metal.CADMIUM.getIndex()).get(), Recipes.alloy_save("bendalloy"), Recipes.repeatWith(this.ing("c:ingots/cadmium"), 2, this.ing("c:ingots/lead")));
        this.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.INGOTS.get(Metal.NICROSIL.getIndex()).get(), 4, (Item)WorldSetup.INGOTS.get(Metal.CHROMIUM.getIndex()).get(), Recipes.alloy_save("nicrosil"), Recipes.repeatWith(this.ing("c:ingots/chromium"), 3, Recipes.ing((ItemLike)Items.IRON_INGOT)));
        Allomancy.LOGGER.debug("Creating Shaped Recipe for allomancy:coin_bag");
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)CombatSetup.COIN_BAG.get())).unlockedBy("has_gold_nugget", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.GOLD_NUGGET})).showNotification(true).define(Character.valueOf('#'), (ItemLike)Items.LEAD).define(Character.valueOf('l'), (ItemLike)Items.LEATHER).define(Character.valueOf('g'), (ItemLike)Items.GOLD_NUGGET).pattern(" #g").pattern("l l").pattern(" l ").save(consumer);
        Allomancy.LOGGER.debug("Creating Special Recipe for Vial Filling");
        SpecialRecipeBuilder.special(VialItemRecipe::new).save(consumer, "allomancy:vial_filling_recipe");
        Allomancy.LOGGER.debug("Creating Special Recipe for Lerasium investing");
        consumer.accept(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)Allomancy.rl("lerasium_investing")), (Recipe)new InvestingRecipe(this.tag(AllomancyTags.LERASIUM_CONVERSION), ConsumeSetup.LERASIUM_NUGGET.toStack()), null);
    }

    private void buildShaped(RecipeOutput consumer, RecipeCategory cat, ItemLike result, int count, Item criterion, String ... lines) {
        Allomancy.LOGGER.debug("Creating Shaped Recipe for {}", (Object)BuiltInRegistries.ITEM.getKey((Object)result.asItem()));
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)cat, (ItemLike)result, (int)count);
        builder.unlockedBy("has_" + BuiltInRegistries.ITEM.getKey((Object)criterion).getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{criterion}));
        builder.showNotification(true);
        HashSet characters = new HashSet();
        for (String line : lines) {
            builder.pattern(line);
            line.chars().forEach(value -> characters.add(Character.valueOf((char)value)));
        }
        for (Character c : characters) {
            if (!this.defaultIngredients.containsKey(c)) continue;
            builder.define(c, this.defaultIngredients.get(c));
        }
        builder.save(consumer);
    }

    private void buildShaped(RecipeOutput consumer, RecipeCategory cat, ItemLike result, Item criterion, String ... lines) {
        this.buildShaped(consumer, cat, result, 1, criterion, lines);
    }

    private void add(char c, TagKey<Item> itemTag) {
        this.defaultIngredients.put(Character.valueOf(c), this.tag(itemTag));
    }

    private void add(char c, ItemLike itemProvider) {
        this.defaultIngredients.put(Character.valueOf(c), Ingredient.of((ItemLike)itemProvider));
    }

    private void add(char c, Ingredient ingredient) {
        this.defaultIngredients.put(Character.valueOf(c), ingredient);
    }

    protected <T extends AbstractCookingRecipe> void oreCooking(RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> recipeFactory, List<ItemLike> ingredients, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group, String suffix) {
        for (ItemLike itemlike : ingredients) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike)itemlike), (RecipeCategory)category, (ItemLike)result, (float)experience, (int)cookingTime, serializer, recipeFactory).group(group).unlockedBy(Recipes.getHasName((ItemLike)itemlike), this.has(itemlike)).save(this.output, "allomancy:" + Recipes.getItemName((ItemLike)result) + suffix + "_" + Recipes.getItemName((ItemLike)itemlike));
        }
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput out, CompletableFuture<HolderLookup.Provider> lookup) {
            super(out, lookup);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
            return new Recipes(registries, output);
        }

        public String getName() {
            return "Allomancy recipes";
        }
    }
}

