/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.datagen;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.combat.CombatSetup;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import com.legobmw99.allomancy.util.AllomancyTags;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.BannerPatternTagsProvider;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.StructureTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagCopyingItemTagProvider;
import net.neoforged.neoforge.common.data.BlockTagsProvider;

public final class TagProvider {
    private TagProvider() {
    }

    static class DamageTypes
    extends DamageTypeTagsProvider {
        DamageTypes(PackOutput out, CompletableFuture<HolderLookup.Provider> lookup) {
            super(out, lookup, "allomancy");
        }

        protected void addTags(HolderLookup.Provider lookup) {
            this.tag(DamageTypeTags.IS_PROJECTILE).add(CombatSetup.COIN_DAMAGE);
            this.tag(Tags.DamageTypes.IS_MAGIC).add(CombatSetup.COIN_DAMAGE);
            this.tag(AllomancyTags.IS_COIN_HIT).add(CombatSetup.COIN_DAMAGE);
        }
    }

    public static class Biomes
    extends BiomeTagsProvider {
        public Biomes(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
            super(output, provider, "allomancy");
        }

        protected void addTags(HolderLookup.Provider lookup) {
            this.tag(AllomancyTags.SPAWNS_WELLS).addTag(Tags.Biomes.IS_MOUNTAIN_PEAK);
        }
    }

    static class Banners
    extends BannerPatternTagsProvider {
        Banners(PackOutput pGenerator, CompletableFuture<HolderLookup.Provider> registries) {
            super(pGenerator, registries, "allomancy");
        }

        protected void addTags(HolderLookup.Provider provider) {
            for (Metal mt : Metal.values()) {
                Allomancy.LOGGER.debug("Creating banner tag for {}", (Object)mt.getName());
                this.tag(AllomancyTags.PATTERN_TAGS.get(mt.getIndex())).add(ExtrasSetup.PATTERNS.get(mt.getIndex()));
            }
        }
    }

    static class Blocks
    extends BlockTagsProvider {
        Blocks(PackOutput gen, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(gen, lookupProvider, "allomancy");
        }

        protected void addTags(HolderLookup.Provider provider) {
            for (int i = 0; i < WorldSetup.ORE_METALS.length; ++i) {
                Block block = (Block)WorldSetup.ORE_BLOCKS.get(i).get();
                Block ds = (Block)WorldSetup.DEEPSLATE_ORE_BLOCKS.get(i).get();
                Block raw = (Block)WorldSetup.RAW_ORE_BLOCKS.get(i).get();
                this.addCommonTag("ores/" + String.valueOf(WorldSetup.ORE_METALS[i]), block, ds);
                this.addCommonTag("ores", block, ds);
                this.addCommonTag("ores_in_ground/stone", block);
                this.addCommonTag("ores_in_ground/deepslate", ds);
                this.addCommonTag("storage_blocks", raw);
                this.addCommonTag("storage_blocks/raw_" + String.valueOf(WorldSetup.ORE_METALS[i]), raw);
                this.makePickaxeMineable(block, ds, raw);
            }
            for (Metal mt : Metal.values()) {
                if (mt.isVanilla()) continue;
                Block block = (Block)WorldSetup.STORAGE_BLOCKS.get(mt.getIndex()).get();
                this.addCommonTag("storage_blocks/" + mt.getName(), block);
                this.addCommonTag("storage_blocks", block);
                this.makePickaxeMineable(block);
                if (mt == Metal.ALUMINUM) continue;
                this.addBeacon(block);
            }
            Block lead = (Block)WorldSetup.STORAGE_BLOCKS.get(WorldSetup.LEAD).get();
            this.addCommonTag("storage_blocks/lead", lead);
            Block silver = (Block)WorldSetup.STORAGE_BLOCKS.get(WorldSetup.SILVER).get();
            this.addCommonTag("storage_blocks/silver", silver);
            this.addBeacon(silver);
            this.makePickaxeMineable(lead, silver);
            this.addCommonTag("storage_blocks", lead, silver);
        }

        private void addCommonTag(String name, Block ... items) {
            Allomancy.LOGGER.debug("Creating block tag for c:{}", (Object)name);
            this.tag(BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name))).replace(false).add((Object[])items);
        }

        private void makePickaxeMineable(Block ... items) {
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).replace(false).add((Object[])items);
            this.tag(BlockTags.NEEDS_STONE_TOOL).replace(false).add((Object[])items);
        }

        private void addBeacon(Block ... items) {
            this.tag(BlockTags.BEACON_BASE_BLOCKS).replace(false).add((Object[])items);
        }
    }

    static class Items
    extends BlockTagCopyingItemTagProvider {
        Items(PackOutput gen, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider) {
            super(gen, lookupProvider, blockTagProvider, "allomancy");
        }

        protected void addTags(HolderLookup.Provider provider) {
            for (Metal mt : Metal.values()) {
                if (mt.isVanilla()) continue;
                Item nugget = (Item)WorldSetup.NUGGETS.get(mt.getIndex()).get();
                Item ingot = (Item)WorldSetup.INGOTS.get(mt.getIndex()).get();
                BlockItem block = (BlockItem)WorldSetup.STORAGE_BLOCK_ITEMS.get(mt.getIndex()).get();
                this.addCommonTag("nuggets", nugget);
                this.addCommonTag("nuggets/" + mt.getName(), nugget);
                this.addCommonTag("ingots", ingot);
                this.addCommonTag("ingots/" + mt.getName(), ingot);
                this.addCommonTag("storage_blocks", new Item[]{block});
                this.addCommonTag("storage_blocks/" + mt.getName(), new Item[]{block});
            }
            this.addCommonTag("nuggets", (Item)WorldSetup.NUGGETS.get(WorldSetup.LEAD).get());
            this.addCommonTag("nuggets/lead", (Item)WorldSetup.NUGGETS.get(WorldSetup.LEAD).get());
            this.addCommonTag("ingots", (Item)WorldSetup.INGOTS.get(WorldSetup.LEAD).get());
            this.addCommonTag("ingots/lead", (Item)WorldSetup.INGOTS.get(WorldSetup.LEAD).get());
            this.addCommonTag("storage_blocks", (Item)WorldSetup.STORAGE_BLOCK_ITEMS.get(WorldSetup.LEAD).get());
            this.addCommonTag("storage_blocks/lead", (Item)WorldSetup.STORAGE_BLOCK_ITEMS.get(WorldSetup.LEAD).get());
            this.addCommonTag("nuggets", (Item)WorldSetup.NUGGETS.get(WorldSetup.SILVER).get());
            this.addCommonTag("nuggets/silver", (Item)WorldSetup.NUGGETS.get(WorldSetup.SILVER).get());
            this.addCommonTag("ingots", (Item)WorldSetup.INGOTS.get(WorldSetup.SILVER).get());
            this.addCommonTag("ingots/silver", (Item)WorldSetup.INGOTS.get(WorldSetup.SILVER).get());
            this.addCommonTag("storage_blocks", (Item)WorldSetup.STORAGE_BLOCK_ITEMS.get(WorldSetup.SILVER).get());
            this.addCommonTag("storage_blocks/silver", (Item)WorldSetup.STORAGE_BLOCK_ITEMS.get(WorldSetup.SILVER).get());
            for (int i = 0; i < WorldSetup.ORE_METALS.length; ++i) {
                BlockItem ore = (BlockItem)WorldSetup.ORE_BLOCKS_ITEMS.get(i).get();
                BlockItem ds_ore = (BlockItem)WorldSetup.DEEPSLATE_ORE_BLOCKS_ITEMS.get(i).get();
                BlockItem raw_block = (BlockItem)WorldSetup.RAW_ORE_BLOCKS_ITEMS.get(i).get();
                Item raw = (Item)WorldSetup.RAW_ORE_ITEMS.get(i).get();
                this.addCommonTag("ores/" + String.valueOf(WorldSetup.ORE_METALS[i]), new Item[]{ore, ds_ore});
                this.addCommonTag("ores", new Item[]{ore, ds_ore});
                this.addCommonTag("ores_in_ground/stone", new Item[]{ore});
                this.addCommonTag("ores_in_ground/deepslate", new Item[]{ds_ore});
                this.addCommonTag("storage_blocks", new Item[]{raw_block});
                this.addCommonTag("storage_blocks/raw_" + String.valueOf(WorldSetup.ORE_METALS[i]), new Item[]{raw_block});
                this.addCommonTag("raw_materials", raw);
                this.addCommonTag("raw_materials/" + String.valueOf(WorldSetup.ORE_METALS[i]), raw);
            }
            this.tag(ItemTags.SWORDS).replace(false).add((Object)((Item)CombatSetup.KOLOSS_BLADE.get()));
            this.tag(ItemTags.HEAD_ARMOR).replace(false).add((Object)((Item)CombatSetup.ALUMINUM_HELMET.get()));
            this.tag(ItemTags.GAZE_DISGUISE_EQUIPMENT).replace(false).add((Object)((Item)CombatSetup.ALUMINUM_HELMET.get()));
            this.tag(ItemTags.CHEST_ARMOR).replace(false).add((Object)((Item)CombatSetup.MISTCLOAK.get()));
            this.tag(ItemTags.TRIMMABLE_ARMOR).replace(false).add((Object)((Item)CombatSetup.ALUMINUM_HELMET.get())).add((Object)((Item)CombatSetup.MISTCLOAK.get()));
            this.tag(AllomancyTags.FLAKES_TAG).add((Object[])((Item[])WorldSetup.FLAKES.stream().map(Supplier::get).toArray(Item[]::new)));
            this.tag(AllomancyTags.REPAIRS_MISTCLOAK).add((Object)net.minecraft.world.item.Items.GRAY_WOOL);
            this.tag(AllomancyTags.OBSIDIAN_REPAIR).add((Object[])new Item[]{net.minecraft.world.item.Items.OBSIDIAN, net.minecraft.world.item.Items.CRYING_OBSIDIAN});
            this.tag(AllomancyTags.REPAIRS_ALUMINUM).addTag(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ingots/aluminum")));
            this.tag(AllomancyTags.LERASIUM_CONVERSION).addTag(Tags.Items.NETHER_STARS);
            this.tag(AllomancyTags.TIN_FOIL_HATS).add((Object)((Item)CombatSetup.ALUMINUM_HELMET.get()));
            this.tag(AllomancyTags.SPECIAL_EARRINGS).add((Object)((Item)ExtrasSetup.CHARGED_BRONZE_EARRING.get()));
            this.tag(AllomancyTags.ONE_HIT_WEAPONS).add((Object)((Item)CombatSetup.KOLOSS_BLADE.get()));
        }

        private void addCommonTag(String name, Item ... items) {
            Allomancy.LOGGER.debug("Creating item tag for c:{}", (Object)name);
            this.tag(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name))).replace(false).add((Object[])items);
        }
    }

    public static class Structures
    extends StructureTagsProvider {
        public Structures(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
            super(output, provider, "allomancy");
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(AllomancyTags.SEEKABLE).replace(false).add(WorldSetup.WELL);
        }
    }

    public static class EntityTypes
    extends EntityTypeTagsProvider {
        public EntityTypes(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
            super(output, provider, "allomancy");
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(EntityTypeTags.IMPACT_PROJECTILES).replace(false).add(CombatSetup.NUGGET_PROJECTILE.get());
            this.tag(AllomancyTags.HEMALURGIC_CHARGERS).replace(false).addTag(EntityTypeTags.RAIDERS).add((Object)EntityType.WITHER).add((Object)EntityType.ENDER_DRAGON).add((Object)EntityType.ELDER_GUARDIAN).add((Object)EntityType.GHAST).add((Object)EntityType.ZOGLIN).add((Object)EntityType.WARDEN).add((Object)EntityType.WITHER_SKELETON).add((Object)EntityType.SKELETON_HORSE).add((Object)EntityType.SHULKER);
        }
    }
}

