/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.integration.jei;

import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import com.legobmw99.allomancy.modules.world.recipe.InvestingRecipe;
import com.legobmw99.allomancy.util.ItemDisplay;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeHolderType;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class InvestingRecipeCategory
implements IRecipeCategory<RecipeHolder<InvestingRecipe>> {
    public static final IRecipeHolderType<InvestingRecipe> TYPE = IRecipeType.create(WorldSetup.INVESTING_RECIPE.get());
    private final IDrawable icon;

    public InvestingRecipeCategory(IGuiHelper helper) {
        this.icon = helper.createDrawableItemLike((ItemLike)ConsumeSetup.LERASIUM_NUGGET.get());
    }

    public IRecipeType<RecipeHolder<InvestingRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"allomancy.jei.investing");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<InvestingRecipe> recipe, IFocusGroup focuses) {
        builder.addInputSlot(30, 14).add(((InvestingRecipe)recipe.value()).ingredient());
        builder.addSlot(RecipeIngredientRole.CRAFTING_STATION, 40, 24).add((Fluid)WorldSetup.LERASIUM_FLUID.get());
        ((IRecipeSlotBuilder)builder.addOutputSlot(96, 24).add(((InvestingRecipe)recipe.value()).result())).setOutputSlotBackground();
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<InvestingRecipe> recipe, IFocusGroup focuses) {
        builder.addRecipeArrow().setPosition(64, 24);
        builder.addText((FormattedText)ItemDisplay.addColorToText("allomancy.jei.investing.description", ChatFormatting.DARK_PURPLE), this.getWidth(), this.getHeight());
    }

    @Nullable
    public ResourceLocation getRegistryName(RecipeHolder<InvestingRecipe> recipe) {
        return recipe.id().location();
    }

    public int getWidth() {
        return 128;
    }

    public int getHeight() {
        return 64;
    }
}

