/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.consumables.item.component;

import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.powers.data.AllomancerAttachment;
import com.legobmw99.allomancy.modules.powers.data.AllomancerData;
import com.legobmw99.allomancy.util.ItemDisplay;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class FlakeStorage
implements TooltipProvider,
ConsumableListener {
    private final EnumSet<Metal> flakes;
    public static final Codec<FlakeStorage> CODEC = Codec.list(Metal.CODEC).xmap(metals -> {
        Mutable storage = new Mutable();
        for (Metal mt : metals) {
            storage.add(mt);
        }
        return storage.toImmutable();
    }, flakeStorage -> flakeStorage.flakes.stream().toList());
    public static final StreamCodec<ByteBuf, FlakeStorage> STREAM_CODEC = new StreamCodec<ByteBuf, FlakeStorage>(){

        public FlakeStorage decode(ByteBuf buf) {
            Mutable storage = new Mutable();
            for (Metal mt : Metal.values()) {
                if (!buf.readBoolean()) continue;
                storage.add(mt);
            }
            return storage.toImmutable();
        }

        public void encode(ByteBuf buf, FlakeStorage storage) {
            for (Metal mt : Metal.values()) {
                buf.writeBoolean(storage.contains(mt));
            }
        }
    };

    private FlakeStorage(EnumSet<Metal> flakes) {
        this.flakes = flakes;
    }

    public boolean contains(Metal mt) {
        return this.flakes.contains((Object)mt);
    }

    public int hashCode() {
        return this.flakes.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FlakeStorage)) return false;
        FlakeStorage flakeStorage = (FlakeStorage)other;
        if (!this.flakes.equals(flakeStorage.flakes)) return false;
        return true;
    }

    public void addToTooltip(Item.TooltipContext ctx, Consumer<Component> tooltip, TooltipFlag flag, DataComponentGetter getter) {
        int count = 0;
        Metal last = Metal.IRON;
        for (Metal mt : Metal.values()) {
            if (!this.contains(mt)) continue;
            ++count;
            last = mt;
        }
        switch (count) {
            case 0: {
                break;
            }
            case 1: {
                tooltip.accept((Component)ItemDisplay.addColorToText("allomancy.flake_storage.lore_single", ChatFormatting.GRAY, Component.translatable((String)("metals." + last.getName())).getString()));
                break;
            }
            default: {
                if (Screen.hasShiftDown()) {
                    for (Metal mt : Metal.values()) {
                        if (!this.contains(mt)) continue;
                        tooltip.accept((Component)ItemDisplay.addColorToText("metals." + mt.getName(), ChatFormatting.GRAY));
                    }
                    break;
                }
                tooltip.accept((Component)ItemDisplay.addColorToText("allomancy.flake_storage.lore_count", ChatFormatting.GRAY, count));
                tooltip.accept((Component)ItemDisplay.addColorToText("allomancy.flake_storage.lore_inst", ChatFormatting.GRAY));
            }
        }
    }

    public void onConsume(Level level, LivingEntity entity, ItemStack stack, Consumable consumable) {
        FlakeStorage storage = (FlakeStorage)stack.get(ConsumeSetup.FLAKE_STORAGE);
        if (storage == null) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AllomancerData data = AllomancerAttachment.get(player);
            if (stack.getItem() == Items.ENCHANTED_GOLDEN_APPLE && storage.contains(Metal.GOLD)) {
                for (int i = 0; i < 10; ++i) {
                    data.incrementStored(Metal.GOLD);
                }
            }
            for (Metal mt : Metal.values()) {
                if (!storage.contains(mt)) continue;
                data.incrementStored(mt);
            }
        }
    }

    public static class Mutable {
        private final EnumSet<Metal> flakes = EnumSet.noneOf(Metal.class);

        public Mutable add(Metal mt) {
            this.flakes.add(mt);
            return this;
        }

        public Mutable addAll(@Nullable FlakeStorage other) {
            if (other != null) {
                this.flakes.addAll(other.flakes);
            }
            return this;
        }

        @Nullable
        public FlakeStorage toImmutable() {
            if (this.flakes.isEmpty()) {
                return null;
            }
            return new FlakeStorage(this.flakes);
        }
    }
}

