/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.consumables.item.recipe;

import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.consumables.item.VialItem;
import com.legobmw99.allomancy.modules.consumables.item.component.FlakeStorage;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import java.util.Arrays;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class VialItemRecipe
extends CustomRecipe {
    private static final Ingredient INGREDIENT_VIAL = Ingredient.of((ItemLike)((ItemLike)ConsumeSetup.VIAL.get()));

    public VialItemRecipe(CraftingBookCategory catIn) {
        super(catIn);
    }

    public boolean matches(CraftingInput input, Level worldIn) {
        boolean[] metals = new boolean[Metal.values().length];
        Arrays.fill(metals, false);
        boolean hasVial = false;
        boolean hasFlake = false;
        for (ItemStack stack : input.items()) {
            if (stack.isEmpty()) continue;
            if (INGREDIENT_VIAL.test(stack) && !hasVial) {
                FlakeStorage storage = (FlakeStorage)stack.get(ConsumeSetup.FLAKE_STORAGE);
                if (storage != null) {
                    for (Metal mt : Metal.values()) {
                        boolean hasMetalAlready = storage.contains(mt);
                        if (metals[mt.getIndex()] && hasMetalAlready) {
                            return false;
                        }
                        int n = mt.getIndex();
                        metals[n] = metals[n] | hasMetalAlready;
                    }
                }
                hasVial = true;
                continue;
            }
            boolean any = false;
            for (Metal mt : Metal.values()) {
                if (stack.getItem() != WorldSetup.FLAKES.get(mt.getIndex()).get()) continue;
                if (metals[mt.getIndex()]) {
                    return false;
                }
                metals[mt.getIndex()] = true;
                hasFlake = true;
                any = true;
                break;
            }
            if (any) continue;
            return false;
        }
        return hasVial && hasFlake;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        FlakeStorage.Mutable storage = new FlakeStorage.Mutable();
        block0: for (ItemStack stack : input.items()) {
            if (stack.isEmpty()) continue;
            if (INGREDIENT_VIAL.test(stack)) {
                storage.addAll((FlakeStorage)stack.get(ConsumeSetup.FLAKE_STORAGE));
                continue;
            }
            for (Metal mt : Metal.values()) {
                if (stack.getItem() != WorldSetup.FLAKES.get(mt.getIndex()).get()) continue;
                storage.add(mt);
                continue block0;
            }
        }
        ItemStack item_result = ConsumeSetup.VIAL.toStack();
        VialItem.fillVial(item_result, storage.toImmutable());
        return item_result;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return ConsumeSetup.VIAL_RECIPE_SERIALIZER.get();
    }
}

