/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.extras;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.block.IAllomanticallyUsable;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.extras.advancement.AllomanticallyActivatedBlockTrigger;
import com.legobmw99.allomancy.modules.extras.advancement.MetalUsedOnEntityTrigger;
import com.legobmw99.allomancy.modules.extras.advancement.MetalUsedOnPlayerTrigger;
import com.legobmw99.allomancy.modules.extras.block.IronButtonBlock;
import com.legobmw99.allomancy.modules.extras.block.IronLeverBlock;
import com.legobmw99.allomancy.modules.extras.command.AllomancyPowerCommand;
import com.legobmw99.allomancy.modules.extras.command.AllomancyPowerType;
import com.legobmw99.allomancy.modules.extras.item.BronzeEarringItem;
import com.legobmw99.allomancy.util.AllomancyTags;
import com.legobmw99.allomancy.util.ItemDisplay;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ExtrasSetup {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"allomancy");
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"allomancy");
    public static final DeferredItem<BronzeEarringItem> BRONZE_EARRING = ITEMS.registerItem("bronze_earring", BronzeEarringItem::new, new Item.Properties().stacksTo(1).attributes(BronzeEarringItem.createAttributes()).component(DataComponents.LORE, (Object)new ItemLore(List.of(ItemDisplay.addColorToText("item.allomancy.bronze_earring.lore", ChatFormatting.GRAY)))));
    public static final ResourceKey<EquipmentAsset> BRONZE = ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)Allomancy.rl("bronze_jewelry"));
    public static final DeferredItem<BronzeEarringItem> CHARGED_BRONZE_EARRING = ITEMS.registerItem("charged_bronze_earring", BronzeEarringItem::new, new Item.Properties().stacksTo(1).rarity(Rarity.RARE).component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)EquipmentSlot.HEAD).setAsset(BRONZE).build()).component(DataComponents.LORE, (Object)new ItemLore(List.of(ItemDisplay.addColorToText("item.allomancy.charged_bronze_earring.lore", ChatFormatting.BLUE)))));
    public static final BlockCapability<IAllomanticallyUsable, Void> ALLOMANTICALLY_USABLE_BLOCK = BlockCapability.createVoid((ResourceLocation)Allomancy.rl("allomantically_usable_block"), IAllomanticallyUsable.class);
    private static final BlockBehaviour.Properties IRON_REDSTONE_PROPS = BlockBehaviour.Properties.of().noCollission().strength(1.0f);
    private static final Item.Properties IRON_REDSTONE_LORE = new Item.Properties().component(DataComponents.LORE, (Object)new ItemLore(List.of(ItemDisplay.addColorToText("block.allomancy.iron_activation.lore", ChatFormatting.GRAY))));
    public static final DeferredBlock<IronButtonBlock> IRON_BUTTON = BLOCKS.registerBlock("iron_button", props -> new IronButtonBlock(true, (BlockBehaviour.Properties)props), IRON_REDSTONE_PROPS);
    public static final DeferredItem<BlockItem> IRON_BUTTON_ITEM = ITEMS.registerSimpleBlockItem(IRON_BUTTON, IRON_REDSTONE_LORE);
    public static final DeferredBlock<IronButtonBlock> INVERTED_IRON_BUTTON = BLOCKS.registerBlock("inverted_iron_button", props -> new IronButtonBlock(false, (BlockBehaviour.Properties)props), IRON_REDSTONE_PROPS);
    public static final DeferredItem<BlockItem> INVERTED_IRON_BUTTON_ITEM = ITEMS.registerSimpleBlockItem(INVERTED_IRON_BUTTON, IRON_REDSTONE_LORE);
    public static final DeferredBlock<IronLeverBlock> IRON_LEVER = BLOCKS.registerBlock("iron_lever", IronLeverBlock::new, IRON_REDSTONE_PROPS);
    public static final DeferredItem<BlockItem> IRON_LEVER_ITEM = ITEMS.registerSimpleBlockItem(IRON_LEVER, IRON_REDSTONE_LORE);
    public static final List<ResourceKey<BannerPattern>> PATTERNS = new ArrayList<ResourceKey<BannerPattern>>();
    public static final List<DeferredItem<Item>> PATTERN_ITEMS = new ArrayList<DeferredItem<Item>>();
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)Registries.COMMAND_ARGUMENT_TYPE, (String)"allomancy");
    private static final DeferredRegister<CriterionTrigger<?>> CT;
    public static final Supplier<MetalUsedOnEntityTrigger> METAL_USED_ON_ENTITY_TRIGGER;
    public static final Supplier<MetalUsedOnPlayerTrigger> METAL_USED_ON_PLAYER_TRIGGER;
    public static final Supplier<AllomanticallyActivatedBlockTrigger> ALLOMANTICALLY_ACTIVATED_BLOCK_TRIGGER;
    private static final Supplier<SingletonArgumentInfo<AllomancyPowerType>> CONTAINER_CLASS;

    private ExtrasSetup() {
    }

    public static void register(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        CT.register(bus);
        COMMAND_ARGUMENT_TYPES.register(bus);
        bus.addListener(ExtrasSetup::registerCapabilities);
        NeoForge.EVENT_BUS.addListener(AllomancyPowerCommand::register);
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlock(ALLOMANTICALLY_USABLE_BLOCK, (IBlockCapabilityProvider)new IronLeverBlock.AllomanticUseCapabilityProvider(), new Block[]{(Block)IRON_LEVER.get()});
        event.registerBlock(ALLOMANTICALLY_USABLE_BLOCK, (IBlockCapabilityProvider)new IronButtonBlock.AllomanticUseCapabilityProvider(), new Block[]{(Block)IRON_BUTTON.get(), (Block)INVERTED_IRON_BUTTON.get()});
        event.registerBlock(ALLOMANTICALLY_USABLE_BLOCK, (level, pos, state, blockEntity, context) -> (player, isPush) -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                ALLOMANTICALLY_ACTIVATED_BLOCK_TRIGGER.get().trigger(sp, pos, isPush);
            }
            if (level.isClientSide()) {
                return true;
            }
            Direction direction = player.getNearestViewDirection();
            if (isPush) {
                direction = direction.getOpposite();
            }
            return ((BellBlock)state.getBlock()).onHit(level, state, new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), direction, pos, false), player, true);
        }, new Block[]{Blocks.BELL});
    }

    public static void bootstrapBanners(BootstrapContext<BannerPattern> bootstrapContext) {
        for (ResourceKey<BannerPattern> banner : PATTERNS) {
            bootstrapContext.register(banner, (Object)new BannerPattern(banner.location(), banner.location().toShortLanguageKey()));
        }
    }

    static {
        for (Metal mt : Metal.values()) {
            String name = mt.getName();
            ResourceKey pattern = ResourceKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)Allomancy.rl(name));
            PATTERNS.add((ResourceKey<BannerPattern>)pattern);
            TagKey pattern_key = TagKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)Allomancy.rl(name));
            AllomancyTags.PATTERN_TAGS.add((TagKey<BannerPattern>)pattern_key);
            DeferredItem pattern_item = ITEMS.registerItem(name + "_pattern", props -> new Item(props.stacksTo(1).component(DataComponents.PROVIDES_BANNER_PATTERNS, (Object)pattern_key)));
            PATTERN_ITEMS.add((DeferredItem<Item>)pattern_item);
        }
        CT = DeferredRegister.create((ResourceKey)Registries.TRIGGER_TYPE, (String)"allomancy");
        METAL_USED_ON_ENTITY_TRIGGER = CT.register("metal_used_on_entity", MetalUsedOnEntityTrigger::new);
        METAL_USED_ON_PLAYER_TRIGGER = CT.register("metal_used_on_player", MetalUsedOnPlayerTrigger::new);
        ALLOMANTICALLY_ACTIVATED_BLOCK_TRIGGER = CT.register("activated_allomancy_block", AllomanticallyActivatedBlockTrigger::new);
        CONTAINER_CLASS = COMMAND_ARGUMENT_TYPES.register("allomancy_power", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(AllomancyPowerType.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(AllomancyPowerType::allomancyPowerType)));
    }
}

