/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.client;

import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.consumables.item.component.FlakeStorage;
import com.legobmw99.allomancy.modules.powers.client.gui.MetalSelectScreen;
import com.legobmw99.allomancy.modules.powers.client.network.PowerRequests;
import com.legobmw99.allomancy.modules.powers.client.util.Inputs;
import com.legobmw99.allomancy.modules.powers.client.util.Rendering;
import com.legobmw99.allomancy.modules.powers.client.util.Sounds;
import com.legobmw99.allomancy.modules.powers.client.util.Tracking;
import com.legobmw99.allomancy.modules.powers.data.AllomancerAttachment;
import com.legobmw99.allomancy.modules.powers.data.AllomancerData;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.sound.PlaySoundEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="allomancy", value={Dist.CLIENT})
public final class ClientEventHandler {
    private static final Tracking tracking = new Tracking();
    private static final List<Rendering.Line> narrowLines = new ArrayList<Rendering.Line>();
    private static final List<Rendering.Line> mediumLines = new ArrayList<Rendering.Line>();
    private static final List<Rendering.Line> thickLines = new ArrayList<Rendering.Line>();
    private static final int IRON_STEEL_LINE_COLOR = ARGB.colorFromFloat((float)0.6f, (float)0.0f, (float)0.6f, (float)1.0f);
    private static final int BRONZE_LINE_COLOR = ARGB.colorFromFloat((float)0.6f, (float)0.7f, (float)0.15f, (float)0.15f);
    private static final int GOLD_LINE_COLOR = ARGB.colorFromFloat((float)0.6f, (float)0.9f, (float)0.85f, (float)0.0f);
    private static final int ELECTRUM_LINE_COLOR = ARGB.colorFromFloat((float)0.6f, (float)0.7f, (float)0.8f, (float)0.2f);

    private ClientEventHandler() {
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        HitResult trace;
        int dist_modifier;
        Minecraft mc = Minecraft.getInstance();
        if (mc.isPaused() || mc.player == null || !mc.player.isAlive()) {
            return;
        }
        LocalPlayer player = mc.player;
        AllomancerData data = AllomancerAttachment.get((Player)player);
        if (data.isUninvested()) {
            return;
        }
        int n = dist_modifier = data.isEnhanced() ? 2 : 1;
        if (mc.options.keyAttack.isDown()) {
            trace = Inputs.getMouseOverExtended(20.0f * (float)dist_modifier);
            PowerRequests.metallicPushPull(data, trace, Metal.IRON);
            PowerRequests.emotionPushPull(data, trace, Metal.ZINC);
        }
        if (mc.options.keyUse.isDown()) {
            trace = Inputs.getMouseOverExtended(20.0f * (float)dist_modifier);
            PowerRequests.metallicPushPull(data, trace, Metal.STEEL);
            PowerRequests.emotionPushPull(data, trace, Metal.BRASS);
            PowerRequests.nicrosilEnhance(data, trace);
        }
        tracking.tick();
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        if (event.getAction() == 1) {
            Inputs.acceptAllomancyKeybinds();
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton.Pre event) {
        if (event.getAction() == 1) {
            Inputs.acceptAllomancyKeybinds();
        }
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent.AfterWeather event) {
        GlobalPos seeking;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || !player.isAlive()) {
            return;
        }
        AllomancerData data = AllomancerAttachment.get((Player)player);
        if (data.isUninvested()) {
            return;
        }
        narrowLines.clear();
        mediumLines.clear();
        thickLines.clear();
        if (data.isBurning(Metal.IRON) || data.isBurning(Metal.STEEL)) {
            tracking.forEachMetallicEntity(entity -> narrowLines.add(new Rendering.Line(entity.position(), IRON_STEEL_LINE_COLOR)));
            tracking.forEachMetalBlob(blob -> {
                Rendering.Line line = new Rendering.Line(blob.getCenter(), IRON_STEEL_LINE_COLOR);
                float perfectWidth = 0.3f + (float)blob.size() * 0.4f;
                if (perfectWidth < 2.25f) {
                    narrowLines.add(line);
                } else if (perfectWidth < 4.0f) {
                    mediumLines.add(line);
                } else {
                    thickLines.add(line);
                }
            });
        }
        if ((seeking = data.getSpecialSeekingLoc()) != null && player.level().dimension() == seeking.dimension()) {
            thickLines.add(new Rendering.Line(seeking.pos().getCenter(), BRONZE_LINE_COLOR));
        }
        if (data.isBurning(Metal.BRONZE) && (data.isEnhanced() || !data.isBurning(Metal.COPPER))) {
            tracking.forEachSeeked(playerEntity -> thickLines.add(new Rendering.Line(playerEntity.position(), BRONZE_LINE_COLOR)));
        }
        if (data.isBurning(Metal.GOLD)) {
            player.getLastDeathLocation().ifPresent(arg_0 -> ClientEventHandler.lambda$onRenderLevelStage$3((Player)player, arg_0));
        }
        if (data.isBurning(Metal.ELECTRUM)) {
            GlobalPos spawn = data.getSpawnLoc();
            if (spawn == null && player.level().dimension() == Level.OVERWORLD) {
                LevelData levelData = player.level().getLevelData();
                mediumLines.add(new Rendering.Line(Vec3.atCenterOf((Vec3i)levelData.getSpawnPos()), ELECTRUM_LINE_COLOR));
            } else if (spawn != null && player.level().dimension() == spawn.dimension()) {
                mediumLines.add(new Rendering.Line(Vec3.atCenterOf((Vec3i)spawn.pos()), ELECTRUM_LINE_COLOR));
            }
        }
        float partialTicks = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        Vec3 source = mc.player.getPosition(partialTicks);
        source = mc.options.getCameraType().isFirstPerson() ? source.add(mc.player.getViewVector(partialTicks)) : source.add(0.0, (double)(mc.player.getEyeHeight() / 3.0f * 2.0f), 0.0);
        PoseStack stack = event.getPoseStack();
        stack.pushPose();
        Vec3 view = event.getCamera().getPosition();
        stack.translate(-view.x, -view.y, -view.z);
        Rendering.drawMetalLines(stack, source, narrowLines, 1.5f);
        Rendering.drawMetalLines(stack, source, mediumLines, 3.0f);
        Rendering.drawMetalLines(stack, source, thickLines, 5.0f);
        stack.popPose();
    }

    @SubscribeEvent
    public static void onFovCompute(ComputeFovModifierEvent event) {
        AllomancerData data = AllomancerAttachment.get(event.getPlayer());
        if (data.isBurning(Metal.TIN) && data.isEnhanced()) {
            event.setNewFovModifier(0.2f);
        }
    }

    @SubscribeEvent
    public static void onSound(PlaySoundEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        SoundInstance sound = event.getSound();
        if (player == null || sound == null || !player.isAlive()) {
            return;
        }
        AllomancerData data = AllomancerAttachment.get((Player)player);
        if (data.isBurning(Metal.TIN)) {
            Sounds.spawnParticleForSound((Player)player, sound);
        }
    }

    @SubscribeEvent
    public static void updateInputEvent(MovementInputUpdateEvent event) {
        if (Minecraft.getInstance().screen instanceof MetalSelectScreen) {
            Inputs.fakeMovement(event.getInput());
        }
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        FlakeStorage storage = (FlakeStorage)event.getItemStack().get(ConsumeSetup.FLAKE_STORAGE);
        if (storage != null) {
            ArrayList components = new ArrayList(16);
            storage.addToTooltip(event.getContext(), components::add, event.getFlags(), (DataComponentGetter)event.getItemStack().getComponents());
            int len = event.getToolTip().size();
            int insertLoc = event.getFlags().isAdvanced() ? len - 2 : len;
            event.getToolTip().addAll(insertLoc, components);
        }
    }

    private static /* synthetic */ void lambda$onRenderLevelStage$3(Player player, GlobalPos death) {
        if (player.level().dimension() == death.dimension()) {
            mediumLines.add(new Rendering.Line(Vec3.atCenterOf((Vec3i)death.pos()), GOLD_LINE_COLOR));
        }
    }
}

