/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.client.gui;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.data.IAllomancerData;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.powers.PowersConfig;
import com.legobmw99.allomancy.modules.powers.client.network.PowerRequests;
import com.legobmw99.allomancy.modules.powers.client.util.Inputs;
import com.legobmw99.allomancy.modules.powers.data.AllomancerAttachment;
import com.legobmw99.allomancy.modules.powers.data.AllomancerData;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.event.RegisterPictureInPictureRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterRenderPipelinesEvent;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class MetalSelectScreen
extends Screen {
    private static final String[] METAL_NAMES = (String[])Arrays.stream(Metal.values()).map(Metal::getName).toArray(String[]::new);
    private static final String GUI_METAL = "textures/gui/metals/%s_symbol.png";
    private static final String[] METAL_LOCAL = (String[])Arrays.stream(METAL_NAMES).map(s -> "metals." + s).toArray(String[]::new);
    private static final ResourceLocation[] METAL_ICONS = (ResourceLocation[])Arrays.stream(METAL_NAMES).map(s -> Allomancy.rl(String.format(GUI_METAL, s))).toArray(ResourceLocation[]::new);
    private final Minecraft mc;
    private int timeIn = (Boolean)PowersConfig.animate_selection.get() != false ? 0 : 16;
    protected Metal selectedMetal = null;

    public MetalSelectScreen() {
        super((Component)Component.translatable((String)"allomancy.gui"));
        this.mc = Minecraft.getInstance();
    }

    private static double mouseAngle(int x, int y, int mx, int my) {
        return (Mth.atan2((double)(my - y), (double)(mx - x)) + Math.PI * 2) % (Math.PI * 2);
    }

    private static int toMetalIndex(int segment) {
        return (segment + 5) % Metal.values().length;
    }

    public void render(GuiGraphics guiGraphics, int mx, int my, float partialTicks) {
        super.render(guiGraphics, mx, my, partialTicks);
        AllomancerData data = AllomancerAttachment.get((Player)this.mc.player);
        int x = this.width / 2;
        int y = this.height / 2;
        int maxRadius = 80;
        double angle = MetalSelectScreen.mouseAngle(x, y, mx, my);
        int segments = METAL_NAMES.length;
        float degPer = (float)Math.PI * 2 / (float)segments;
        this.selectedMetal = null;
        guiGraphics.submitPictureInPictureRenderState((PictureInPictureRenderState)new SelectionWheelState(data, angle, (float)this.timeIn + partialTicks, this.width, this.height, guiGraphics.peekScissorStack()));
        for (int seg = 0; seg < segments; ++seg) {
            Metal mt = Metal.getMetal(MetalSelectScreen.toMetalIndex(seg));
            boolean mouseInSector = data.hasPower(mt) && (double)(degPer * (float)seg) < angle && angle < (double)(degPer * (float)(seg + 1));
            float radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
            if (mouseInSector) {
                this.selectedMetal = Metal.getMetal(MetalSelectScreen.toMetalIndex(seg));
                radius *= 1.025f;
            }
            float rad = ((float)seg + 0.5f) * degPer;
            float xp = (float)x + Mth.cos((float)rad) * radius;
            float yp = (float)y + Mth.sin((float)rad) * radius;
            float xsp = xp - 1.0f;
            float ysp = yp;
            String name = String.valueOf(mouseInSector ? ChatFormatting.UNDERLINE : ChatFormatting.RESET) + Component.translatable((String)METAL_LOCAL[MetalSelectScreen.toMetalIndex(seg)]).getString();
            int textwidth = this.font.width(name);
            if (xsp < (float)x) {
                xsp -= (float)(textwidth - 2);
            }
            if (ysp < (float)y) {
                ysp -= 9.0f;
            }
            guiGraphics.drawString(this.font, name, Math.round(xsp), Math.round(ysp), -1, true);
            double mod = 0.8;
            int xdp = (int)((double)(xp - (float)x) * mod + (double)x);
            int ydp = (int)((double)(yp - (float)y) * mod + (double)y);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED_PREMULTIPLIED_ALPHA, METAL_ICONS[MetalSelectScreen.toMetalIndex(seg)], xdp - 8, ydp - 8, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.toggleSelected();
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void tick() {
        ++this.timeIn;
    }

    public boolean keyReleased(int keysym, int scancode, int modifiers) {
        if (Inputs.burn.matches(keysym, scancode)) {
            this.mc.setScreen(null);
            this.mc.mouseHandler.grabMouse();
            return true;
        }
        return super.keyReleased(keysym, scancode, modifiers);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (Inputs.burn.matchesMouse(button)) {
            this.mc.setScreen(null);
            this.mc.mouseHandler.grabMouse();
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    private void toggleSelected() {
        if (this.selectedMetal != null) {
            AllomancerData data = AllomancerAttachment.get((Player)this.mc.player);
            PowerRequests.toggleBurn(this.selectedMetal, data);
            this.mc.player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.1f, 2.0f);
        }
    }

    public void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    public boolean isPauseScreen() {
        return false;
    }

    public record SelectionWheelState(IAllomancerData data, double mouseAngle, float timeInPartial, int x0, int y0, int x1, int y1, @Nullable ScreenRectangle scissorArea, @Nullable ScreenRectangle bounds) implements PictureInPictureRenderState
    {
        private SelectionWheelState(IAllomancerData data, double mouseAngle, float timeInPartial, int width, int height, @Nullable ScreenRectangle scissorArea) {
            this(data, mouseAngle, timeInPartial, 0, 0, width, height, scissorArea, PictureInPictureRenderState.getBounds((int)0, (int)0, (int)width, (int)height, (ScreenRectangle)scissorArea));
        }

        public float scale() {
            return 1.0f;
        }
    }

    public static class SelectionWheelRenderer
    extends PictureInPictureRenderer<SelectionWheelState> {
        private static final RenderPipeline SELECTION_BACKGROUND = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.GUI_SNIPPET}).withLocation("pipeline/allomancy_selection").withVertexShader("core/position_color").withFragmentShader("core/position_color").withCull(false).withBlend(BlendFunction.TRANSLUCENT).withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.TRIANGLE_FAN).build();
        private static final RenderType SELECTION_BACKGROUND_TYPE = RenderType.create((String)"allomancy_selection", (int)1536, (boolean)false, (boolean)true, (RenderPipeline)SELECTION_BACKGROUND, (RenderType.CompositeState)RenderType.CompositeState.builder().createCompositeState(false));

        public SelectionWheelRenderer(MultiBufferSource.BufferSource s) {
            super(s);
        }

        public Class<SelectionWheelState> getRenderStateClass() {
            return SelectionWheelState.class;
        }

        protected void renderToTexture(SelectionWheelState state, PoseStack stack) {
            VertexConsumer vertexconsumer = this.bufferSource.getBuffer(SELECTION_BACKGROUND_TYPE);
            IAllomancerData data = state.data;
            int x = (state.x0 + state.x1) / 2;
            int y = (state.y0 + state.y1) / 2;
            int maxRadius = 80;
            stack.translate((float)(-x), (float)(-y), 0.0f);
            Matrix4f matrix4f = stack.last().pose();
            int segments = METAL_NAMES.length;
            float step = (float)Math.PI / 180;
            float degPer = (float)Math.PI * 2 / (float)segments;
            vertexconsumer.addVertex(matrix4f, (float)x, (float)y, 0.0f).setColor(25, 25, 25, 5);
            for (int seg = 0; seg < segments; ++seg) {
                Metal mt = Metal.getMetal(MetalSelectScreen.toMetalIndex(seg));
                boolean mouseInSector = data.hasPower(mt) && (double)(degPer * (float)seg) < state.mouseAngle && state.mouseAngle < (double)(degPer * (float)(seg + 1));
                float radius = Math.max(0.0f, Math.min((state.timeInPartial - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
                if (mouseInSector) {
                    radius *= 1.025f;
                }
                int gs = 85;
                if (seg % 2 == 0) {
                    gs += 25;
                }
                gs = !data.hasPower(mt) || data.getStored(mt) == 0 ? 0 : gs;
                int r = data.isBurning(mt) ? 255 : gs;
                int g = gs;
                int b = gs;
                int a = 153;
                for (float v = 0.0f; v < degPer + step / 2.0f; v += step) {
                    float rad = v + (float)seg * degPer;
                    float xp = (float)x + Mth.cos((float)rad) * radius;
                    float yp = (float)y + Mth.sin((float)rad) * radius;
                    if (v == 0.0f) {
                        vertexconsumer.addVertex(matrix4f, xp, yp, 0.0f).setColor(r, g, b, a);
                    }
                    vertexconsumer.addVertex(matrix4f, xp, yp, 0.0f).setColor(r, g, b, a);
                }
            }
        }

        protected float getTranslateY(int height, int guiScale) {
            return (float)height / 2.0f;
        }

        protected String getTextureLabel() {
            return "metal selection";
        }

        public static void registerPipeline(RegisterRenderPipelinesEvent event) {
            event.registerPipeline(SELECTION_BACKGROUND);
        }

        public static void registerPiP(RegisterPictureInPictureRenderersEvent event) {
            event.register(SelectionWheelState.class, SelectionWheelRenderer::new);
        }
    }
}

