/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.client.util;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DynamicUniforms;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RegisterRenderPipelinesEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public final class Rendering {
    private static final RenderSystem.AutoStorageIndexBuffer indices = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.LINES);
    private static final RenderPipeline METAL_LINES = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.LINES_SNIPPET}).withLocation("pipeline/allomancy_lines").withVertexShader("core/rendertype_lines").withFragmentShader("core/rendertype_lines").withCull(false).withBlend(BlendFunction.TRANSLUCENT).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withDepthWrite(false).withVertexFormat(DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES).build();

    private Rendering() {
    }

    public static void drawMetalLines(PoseStack stack, Vec3 source, List<Line> lines, float width) {
        if (lines.isEmpty()) {
            return;
        }
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder builder = tesselator.begin(METAL_LINES.getVertexFormatMode(), METAL_LINES.getVertexFormat());
        PoseStack.Pose pose = stack.last();
        Vector3f src = source.toVector3f();
        Vector3f normal = new Vector3f();
        for (Line line : lines) {
            Vector3f dest = line.dest.toVector3f();
            dest.normalize(normal);
            builder.addVertex(pose, src).setColor(line.color).setNormal(pose, normal);
            builder.addVertex(pose, dest).setColor(line.color).setNormal(pose, normal);
        }
        GpuBufferSlice[] dynamic = RenderSystem.getDynamicUniforms().writeTransforms(new DynamicUniforms.Transform[]{new DynamicUniforms.Transform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(0.0f, 0.0f, 0.0f, 0.3f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), width * 2.5f), new DynamicUniforms.Transform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), width)});
        try (MeshData meshData = builder.buildOrThrow();){
            GpuBuffer vertexBuffer = METAL_LINES.getVertexFormat().uploadImmediateVertexBuffer(meshData.vertexBuffer());
            RenderTarget renderTarget = Minecraft.getInstance().getMainRenderTarget();
            if (renderTarget.getColorTextureView() == null) {
                return;
            }
            int indexCount = meshData.drawState().indexCount();
            GpuBuffer gpuBuffer = indices.getBuffer(indexCount);
            try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "allomancy lines", renderTarget.getColorTextureView(), OptionalInt.empty(), renderTarget.getDepthTextureView(), OptionalDouble.empty());){
                renderPass.setPipeline(METAL_LINES);
                RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
                renderPass.setIndexBuffer(gpuBuffer, indices.type());
                renderPass.setVertexBuffer(0, vertexBuffer);
                renderPass.setUniform("DynamicTransforms", dynamic[0]);
                renderPass.drawIndexed(0, 0, indexCount, 1);
                renderPass.setUniform("DynamicTransforms", dynamic[1]);
                renderPass.drawIndexed(0, 0, indexCount, 1);
            }
        }
        RenderSystem.lineWidth((float)1.0f);
        tesselator.clear();
    }

    public static void registerPipeline(RegisterRenderPipelinesEvent event) {
        event.registerPipeline(METAL_LINES);
    }

    public record Line(Vec3 dest, int color) {
    }
}

