/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.client.util;

import com.legobmw99.allomancy.modules.powers.client.particle.SoundParticleData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public final class Sounds {
    private Sounds() {
    }

    public static void soundForBurnChange(boolean burning) {
        if (burning) {
            Minecraft.getInstance().player.playSound(SoundEvent.createFixedRangeEvent((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"item.flintandsteel.use"), (float)1.0f), 1.0f, 5.0f);
        } else {
            Minecraft.getInstance().player.playSound(SoundEvent.createFixedRangeEvent((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"block.fire.extinguish"), (float)1.0f), 1.0f, 4.0f);
        }
    }

    public static void spawnParticleForSound(Player player, SoundInstance sound) {
        double magnitude = Math.sqrt(player.position().distanceToSqr(sound.getX(), sound.getY(), sound.getZ()));
        if (magnitude > 25.0 || magnitude < 3.0) {
            return;
        }
        Vec3 vec = player.position();
        double posX = vec.x();
        double posY = vec.y();
        double posZ = vec.z();
        String soundName = sound.getLocation().toString();
        if (soundName.contains("entity") || soundName.contains("step")) {
            double motionX = (posX - (sound.getX() + 0.5)) * -0.7 / magnitude;
            double motionY = (posY - (sound.getY() + 0.2)) * -0.7 / magnitude;
            double motionZ = (posZ - (sound.getZ() + 0.5)) * -0.7 / magnitude;
            Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)new SoundParticleData(sound.getSource()), posX + Math.sin(Math.toRadians(player.getYHeadRot())) * -0.7, posY + 0.2, posZ + Math.cos(Math.toRadians(player.getYHeadRot())) * 0.7, motionX, motionY, motionZ);
        }
    }
}

