/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.data;

import com.legobmw99.allomancy.api.data.IAllomancerData;
import com.legobmw99.allomancy.api.enums.Metal;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AllomancerData
implements IAllomancerData {
    private static final int[] MAX_BURN_TIME = new int[]{1800, 1800, 3600, 600, 1800, 1800, 2400, 1600, 100, 20, 300, 40, 1000, 10000, 3600, 160};
    private final EnumMap<Metal, Boolean> allomantic_powers;
    private final EnumMap<Metal, Integer> metal_amounts;
    private final EnumMap<Metal, Boolean> burning_metals;
    private GlobalPos spawn_pos = null;
    private GlobalPos seeking_pos = null;
    private int enhanced_time = 0;
    private final int[] burn_time = Arrays.copyOf(MAX_BURN_TIME, Metal.values().length);
    private int damage_stored = 0;
    public static final MapCodec<AllomancerData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)AllomancerData.metalMapCodec(Codec.BOOL).fieldOf("abilities").forGetter(data -> data.allomantic_powers), (App)AllomancerData.metalMapCodec(Codec.BOOL).fieldOf("metal_burning").forGetter(data -> data.burning_metals), (App)AllomancerData.metalMapCodec(Codec.INT).fieldOf("metal_storage").forGetter(data -> data.metal_amounts), (App)Codec.pair((Codec)GlobalPos.CODEC.lenientOptionalFieldOf("spawn_pos").codec(), (Codec)GlobalPos.CODEC.lenientOptionalFieldOf("seeking_pos").codec()).lenientOptionalFieldOf("positions", (Object)new Pair(Optional.empty(), Optional.empty())).forGetter(data -> new Pair(Optional.ofNullable(data.spawn_pos), Optional.ofNullable(data.seeking_pos)))).apply((Applicative)instance, AllomancerData::new));
    public static final StreamCodec<FriendlyByteBuf, AllomancerData> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, AllomancerData>(){

        @NotNull
        public AllomancerData decode(@NotNull FriendlyByteBuf buffer) {
            AllomancerData data = new AllomancerData();
            for (Metal mt : Metal.values()) {
                data.allomantic_powers.put(mt, buffer.readBoolean());
            }
            for (Metal mt : Metal.values()) {
                data.burning_metals.put(mt, buffer.readBoolean());
            }
            for (Metal mt : Metal.values()) {
                data.metal_amounts.put(mt, buffer.readInt());
            }
            if (buffer.readBoolean()) {
                data.spawn_pos = buffer.readGlobalPos();
            }
            if (buffer.readBoolean()) {
                data.seeking_pos = buffer.readGlobalPos();
            }
            data.enhanced_time = buffer.readInt();
            return data;
        }

        public void encode(@NotNull FriendlyByteBuf buffer, AllomancerData data) {
            for (Metal mt : Metal.values()) {
                buffer.writeBoolean(data.allomantic_powers.getOrDefault((Object)mt, false).booleanValue());
            }
            for (Metal mt : Metal.values()) {
                buffer.writeBoolean(data.burning_metals.getOrDefault((Object)mt, false).booleanValue());
            }
            for (Metal mt : Metal.values()) {
                buffer.writeInt(data.metal_amounts.getOrDefault((Object)mt, 0).intValue());
            }
            if (data.spawn_pos != null) {
                buffer.writeBoolean(true);
                buffer.writeGlobalPos(data.spawn_pos);
            } else {
                buffer.writeBoolean(false);
            }
            if (data.seeking_pos != null) {
                buffer.writeBoolean(true);
                buffer.writeGlobalPos(data.seeking_pos);
            } else {
                buffer.writeBoolean(false);
            }
            buffer.writeInt(data.enhanced_time);
        }
    };

    public AllomancerData() {
        this.allomantic_powers = new EnumMap(Metal.class);
        this.metal_amounts = new EnumMap(Metal.class);
        this.burning_metals = new EnumMap(Metal.class);
        for (Metal mt : Metal.values()) {
            this.allomantic_powers.put(mt, false);
            this.metal_amounts.put(mt, 0);
            this.burning_metals.put(mt, false);
        }
    }

    @Override
    public boolean tickBurning() {
        boolean sync = false;
        for (Metal metal : Metal.values()) {
            if (!this.isBurning(metal)) continue;
            if (!this.hasPower(metal)) {
                this.setBurning(metal, false);
                sync = true;
                continue;
            }
            int n = metal.getIndex();
            this.burn_time[n] = this.burn_time[n] - 1;
            if (this.burn_time[metal.getIndex()] > 0) continue;
            if (this.getStored(metal) <= 0) {
                this.setBurning(metal, false);
            } else {
                this.decrementStored(metal);
            }
            sync = true;
            this.burn_time[metal.getIndex()] = MAX_BURN_TIME[metal.getIndex()];
        }
        return sync;
    }

    @Override
    public boolean hasPower(Metal metal) {
        return this.allomantic_powers.getOrDefault((Object)metal, false);
    }

    @Override
    public int getPowerCount() {
        int count = 0;
        for (boolean power : this.allomantic_powers.values()) {
            if (!power) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Metal[] getPowers() {
        return (Metal[])Arrays.stream(Metal.values()).filter(this::hasPower).toArray(Metal[]::new);
    }

    @Override
    public boolean isMistborn() {
        for (boolean power : this.allomantic_powers.values()) {
            if (power) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setMistborn() {
        for (Metal mt : Metal.values()) {
            this.allomantic_powers.put(mt, true);
        }
    }

    @Override
    public boolean isUninvested() {
        for (boolean power : this.allomantic_powers.values()) {
            if (!power) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setUninvested() {
        for (Metal mt : Metal.values()) {
            this.allomantic_powers.put(mt, false);
        }
    }

    @Override
    public void addPower(Metal metal) {
        this.allomantic_powers.put(metal, true);
    }

    @Override
    public void revokePower(Metal metal) {
        this.allomantic_powers.put(metal, false);
    }

    @Override
    public boolean isBurning(Metal metal) {
        return this.burning_metals.getOrDefault((Object)metal, false);
    }

    @Override
    public void setBurning(Metal metal, boolean metalBurning) {
        this.burning_metals.put(metal, metalBurning);
    }

    @Override
    public int getStored(Metal metal) {
        return this.metal_amounts.getOrDefault((Object)metal, 0);
    }

    @Override
    public void incrementStored(Metal metal) {
        int current = this.metal_amounts.getOrDefault((Object)metal, 0);
        if (current < 10) {
            this.metal_amounts.put(metal, current + 1);
        }
    }

    @Override
    public void decrementStored(Metal metal) {
        int current = this.metal_amounts.getOrDefault((Object)metal, 0);
        if (current > 0) {
            this.metal_amounts.put(metal, current - 1);
        }
    }

    @Override
    public void drainMetals(Metal ... metals) {
        for (Metal mt : metals) {
            this.metal_amounts.put(mt, 0);
            this.burn_time[mt.getIndex()] = MAX_BURN_TIME[mt.getIndex()];
            this.burning_metals.put(mt, false);
        }
    }

    @Override
    public int getDamageStored() {
        return this.damage_stored;
    }

    @Override
    public void setDamageStored(int damageStored) {
        this.damage_stored = damageStored;
    }

    @Override
    public void setSpawnLoc(@Nullable BlockPos pos, @Nullable ResourceKey<Level> dim) {
        if (pos != null && dim != null) {
            this.spawn_pos = GlobalPos.of(dim, (BlockPos)pos);
        }
    }

    @Override
    @Nullable
    public GlobalPos getSpawnLoc() {
        return this.spawn_pos;
    }

    @Override
    public void setSpecialSeekingLoc(@Nullable BlockPos pos, @Nullable ResourceKey<Level> dim) {
        this.seeking_pos = pos != null && dim != null ? GlobalPos.of(dim, (BlockPos)pos) : null;
    }

    @Override
    @Nullable
    public GlobalPos getSpecialSeekingLoc() {
        return this.seeking_pos;
    }

    @Override
    public void decrementEnhanced() {
        if (this.isEnhanced()) {
            --this.enhanced_time;
        }
    }

    @Override
    public boolean isEnhanced() {
        return this.enhanced_time > 0;
    }

    @Override
    public void setEnhanced(int time) {
        this.enhanced_time = time;
    }

    private static <V> Codec<EnumMap<Metal, V>> metalMapCodec(Codec<V> v) {
        return Codec.unboundedMap(Metal.CODEC, v).xmap(EnumMap::new, Function.identity());
    }

    private AllomancerData(EnumMap<Metal, Boolean> powers, EnumMap<Metal, Boolean> burning, EnumMap<Metal, Integer> amounts, Pair<Optional<GlobalPos>, Optional<GlobalPos>> positions) {
        this.allomantic_powers = powers;
        this.burning_metals = burning;
        this.metal_amounts = amounts;
        ((Optional)positions.getFirst()).ifPresent(spawn_pos -> {
            this.spawn_pos = spawn_pos;
        });
        ((Optional)positions.getSecond()).ifPresent(seeking_pos -> {
            this.seeking_pos = seeking_pos;
        });
    }
}

