/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.network;

import com.legobmw99.allomancy.modules.powers.network.BlockPushPullPayload;
import com.legobmw99.allomancy.modules.powers.network.EmotionPayload;
import com.legobmw99.allomancy.modules.powers.network.EnhanceTimePayload;
import com.legobmw99.allomancy.modules.powers.network.EntityPushPullPayload;
import com.legobmw99.allomancy.modules.powers.network.ServerPayloadHandler;
import com.legobmw99.allomancy.modules.powers.network.ToggleBurnPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public final class Network {
    public static void register(IEventBus bus) {
        bus.addListener(Network::registerPayloads);
    }

    private static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("allomancy").versioned("3.1");
        registrar.playToServer(EmotionPayload.TYPE, EmotionPayload.STREAM_CODEC, ServerPayloadHandler::changeEmotion);
        registrar.playToServer(BlockPushPullPayload.TYPE, BlockPushPullPayload.STREAM_CODEC, ServerPayloadHandler::tryPushPullBlock);
        registrar.playToServer(EntityPushPullPayload.TYPE, EntityPushPullPayload.STREAM_CODEC, ServerPayloadHandler::tryPushPullEntity);
        registrar.playToServer(ToggleBurnPayload.TYPE, ToggleBurnPayload.STREAM_CODEC, ServerPayloadHandler::toggleBurnRequest);
        registrar.playBidirectional(EnhanceTimePayload.TYPE, EnhanceTimePayload.STREAM_CODEC, ServerPayloadHandler::updateEnhanced);
    }

    public static void sync(CustomPacketPayload msg, ServerPlayer player) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private Network() {
    }
}

