/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.util;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.modules.powers.entity.ai.AIAttackOnCollideExtended;
import com.legobmw99.allomancy.modules.powers.entity.ai.AIEvilAttack;
import com.legobmw99.allomancy.util.AllomancyTags;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public final class Emotional {
    private static final Predicate<Goal> isAggroGoal = goal -> goal instanceof SwellGoal || goal instanceof AIAttackOnCollideExtended || goal instanceof MeleeAttackGoal || goal instanceof TargetGoal || goal instanceof PanicGoal || goal.getClass().getName().contains("Fireball") || goal.getClass().getName().contains("Attack") || goal.getClass().getName().contains("Anger");

    private Emotional() {
    }

    public static void riot(PathfinderMob target, Player allomancer, boolean enhanced) {
        try {
            if (!enhanced) {
                if (Emotional.hasTinFoilHat((LivingEntity)target)) {
                    return;
                }
                target.targetSelector.enableControlFlag(Goal.Flag.TARGET);
                target.setTarget((LivingEntity)allomancer);
                target.setLastHurtByMob((LivingEntity)allomancer);
                target.targetSelector.addGoal(1, (Goal)new AIAttackOnCollideExtended(target, 1.0, false));
                target.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)target, Player.class, false));
                target.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)target, target.getClass(), false));
                target.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)target));
                target.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal(target, new Class[0]).setAlertOthers(new Class[0]));
                if (target.getAttribute(Attributes.ATTACK_DAMAGE) != null && !(target instanceof Guardian)) {
                    target.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal(target, 1.2, true));
                }
                target.setAggressive(true);
                PathfinderMob pathfinderMob = target;
                Objects.requireNonNull(pathfinderMob);
                PathfinderMob pathfinderMob2 = pathfinderMob;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Creeper.class, Rabbit.class, AbstractSkeleton.class, Illusioner.class, Pillager.class}, (Object)pathfinderMob2, n)) {
                    case 0: {
                        Creeper creeper = (Creeper)pathfinderMob2;
                        target.goalSelector.addGoal(1, (Goal)new SwellGoal(creeper));
                        break;
                    }
                    case 1: {
                        Rabbit rabbit = (Rabbit)pathfinderMob2;
                        target.goalSelector.addGoal(1, (Goal)new AIEvilAttack(rabbit));
                        break;
                    }
                    case 2: {
                        AbstractSkeleton skeleton = (AbstractSkeleton)pathfinderMob2;
                        target.goalSelector.addGoal(1, (Goal)new RangedBowAttackGoal((Monster)skeleton, 1.0, 20, 15.0f));
                        break;
                    }
                    case 3: {
                        Illusioner illusioner = (Illusioner)pathfinderMob2;
                        target.goalSelector.addGoal(1, (Goal)new RangedBowAttackGoal((Monster)illusioner, 0.5, 20, 15.0f));
                        break;
                    }
                    case 4: {
                        Pillager pillager = (Pillager)pathfinderMob2;
                        target.goalSelector.addGoal(2, (Goal)new RangedCrossbowAttackGoal((Monster)pillager, 1.0, 8.0f));
                        break;
                    }
                }
            } else {
                target.level().explode((Entity)target, target.position().x(), target.position().y(), target.position().z(), 1.2f, false, Level.ExplosionInteraction.MOB);
                Level level = target.level();
                if (level instanceof ServerLevel) {
                    ServerLevel level2 = (ServerLevel)level;
                    target.kill(level2);
                }
            }
        }
        catch (Exception e) {
            Allomancy.LOGGER.error("Failed to riot entity {}! Please report this error!", (Object)target, (Object)e);
        }
    }

    public static void soothe(PathfinderMob target, Player allomancer, boolean enhanced) {
        try {
            if (!enhanced) {
                if (Emotional.hasTinFoilHat((LivingEntity)target)) {
                    return;
                }
                if (target.isNoAi()) {
                    target.setNoAi(false);
                }
                target.goalSelector.getAvailableGoals().stream().filter(WrappedGoal::isRunning).filter(isAggroGoal).forEach(WrappedGoal::stop);
                target.targetSelector.getAvailableGoals().stream().filter(WrappedGoal::isRunning).filter(isAggroGoal).forEach(WrappedGoal::stop);
                target.goalSelector.tick();
                target.targetSelector.tick();
                target.setTarget(null);
                target.setLastHurtByMob(null);
                target.targetSelector.disableControlFlag(Goal.Flag.TARGET);
                target.setAggressive(false);
                target.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)target, Player.class, 6.0f));
                PathfinderMob pathfinderMob = target;
                Objects.requireNonNull(pathfinderMob);
                PathfinderMob pathfinderMob2 = pathfinderMob;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractHorse.class, TamableAnimal.class, Sheep.class, Villager.class, WanderingTrader.class}, (Object)pathfinderMob2, n)) {
                    case 0: {
                        AbstractHorse horse = (AbstractHorse)pathfinderMob2;
                        if (!(Math.random() < 0.3)) break;
                        horse.tameWithName(allomancer);
                        break;
                    }
                    case 1: {
                        TamableAnimal animal = (TamableAnimal)pathfinderMob2;
                        if (!(Math.random() < 0.3)) break;
                        animal.tame(allomancer);
                        break;
                    }
                    case 2: {
                        Sheep ignored = (Sheep)pathfinderMob2;
                        target.goalSelector.addGoal(1, (Goal)new EatBlockGoal((Mob)target));
                        break;
                    }
                    case 3: {
                        Villager villager = (Villager)pathfinderMob2;
                        villager.onReputationEventFrom(ReputationEventType.TRADE, (Entity)allomancer);
                        break;
                    }
                    case 4: {
                        WanderingTrader ignored = (WanderingTrader)pathfinderMob2;
                        target.goalSelector.addGoal(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)target));
                        break;
                    }
                }
            } else {
                target.setNoAi(true);
            }
        }
        catch (Exception e) {
            Allomancy.LOGGER.error("Failed to soothe entity {}! Please report this error!", (Object)target, (Object)e);
        }
    }

    public static boolean hasTinFoilHat(LivingEntity entity) {
        return entity.getItemBySlot(EquipmentSlot.HEAD).is(AllomancyTags.TIN_FOIL_HATS);
    }
}

