/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.util;

import com.legobmw99.allomancy.api.data.IAllomancerData;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class Temporal {
    private Temporal() {
    }

    public static void speedUpNearby(ServerPlayer curPlayer, ServerLevel level, IAllomancerData data) {
        curPlayer.addEffect(new MobEffectInstance(MobEffects.HASTE, 10, 3, true, false));
        int max = data.isEnhanced() ? 10 : 5;
        BlockPos negative = curPlayer.blockPosition().offset(-max, -max, -max);
        BlockPos positive = curPlayer.blockPosition().offset(max, max, max);
        level.getEntitiesOfClass(LivingEntity.class, AABB.encapsulatingFullBlocks((BlockPos)negative, (BlockPos)positive)).forEach(entity -> {
            ExtrasSetup.METAL_USED_ON_ENTITY_TRIGGER.get().trigger(curPlayer, (Entity)entity, Metal.BENDALLOY, data.isEnhanced());
            entity.aiStep();
            entity.aiStep();
        });
        BlockPos.betweenClosedStream((BlockPos)negative, (BlockPos)positive).forEach(bp -> {
            block4: {
                EntityBlock eb;
                BlockEntityTicker ticker;
                BlockEntity te;
                BlockState block;
                block3: {
                    block = level.getBlockState(bp);
                    te = level.getBlockEntity(bp);
                    if (te != null) break block3;
                    if (!block.isRandomlyTicking()) break block4;
                    for (int i = 0; i < max * 4 / 15; ++i) {
                        block.randomTick(level, bp, level.random);
                    }
                    break block4;
                }
                Block underlying_block = block.getBlock();
                if (underlying_block instanceof EntityBlock && (ticker = (eb = (EntityBlock)underlying_block).getTicker((Level)level, block, te.getType())) != null) {
                    for (int i = 0; i < max * 4 / 3; ++i) {
                        ticker.tick((Level)level, bp, block, te);
                    }
                }
            }
        });
    }

    public static void slowDownNearby(ServerPlayer curPlayer, ServerLevel level, IAllomancerData data) {
        int max = data.isEnhanced() ? 20 : 10;
        Vec3 negative = curPlayer.position().add((double)(-max), (double)(-max), (double)(-max));
        Vec3 positive = curPlayer.position().add((double)max, (double)max, (double)max);
        int slowness_amplifier = data.isEnhanced() ? 255 : 2;
        level.getEntitiesOfClass(LivingEntity.class, new AABB(negative, positive)).forEach(entity -> {
            ExtrasSetup.METAL_USED_ON_ENTITY_TRIGGER.get().trigger(curPlayer, (Entity)entity, Metal.CADMIUM, data.isEnhanced());
            entity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 10, 0, true, false));
            if (entity != curPlayer) {
                entity.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 10, slowness_amplifier, true, false));
            }
        });
    }
}

