/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.world;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.world.block.LerasiumFluid;
import com.legobmw99.allomancy.modules.world.block.LiquidLerasiumBlock;
import com.legobmw99.allomancy.modules.world.loot.DaggerLootModifier;
import com.legobmw99.allomancy.modules.world.loot.PlayerInvestmentCondition;
import com.legobmw99.allomancy.modules.world.recipe.InvestingRecipe;
import com.legobmw99.allomancy.util.AllomancyTags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public final class WorldSetup {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"allomancy");
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"allomancy");
    private static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES, (String)"allomancy");
    private static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"allomancy");
    public static final Supplier<FluidType> LERAS_TYPE = FLUID_TYPES.register("lerasium", () -> new FluidType(FluidType.Properties.create().canConvertToSource(false).lightLevel(14).fallDistanceModifier(0.0f).canHydrate(false).canSwim(false).supportsBoating(false).canDrown(false).rarity(Rarity.EPIC).pathType(PathType.LAVA)));
    public static final Supplier<FlowingFluid> LERASIUM_FLUID = FLUIDS.register("lerasium", () -> new LerasiumFluid(WorldSetup.makeProps()));
    public static final DeferredBlock<LiquidBlock> LIQUID_LERASIUM = BLOCKS.registerBlock("liquid_lerasium", props -> new LiquidLerasiumBlock(LERASIUM_FLUID.get(), (BlockBehaviour.Properties)props), BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).noCollission().strength(100.0f).pushReaction(PushReaction.DESTROY).noLootTable().lightLevel(state -> 14).liquid().sound(SoundType.EMPTY));
    public static final OreConfig[] ORE_METALS = new OreConfig[]{new OreConfig("aluminum", 9, 11, 40, 120), new OreConfig("cadmium", 7, 4, -60, 0), new OreConfig("chromium", 6, 6, -30, 30), new OreConfig("lead", 9, 12, -40, 30), new OreConfig("silver", 7, 8, -40, 30), new OreConfig("tin", 11, 12, 30, 112), new OreConfig("zinc", 8, 9, 40, 80)};
    public static final ResourceKey<Structure> WELL = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)Allomancy.rl("well"));
    private static final ResourceKey<StructureTemplatePool> WELL_POOL = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)Allomancy.rl("well_pool"));
    private static final ResourceKey<StructureSet> WELLS = ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)Allomancy.rl("wells"));
    private static final ResourceKey<BiomeModifier> ADD_ALLOMANCY_ORES = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Allomancy.rl("overworld_ores"));
    public static final List<DeferredItem<Item>> FLAKES = new ArrayList<DeferredItem<Item>>();
    public static final List<DeferredItem<Item>> NUGGETS = new ArrayList<DeferredItem<Item>>();
    public static final List<DeferredItem<Item>> INGOTS = new ArrayList<DeferredItem<Item>>();
    public static final List<DeferredBlock<Block>> STORAGE_BLOCKS = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredItem<BlockItem>> STORAGE_BLOCK_ITEMS = new ArrayList<DeferredItem<BlockItem>>();
    public static final List<DeferredBlock<Block>> ORE_BLOCKS = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredItem<BlockItem>> ORE_BLOCKS_ITEMS = new ArrayList<DeferredItem<BlockItem>>();
    public static final List<DeferredBlock<Block>> DEEPSLATE_ORE_BLOCKS = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredItem<BlockItem>> DEEPSLATE_ORE_BLOCKS_ITEMS = new ArrayList<DeferredItem<BlockItem>>();
    public static final List<DeferredBlock<Block>> RAW_ORE_BLOCKS = new ArrayList<DeferredBlock<Block>>();
    public static final List<DeferredItem<BlockItem>> RAW_ORE_BLOCKS_ITEMS = new ArrayList<DeferredItem<BlockItem>>();
    public static final List<DeferredItem<Item>> RAW_ORE_ITEMS = new ArrayList<DeferredItem<Item>>();
    public static int METAL_ITEM_LEN = Metal.values().length;
    public static final int LEAD = METAL_ITEM_LEN++;
    public static final int SILVER = METAL_ITEM_LEN++;
    private static final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> GLM;
    public static final Supplier<MapCodec<DaggerLootModifier>> DAGGER_LOOT;
    private static final DeferredRegister<LootItemConditionType> LOOT_CONDITIONS;
    public static final Supplier<LootItemConditionType> PLAYER_INVESTMENT;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPES;
    public static final Supplier<RecipeSerializer<InvestingRecipe>> INVESTING_RECIPE_SERIALIZER;
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPES;
    public static final Supplier<RecipeType<InvestingRecipe>> INVESTING_RECIPE;

    private static BaseFlowingFluid.Properties makeProps() {
        return new BaseFlowingFluid.Properties(LERAS_TYPE, LERASIUM_FLUID, LERASIUM_FLUID).block(LIQUID_LERASIUM).explosionResistance(100.0f).levelDecreasePerBlock(8);
    }

    public static void register(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        GLM.register(bus);
        FLUID_TYPES.register(bus);
        FLUIDS.register(bus);
        RECIPES.register(bus);
        RECIPE_TYPES.register(bus);
        LOOT_CONDITIONS.register(bus);
    }

    private static DeferredBlock<Block> registerStandardBlock(String name) {
        return BLOCKS.registerBlock(name, Block::new, Blocks.STONE.properties().strength(2.1f).requiresCorrectToolForDrops());
    }

    private static DeferredBlock<Block> registerStandardOre(String name) {
        return BLOCKS.registerBlock(name, Block::new, Blocks.IRON_ORE.properties());
    }

    private static DeferredBlock<Block> registerDeepslateOre(String name) {
        return BLOCKS.registerBlock(name, Block::new, Blocks.DEEPSLATE_IRON_ORE.properties().strength(4.5f, 3.0f));
    }

    public static void bootstrapConfigured(BootstrapContext<ConfiguredFeature<?, ?>> bootstrap) {
        TagMatchTest stone = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslate = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        for (int i = 0; i < ORE_METALS.length; ++i) {
            OreConfig ore = ORE_METALS[i];
            DeferredBlock<Block> ore_block = ORE_BLOCKS.get(i);
            DeferredBlock<Block> deepslate_ore_block = DEEPSLATE_ORE_BLOCKS.get(i);
            bootstrap.register(ore.getRegistryKey(Registries.CONFIGURED_FEATURE, "_ore_feature"), (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(List.of(OreConfiguration.target((RuleTest)stone, (BlockState)((Block)ore_block.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslate, (BlockState)((Block)deepslate_ore_block.get()).defaultBlockState())), ore.size())));
        }
    }

    public static void bootstrapPlaced(BootstrapContext<PlacedFeature> bootstrap) {
        for (OreConfig ore : ORE_METALS) {
            HolderGetter configured = bootstrap.lookup(Registries.CONFIGURED_FEATURE);
            bootstrap.register(ore.getRegistryKey(Registries.PLACED_FEATURE, "_ore"), (Object)new PlacedFeature((Holder)configured.getOrThrow(ore.getRegistryKey(Registries.CONFIGURED_FEATURE, "_ore_feature")), List.of(CountPlacement.of((int)ore.placementCount), InSquarePlacement.spread(), HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)ore.minHeight), (VerticalAnchor)VerticalAnchor.absolute((int)ore.maxHeight)), BiomeFilter.biome())));
        }
    }

    public static void bootstrapBiomeModifier(BootstrapContext<BiomeModifier> bootstrap) {
        HolderSet.Named overworldTag = bootstrap.lookup(Registries.BIOME).getOrThrow(BiomeTags.IS_OVERWORLD);
        HolderGetter placed = bootstrap.lookup(Registries.PLACED_FEATURE);
        ArrayList<Holder.Reference> ores = new ArrayList<Holder.Reference>();
        for (OreConfig ore : ORE_METALS) {
            ores.add(placed.getOrThrow(ore.getRegistryKey(Registries.PLACED_FEATURE, "_ore")));
        }
        bootstrap.register(ADD_ALLOMANCY_ORES, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworldTag, (HolderSet)HolderSet.direct(ores), GenerationStep.Decoration.UNDERGROUND_ORES));
    }

    public static void bootstrapStructures(BootstrapContext<Structure> bootstrapContext) {
        bootstrapContext.register(WELL, (Object)new JigsawStructure(new Structure.StructureSettings.Builder((HolderSet)bootstrapContext.lookup(Registries.BIOME).getOrThrow(AllomancyTags.SPAWNS_WELLS)).generationStep(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).terrainAdapation(TerrainAdjustment.NONE).spawnOverrides(Map.of(MobCategory.AMBIENT, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedList.of()), MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedList.of()))).build(), (Holder)bootstrapContext.lookup(Registries.TEMPLATE_POOL).getOrThrow(WELL_POOL), Optional.empty(), 1, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)-16)), false, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 3, List.of(), DimensionPadding.ZERO, LiquidSettings.IGNORE_WATERLOGGING));
    }

    public static void bootstrapTemplatePools(BootstrapContext<StructureTemplatePool> bootstrapContext) {
        bootstrapContext.register(WELL_POOL, (Object)new StructureTemplatePool((Holder)bootstrapContext.lookup(Registries.TEMPLATE_POOL).getOrThrow(Pools.EMPTY), List.of(Pair.of((Object)StructurePoolElement.single((String)Allomancy.rl("mountain_well").toString(), (LiquidSettings)LiquidSettings.IGNORE_WATERLOGGING), (Object)1)), StructureTemplatePool.Projection.RIGID));
    }

    public static void bootstrapStructureSets(BootstrapContext<StructureSet> bootstrapContext) {
        bootstrapContext.register(WELLS, (Object)new StructureSet((Holder)bootstrapContext.lookup(Registries.STRUCTURE).getOrThrow(WELL), (StructurePlacement)new RandomSpreadStructurePlacement(Vec3i.ZERO, StructurePlacement.FrequencyReductionMethod.DEFAULT, 1.0f, 161616, Optional.empty(), 16, 8, RandomSpreadType.LINEAR)));
    }

    private WorldSetup() {
    }

    static {
        for (Metal metal : Metal.values()) {
            String name = metal.getName();
            FLAKES.add((DeferredItem<Item>)ITEMS.registerSimpleItem(name + "_flakes"));
            if (metal.isVanilla()) {
                NUGGETS.add(null);
                INGOTS.add(null);
                STORAGE_BLOCKS.add(null);
                STORAGE_BLOCK_ITEMS.add(null);
                continue;
            }
            NUGGETS.add((DeferredItem<Item>)ITEMS.registerSimpleItem(name + "_nugget"));
            INGOTS.add((DeferredItem<Item>)ITEMS.registerSimpleItem(name + "_ingot"));
            STORAGE_BLOCKS.add(WorldSetup.registerStandardBlock(name + "_block"));
            STORAGE_BLOCK_ITEMS.add((DeferredItem<BlockItem>)ITEMS.registerSimpleBlockItem((Holder)STORAGE_BLOCKS.get(metal.getIndex())));
        }
        FLAKES.add((DeferredItem<Item>)ITEMS.registerSimpleItem("lead_flakes"));
        NUGGETS.add((DeferredItem<Item>)ITEMS.registerSimpleItem("lead_nugget"));
        INGOTS.add((DeferredItem<Item>)ITEMS.registerSimpleItem("lead_ingot"));
        STORAGE_BLOCKS.add(WorldSetup.registerStandardBlock("lead_block"));
        STORAGE_BLOCK_ITEMS.add((DeferredItem<BlockItem>)ITEMS.registerSimpleBlockItem((Holder)STORAGE_BLOCKS.get(LEAD)));
        FLAKES.add((DeferredItem<Item>)ITEMS.registerSimpleItem("silver_flakes"));
        NUGGETS.add((DeferredItem<Item>)ITEMS.registerSimpleItem("silver_nugget"));
        INGOTS.add((DeferredItem<Item>)ITEMS.registerSimpleItem("silver_ingot"));
        STORAGE_BLOCKS.add(WorldSetup.registerStandardBlock("silver_block"));
        STORAGE_BLOCK_ITEMS.add((DeferredItem<BlockItem>)ITEMS.registerSimpleBlockItem((Holder)STORAGE_BLOCKS.get(SILVER)));
        for (OreConfig oreConfig : ORE_METALS) {
            String ore = oreConfig.name();
            DeferredBlock<Block> ore_block = WorldSetup.registerStandardOre(ore + "_ore");
            ORE_BLOCKS.add(ore_block);
            ORE_BLOCKS_ITEMS.add((DeferredItem<BlockItem>)ITEMS.registerSimpleBlockItem(ore_block));
            DeferredBlock<Block> ds_ore_block = WorldSetup.registerDeepslateOre("deepslate_" + ore + "_ore");
            DEEPSLATE_ORE_BLOCKS.add(ds_ore_block);
            DEEPSLATE_ORE_BLOCKS_ITEMS.add((DeferredItem<BlockItem>)ITEMS.registerSimpleBlockItem(ds_ore_block));
            DeferredBlock<Block> raw_ore_block = WorldSetup.registerStandardBlock("raw_" + ore + "_block");
            RAW_ORE_BLOCKS.add(raw_ore_block);
            RAW_ORE_BLOCKS_ITEMS.add((DeferredItem<BlockItem>)ITEMS.registerSimpleBlockItem(raw_ore_block));
            RAW_ORE_ITEMS.add((DeferredItem<Item>)ITEMS.registerSimpleItem("raw_" + ore));
        }
        GLM = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"allomancy");
        DAGGER_LOOT = GLM.register("unbreakable_dagger_loot", DaggerLootModifier.CODEC);
        LOOT_CONDITIONS = DeferredRegister.create((ResourceKey)Registries.LOOT_CONDITION_TYPE, (String)"allomancy");
        PLAYER_INVESTMENT = LOOT_CONDITIONS.register("player_investment", () -> new LootItemConditionType(PlayerInvestmentCondition.CODEC));
        RECIPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"allomancy");
        INVESTING_RECIPE_SERIALIZER = RECIPES.register("investing", () -> new RecipeSerializer<InvestingRecipe>(){

            public MapCodec<InvestingRecipe> codec() {
                return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(InvestingRecipe::ingredient), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(InvestingRecipe::result)).apply((Applicative)instance, InvestingRecipe::new));
            }

            public StreamCodec<RegistryFriendlyByteBuf, InvestingRecipe> streamCodec() {
                return StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, InvestingRecipe::ingredient, (StreamCodec)ItemStack.STREAM_CODEC, InvestingRecipe::result, InvestingRecipe::new);
            }
        });
        RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"allomancy");
        INVESTING_RECIPE = RECIPE_TYPES.register("investing", () -> RecipeType.simple((ResourceLocation)Allomancy.rl("investing")));
    }

    public record OreConfig(String name, int size, int placementCount, int minHeight, int maxHeight) {
        <T> ResourceKey<T> getRegistryKey(ResourceKey<Registry<T>> registry, String suffix) {
            return ResourceKey.create(registry, (ResourceLocation)Allomancy.rl(this.name + suffix));
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

