/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.world.loot;

import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.powers.data.AllomancerAttachment;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record PlayerInvestmentCondition(Metal power) implements LootItemCondition
{
    public static final MapCodec<PlayerInvestmentCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Metal.CODEC.fieldOf("power").forGetter(PlayerInvestmentCondition::power)).apply((Applicative)instance, PlayerInvestmentCondition::new));

    public LootItemConditionType getType() {
        return WorldSetup.PLAYER_INVESTMENT.get();
    }

    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.THIS_ENTITY, LootContextParams.ATTACKING_ENTITY);
    }

    public boolean test(LootContext lootContext) {
        Object object = lootContext.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if (object instanceof Player) {
            Player player = (Player)object;
            return AllomancerAttachment.get(player).hasPower(this.power);
        }
        object = lootContext.getOptionalParameter(LootContextParams.ATTACKING_ENTITY);
        if (object instanceof Player) {
            Player player = (Player)object;
            return AllomancerAttachment.get(player).hasPower(this.power);
        }
        return false;
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final Metal metal;

        public Builder(Metal metal) {
            this.metal = metal;
        }

        public PlayerInvestmentCondition build() {
            return new PlayerInvestmentCondition(this.metal);
        }
    }
}

