/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.world.recipe;

import com.legobmw99.allomancy.modules.world.WorldSetup;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public record InvestingRecipe(Ingredient ingredient, ItemStack result) implements Recipe<InvestingWrapper>
{
    public boolean matches(InvestingWrapper input, Level level) {
        return !input.isEmpty() && this.ingredient.acceptsItem(input.getItem(0).getItemHolder());
    }

    public ItemStack assemble(InvestingWrapper input, HolderLookup.Provider registries) {
        return this.result.copyWithCount(this.result.getCount() * input.getItem(0).getCount());
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<? extends Recipe<InvestingWrapper>> getSerializer() {
        return WorldSetup.INVESTING_RECIPE_SERIALIZER.get();
    }

    public RecipeType<? extends Recipe<InvestingWrapper>> getType() {
        return WorldSetup.INVESTING_RECIPE.get();
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.NOT_PLACEABLE;
    }

    public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.CRAFTING_MISC;
    }

    public static class InvestingWrapper
    extends RecipeWrapper {
        public InvestingWrapper(ItemStack stack) {
            super((IItemHandler)new ItemStackHandler(1));
            this.inv.insertItem(0, stack, false);
        }
    }
}

