/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

public class DoubleBufferList<T> {
    private final List<T> list_a = new ArrayList<T>();
    private final List<T> list_b = new ArrayList<T>();
    private final Lock lock_a = new ReentrantLock();
    private final Lock lock_b = new ReentrantLock();
    private final AtomicInteger AorB = new AtomicInteger(0);

    public void forEach(Consumer<T> f) {
        if (this.AorB.get() % 2 == 0) {
            this.lock_a.lock();
            try {
                this.list_a.forEach(f);
            }
            finally {
                this.lock_a.unlock();
            }
        }
        this.lock_b.lock();
        try {
            this.list_b.forEach(f);
        }
        finally {
            this.lock_b.unlock();
        }
    }

    public void add(T t) {
        if (this.AorB.get() % 2 != 0) {
            this.list_a.add(t);
        } else {
            this.list_b.add(t);
        }
    }

    public void commitAndClear() {
        int newAB = this.AorB.incrementAndGet();
        if (newAB % 2 != 0) {
            this.lock_a.lock();
            this.list_a.clear();
            this.lock_a.unlock();
        } else {
            this.lock_b.lock();
            this.list_b.clear();
            this.lock_b.unlock();
        }
    }

    public void clearBothAsync(ExecutorService ex) {
        ex.submit(() -> {
            this.lock_a.lock();
            try {
                this.list_a.clear();
            }
            finally {
                this.lock_a.unlock();
            }
            this.lock_b.lock();
            try {
                this.list_b.clear();
            }
            finally {
                this.lock_b.unlock();
            }
        });
    }
}

