/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.api.enums;

import java.util.Locale;

public enum Metal {
    IRON(true),
    STEEL(IRON),
    TIN,
    PEWTER(TIN),
    ZINC,
    BRASS(ZINC),
    COPPER(true),
    BRONZE(COPPER),
    ALUMINUM,
    DURALUMIN(ALUMINUM),
    CHROMIUM,
    NICROSIL(CHROMIUM),
    GOLD(true),
    ELECTRUM(GOLD),
    CADMIUM,
    BENDALLOY(CADMIUM);

    private final boolean vanilla;
    private final Metal base;

    private Metal() {
        this(false);
    }

    private Metal(Metal base) {
        this.base = base;
        this.vanilla = false;
    }

    private Metal(boolean isVanilla) {
        this.vanilla = isVanilla;
        this.base = null;
    }

    public static Metal getMetal(int index) {
        for (Metal metal : Metal.values()) {
            if (metal.getIndex() != index) continue;
            return metal;
        }
        throw new IllegalArgumentException("Allomancy: Bad Metal Index");
    }

    public boolean isAlloy() {
        return this.base != null;
    }

    public boolean isVanilla() {
        return this.vanilla;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public int getIndex() {
        return this.ordinal();
    }
}

