/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.datagen;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.combat.CombatSetup;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ItemModels
extends ItemModelProvider {
    private static final List<ResourceKey<TrimMaterial>> VANILLA_TRIM_MATERIALS = List.of(TrimMaterials.f_265905_, TrimMaterials.f_266000_, TrimMaterials.f_265896_, TrimMaterials.f_265870_, TrimMaterials.f_265969_, TrimMaterials.f_265937_, TrimMaterials.f_266071_, TrimMaterials.f_266027_, TrimMaterials.f_265981_, TrimMaterials.f_265872_);

    public ItemModels(PackOutput generator, ExistingFileHelper existingFileHelper) {
        super(generator, "allomancy", existingFileHelper);
    }

    protected void registerModels() {
        this.parentedBlock((Block)ExtrasSetup.IRON_BUTTON.get(), "block/iron_button_inventory");
        this.parentedBlock((Block)ExtrasSetup.INVERTED_IRON_BUTTON.get(), "block/iron_button_inventory");
        this.itemGenerated((Item)ExtrasSetup.IRON_LEVER_ITEM.get(), "block/iron_lever");
        this.itemTrimmed((Item)CombatSetup.MISTCLOAK.get(), "chestplate");
        this.itemTrimmed((Item)CombatSetup.ALUMINUM_HELMET.get(), "helmet");
        this.itemGenerated((Item)CombatSetup.COIN_BAG.get());
        this.itemHandheld((Item)CombatSetup.OBSIDIAN_DAGGER.get());
        this.largeItemHandheld((Item)CombatSetup.KOLOSS_BLADE.get());
        this.itemGenerated((Item)ConsumeSetup.ALLOMANTIC_GRINDER.get());
        this.itemGenerated((Item)ConsumeSetup.LERASIUM_NUGGET.get());
        this.itemGenerated((Item)ExtrasSetup.BRONZE_EARRING.get());
        this.itemGenerated((Item)ExtrasSetup.CHARGED_BRONZE_EARRING.get());
        for (RegistryObject<Block> registryObject : WorldSetup.ORE_BLOCKS) {
            this.parentedBlock((Block)registryObject.get());
        }
        for (RegistryObject<Block> registryObject : WorldSetup.DEEPSLATE_ORE_BLOCKS) {
            this.parentedBlock((Block)registryObject.get());
        }
        for (RegistryObject<Block> registryObject : WorldSetup.RAW_ORE_BLOCKS) {
            this.parentedBlock((Block)registryObject.get());
        }
        for (RegistryObject<Block> registryObject : WorldSetup.RAW_ORE_ITEMS) {
            this.itemGenerated((Item)registryObject.get());
        }
        for (int i = 0; i < WorldSetup.METAL_ITEM_LEN; ++i) {
            Item item = (Item)WorldSetup.FLAKES.get(i).get();
            this.itemGenerated(item);
            if (i <= Metal.BENDALLOY.getIndex()) {
                Item pattern_item = (Item)ExtrasSetup.PATTERN_ITEMS.get(i).get();
                this.itemGenerated(pattern_item);
                if (Metal.getMetal(i).isVanilla()) continue;
            }
            Item nugget = (Item)WorldSetup.NUGGETS.get(i).get();
            this.itemGenerated(nugget);
            Item ingot = (Item)WorldSetup.INGOTS.get(i).get();
            this.itemGenerated(ingot);
            Block block = (Block)WorldSetup.STORAGE_BLOCKS.get(i).get();
            this.parentedBlock(block);
        }
        Allomancy.LOGGER.debug("Creating Item Model for allomancy:vial (filled)");
        ItemModelBuilder mf = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("vial_filled")).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.modLoc("item/full_vial"));
        Allomancy.LOGGER.debug("Creating Item Model for allomancy:vial");
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("vial")).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.modLoc("item/vial"))).override().predicate(this.mcLoc("custom_model_data"), 1.0f).model((ModelFile)mf).end();
    }

    public void parentedBlock(Block block) {
        this.parentedBlock(block, "block/" + ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_());
    }

    public void parentedBlock(Block block, String model) {
        Allomancy.LOGGER.debug("Creating Item Model for " + String.valueOf(ForgeRegistries.BLOCKS.getKey((Object)block)));
        ((ItemModelBuilder)this.getBuilder(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc(model)));
    }

    public void itemGenerated(Item item) {
        this.itemGenerated(item, "item/" + ForgeRegistries.ITEMS.getKey((Object)item).m_135815_());
    }

    public void itemGenerated(Item item, String model) {
        Allomancy.LOGGER.debug("Creating Item Model for " + String.valueOf(ForgeRegistries.ITEMS.getKey((Object)item)));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_())).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.modLoc(model));
    }

    public void itemTrimmed(Item item, String type) {
        this.itemGenerated(item);
        for (ResourceKey<TrimMaterial> material : VANILLA_TRIM_MATERIALS) {
            Allomancy.LOGGER.debug("Creating Item Model for " + ForgeRegistries.ITEMS.getKey((Object)item).m_135815_() + "_trim_" + material.m_135782_().m_135815_());
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_() + "_trim_" + material.m_135782_().m_135815_())).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", this.modLoc("item/" + ForgeRegistries.ITEMS.getKey((Object)item).m_135815_()))).texture("layer1", this.mcLoc("trims/items/" + type + "_trim"));
        }
    }

    public void itemHandheld(Item item) {
        Allomancy.LOGGER.debug("Creating Item Model for " + String.valueOf(ForgeRegistries.ITEMS.getKey((Object)item)));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_())).parent((ModelFile)this.getExistingFile(this.mcLoc("item/handheld")))).texture("layer0", this.modLoc("item/" + ForgeRegistries.ITEMS.getKey((Object)item).m_135815_()));
    }

    public void largeItemHandheld(Item item) {
        Allomancy.LOGGER.debug("Creating Large Item Model for " + String.valueOf(ForgeRegistries.ITEMS.getKey((Object)item)));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_())).parent((ModelFile)this.getExistingFile(this.modLoc("item/handheld_large")))).texture("layer0", this.modLoc("item/" + ForgeRegistries.ITEMS.getKey((Object)item).m_135815_()));
    }

    public String m_6055_() {
        return "Allomancy Item Models";
    }
}

