/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.datagen;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.combat.CombatSetup;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class Recipes
extends RecipeProvider {
    private final Map<Character, Ingredient> defaultIngredients = new HashMap<Character, Ingredient>();

    public Recipes(PackOutput packOutput) {
        super(packOutput);
        this.add('i', (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.add('g', (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.add('s', (ItemLike)Items.f_42398_);
        this.add('S', (TagKey<Item>)ItemTags.f_13175_);
        this.add('G', (ItemLike)Items.f_41904_);
        this.add('I', (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_IRON);
        this.add('W', (ItemLike)Items.f_41877_);
        this.add('O', (TagKey<Item>)Tags.Items.OBSIDIAN);
        this.add('C', (ItemLike)Items.f_42594_);
        this.add('A', Recipes.ing("forge:ingots/aluminum"));
        this.add('B', Recipes.ing("forge:storage_blocks/bronze"));
        this.add('b', Recipes.ing("forge:ingots/bronze"));
        this.add('n', Recipes.ing("forge:nuggets/bronze"));
    }

    protected static void buildShapeless(Consumer<FinishedRecipe> consumer, RecipeCategory cat, ItemLike result, int count, Item criterion, Ingredient ... ingredients) {
        Recipes.buildShapeless(consumer, cat, result, count, criterion, "", ingredients);
    }

    protected static void buildShapeless(Consumer<FinishedRecipe> consumer, RecipeCategory cat, ItemLike result, int count, Item criterion, String save, Ingredient ... ingredients) {
        Allomancy.LOGGER.debug("Creating Shapeless Recipe for " + String.valueOf(ForgeRegistries.ITEMS.getKey((Object)result.m_5456_())) + " " + save);
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_246517_((RecipeCategory)cat, (ItemLike)result, (int)count);
        builder.m_126132_("has_" + ForgeRegistries.ITEMS.getKey((Object)criterion).m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{criterion}));
        for (Ingredient ingredient : ingredients) {
            builder.m_126184_(ingredient);
        }
        if (save.isEmpty()) {
            builder.m_176498_(consumer);
        } else {
            builder.m_176500_(consumer, save);
        }
    }

    protected static void buildSmeltingAndBlasting(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike ingredient, float xp) {
        Allomancy.LOGGER.debug("Creating Smelting and Blasting Recipe for " + String.valueOf(ForgeRegistries.ITEMS.getKey((Object)result.m_5456_())));
        SimpleCookingRecipeBuilder smelt = SimpleCookingRecipeBuilder.m_246179_((Ingredient)Recipes.ing(ingredient), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)xp, (int)200);
        SimpleCookingRecipeBuilder blast = SimpleCookingRecipeBuilder.m_245681_((Ingredient)Recipes.ing(ingredient), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)xp, (int)100);
        String ingredientName = ForgeRegistries.ITEMS.getKey((Object)ingredient.m_5456_()).m_135815_();
        smelt.m_126132_("has_" + ingredientName, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{ingredient}));
        blast.m_126132_("has_" + ingredientName, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{ingredient}));
        smelt.m_176500_(consumer, String.valueOf(ForgeRegistries.ITEMS.getKey((Object)result.m_5456_())) + "_from_smelting_" + ingredientName);
        blast.m_176500_(consumer, String.valueOf(ForgeRegistries.ITEMS.getKey((Object)result.m_5456_())) + "_from_blasting_" + ingredientName);
    }

    private static String mixing_save(String metal) {
        return "allomancy:" + metal + "_flakes_from_mixing";
    }

    private static String alloy_save(String metal) {
        return "allomancy:" + metal + "_ingot_from_alloying";
    }

    protected static Ingredient ing(String tag) {
        return Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation(tag)));
    }

    protected static Ingredient ing(TagKey<Item> tag) {
        return Ingredient.m_204132_(tag);
    }

    protected static Ingredient ing(ItemLike itemProvider) {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemProvider});
    }

    protected static Ingredient ing(Ingredient ingredient) {
        return ingredient;
    }

    protected static Ingredient[] repeat(Ingredient ing, int n) {
        return Recipes.repeatWith(ing, n, new Ingredient[0]);
    }

    protected static Ingredient[] repeatWith(Ingredient ing, int n, Ingredient ... extras) {
        int size = n + extras.length;
        Ingredient[] out = new Ingredient[size];
        for (int i = 0; i < n; ++i) {
            out[i] = ing;
        }
        if (extras.length > 0) {
            System.arraycopy(extras, 0, out, n, size - n);
        }
        return out;
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        int i;
        this.buildShaped(consumer, RecipeCategory.REDSTONE, (ItemLike)ExtrasSetup.IRON_LEVER.get(), Items.f_42416_, "s", "I");
        this.buildShaped(consumer, RecipeCategory.REDSTONE, (ItemLike)ExtrasSetup.IRON_BUTTON.get(), Items.f_42416_, "i", "I");
        Recipes.buildShapeless(consumer, RecipeCategory.REDSTONE, (ItemLike)ExtrasSetup.INVERTED_IRON_BUTTON.get(), 1, (Item)ExtrasSetup.IRON_BUTTON_ITEM.get(), "allomancy:inverted_from_iron_button", Recipes.ing((ItemLike)ExtrasSetup.IRON_BUTTON.get()));
        Recipes.buildShapeless(consumer, RecipeCategory.REDSTONE, (ItemLike)ExtrasSetup.IRON_BUTTON.get(), 1, (Item)ExtrasSetup.INVERTED_IRON_BUTTON_ITEM.get(), "allomancy:iron_button_from_inverted", Recipes.ing((ItemLike)ExtrasSetup.INVERTED_IRON_BUTTON.get()));
        this.buildShaped(consumer, RecipeCategory.FOOD, (ItemLike)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Items.f_42416_, "ggg", "iii", "ggg");
        this.buildShaped(consumer, RecipeCategory.FOOD, (ItemLike)ConsumeSetup.VIAL.get(), 4, Items.f_41904_, " S ", "G G", " G ");
        this.buildShaped(consumer, RecipeCategory.COMBAT, (ItemLike)CombatSetup.MISTCLOAK.get(), (Item)ConsumeSetup.VIAL.get(), "W W", "WWW", "WWW");
        this.buildShaped(consumer, RecipeCategory.COMBAT, (ItemLike)CombatSetup.ALUMINUM_HELMET.get(), (Item)WorldSetup.INGOTS.get(Metal.ALUMINUM.getIndex()).get(), "AAA", "A A");
        this.buildShaped(consumer, RecipeCategory.COMBAT, (ItemLike)CombatSetup.OBSIDIAN_DAGGER.get(), (Item)CombatSetup.MISTCLOAK.get(), "  O", " O ", "s  ");
        this.buildShaped(consumer, RecipeCategory.COMBAT, (ItemLike)CombatSetup.KOLOSS_BLADE.get(), (Item)ConsumeSetup.LERASIUM_NUGGET.get(), "CC", "CC", "sC");
        this.buildShaped(consumer, RecipeCategory.MISC, (ItemLike)ExtrasSetup.BRONZE_EARRING.get(), (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), " b ", "B n");
        int[] ore_metal_indexes = new int[]{Metal.ALUMINUM.getIndex(), Metal.CADMIUM.getIndex(), Metal.CHROMIUM.getIndex(), WorldSetup.LEAD, WorldSetup.SILVER, Metal.TIN.getIndex(), Metal.ZINC.getIndex()};
        float[] ore_metal_xp = new float[]{0.6f, 0.7f, 0.7f, 0.4f, 1.0f, 0.6f, 0.6f};
        for (i = 0; i < WorldSetup.ORE_METALS.length; ++i) {
            Item raw = (Item)WorldSetup.RAW_ORE_ITEMS.get(i).get();
            Item rawBlock = (Item)WorldSetup.RAW_ORE_BLOCKS_ITEMS.get(i).get();
            Item ingot = (Item)WorldSetup.INGOTS.get(ore_metal_indexes[i]).get();
            Item ore = (Item)WorldSetup.ORE_BLOCKS_ITEMS.get(i).get();
            Item deep_ore = (Item)WorldSetup.DEEPSLATE_ORE_BLOCKS_ITEMS.get(i).get();
            Recipes.buildSmeltingAndBlasting(consumer, (ItemLike)ingot, (ItemLike)raw, ore_metal_xp[i]);
            Recipes.buildSmeltingAndBlasting(consumer, (ItemLike)ingot, (ItemLike)ore, ore_metal_xp[i]);
            Recipes.buildSmeltingAndBlasting(consumer, (ItemLike)ingot, (ItemLike)deep_ore, ore_metal_xp[i]);
            Recipes.buildShapeless(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)rawBlock, 1, raw, Recipes.repeat(Recipes.ing((ItemLike)raw), 9));
            Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)raw, 9, rawBlock, BuiltInRegistries.f_257033_.m_7981_((Object)raw).m_135815_() + "_from_block", Recipes.ing((ItemLike)rawBlock));
        }
        for (i = 0; i < WorldSetup.METAL_ITEM_LEN; ++i) {
            Item flake = (Item)WorldSetup.FLAKES.get(i).get();
            String flakeType = ForgeRegistries.ITEMS.getKey((Object)flake).m_135815_().substring(0, ForgeRegistries.ITEMS.getKey((Object)flake).m_135815_().indexOf(95));
            Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)flake, 2, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.ing((ItemLike)ConsumeSetup.ALLOMANTIC_GRINDER.get()), Recipes.ing("forge:ingots/" + flakeType));
            if (i < Metal.values().length && Metal.getMetal(i).isVanilla()) continue;
            Item block = (Item)WorldSetup.STORAGE_BLOCK_ITEMS.get(i).get();
            Item ingot = (Item)WorldSetup.INGOTS.get(i).get();
            Item nugget = (Item)WorldSetup.NUGGETS.get(i).get();
            Recipes.buildShapeless(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)block, 1, ingot, Recipes.repeat(Recipes.ing((ItemLike)ingot), 9));
            Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)ingot, 1, nugget, "allomancy:" + ForgeRegistries.ITEMS.getKey((Object)ingot).m_135815_() + "_from_nuggets", Recipes.repeat(Recipes.ing((ItemLike)nugget), 9));
            Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)ingot, 9, block, "allomancy:" + ForgeRegistries.ITEMS.getKey((Object)ingot).m_135815_() + "_from_block", Recipes.ing((ItemLike)block));
            Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)nugget, 9, ingot, Recipes.ing((ItemLike)ingot));
        }
        for (Metal mt : Metal.values()) {
            Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)ExtrasSetup.PATTERN_ITEMS.get(mt.getIndex()).get(), 1, (Item)WorldSetup.FLAKES.get(mt.getIndex()).get(), Recipes.ing((ItemLike)Items.f_42516_), Recipes.ing((ItemLike)WorldSetup.FLAKES.get(mt.getIndex()).get()));
        }
        Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.FLAKES.get(Metal.STEEL.getIndex()).get(), 2, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("steel"), Recipes.ing((ItemLike)Items.f_42413_), Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.IRON.getIndex()).get()));
        Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.FLAKES.get(Metal.PEWTER.getIndex()).get(), 3, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("pewter"), Recipes.repeatWith(Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.TIN.getIndex()).get()), 2, Recipes.ing((ItemLike)WorldSetup.FLAKES.get(WorldSetup.LEAD).get())));
        Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.FLAKES.get(Metal.BRASS.getIndex()).get(), 4, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("brass"), Recipes.repeatWith(Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.COPPER.getIndex()).get()), 3, Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.ZINC.getIndex()).get())));
        Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.FLAKES.get(Metal.BRONZE.getIndex()).get(), 4, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("bronze"), Recipes.repeatWith(Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.COPPER.getIndex()).get()), 3, Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.TIN.getIndex()).get())));
        Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.FLAKES.get(Metal.DURALUMIN.getIndex()).get(), 4, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("duralumin"), Recipes.repeatWith(Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.ALUMINUM.getIndex()).get()), 3, Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.COPPER.getIndex()).get())));
        Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.FLAKES.get(Metal.ELECTRUM.getIndex()).get(), 2, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("electrum"), Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.GOLD.getIndex()).get()), Recipes.ing((ItemLike)WorldSetup.FLAKES.get(WorldSetup.SILVER).get()));
        Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.FLAKES.get(Metal.BENDALLOY.getIndex()).get(), 3, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("bendalloy"), Recipes.repeatWith(Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.CADMIUM.getIndex()).get()), 2, Recipes.ing((ItemLike)WorldSetup.FLAKES.get(WorldSetup.LEAD).get())));
        Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.FLAKES.get(Metal.NICROSIL.getIndex()).get(), 4, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("nicrosil"), Recipes.repeatWith(Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.CHROMIUM.getIndex()).get()), 3, Recipes.ing((ItemLike)WorldSetup.FLAKES.get(Metal.IRON.getIndex()).get())));
        Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.INGOTS.get(Metal.STEEL.getIndex()).get(), 4, Items.f_42413_, Recipes.alloy_save("steel"), Recipes.repeatWith(Recipes.ing((ItemLike)Items.f_42416_), 3, Recipes.ing((ItemLike)Items.f_42413_)));
        Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.INGOTS.get(Metal.PEWTER.getIndex()).get(), 3, (Item)WorldSetup.INGOTS.get(Metal.TIN.getIndex()).get(), Recipes.alloy_save("pewter"), Recipes.repeatWith(Recipes.ing("forge:ingots/tin"), 2, Recipes.ing("forge:ingots/lead")));
        Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.INGOTS.get(Metal.BRASS.getIndex()).get(), 4, (Item)WorldSetup.INGOTS.get(Metal.ZINC.getIndex()).get(), Recipes.alloy_save("brass"), Recipes.repeatWith(Recipes.ing((ItemLike)Items.f_151052_), 3, Recipes.ing("forge:ingots/zinc")));
        Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.INGOTS.get(Metal.BRONZE.getIndex()).get(), 4, (Item)WorldSetup.INGOTS.get(Metal.TIN.getIndex()).get(), Recipes.alloy_save("bronze"), Recipes.repeatWith(Recipes.ing((ItemLike)Items.f_151052_), 3, Recipes.ing("forge:ingots/tin")));
        Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.INGOTS.get(Metal.DURALUMIN.getIndex()).get(), 4, (Item)WorldSetup.INGOTS.get(Metal.ALUMINUM.getIndex()).get(), Recipes.alloy_save("duralumin"), Recipes.repeatWith(Recipes.ing("forge:ingots/aluminum"), 3, Recipes.ing((ItemLike)Items.f_151052_)));
        Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.INGOTS.get(Metal.ELECTRUM.getIndex()).get(), 2, (Item)WorldSetup.INGOTS.get(WorldSetup.SILVER).get(), Recipes.alloy_save("electrum"), Recipes.ing("forge:ingots/silver"), Recipes.ing((ItemLike)Items.f_42417_));
        Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.INGOTS.get(Metal.BENDALLOY.getIndex()).get(), 3, (Item)WorldSetup.INGOTS.get(Metal.CADMIUM.getIndex()).get(), Recipes.alloy_save("bendalloy"), Recipes.repeatWith(Recipes.ing("forge:ingots/cadmium"), 2, Recipes.ing("forge:ingots/lead")));
        Recipes.buildShapeless(consumer, RecipeCategory.MISC, (ItemLike)WorldSetup.INGOTS.get(Metal.NICROSIL.getIndex()).get(), 4, (Item)WorldSetup.INGOTS.get(Metal.CHROMIUM.getIndex()).get(), Recipes.alloy_save("nicrosil"), Recipes.repeatWith(Recipes.ing("forge:ingots/chromium"), 3, Recipes.ing((ItemLike)Items.f_42416_)));
        Allomancy.LOGGER.debug("Creating Shaped Recipe for allomancy:coin_bag");
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)CombatSetup.COIN_BAG.get())).m_126132_("has_gold_nugget", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)CombatSetup.MISTCLOAK.get()})).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42655_).m_126127_(Character.valueOf('l'), (ItemLike)Items.f_42454_).m_126127_(Character.valueOf('g'), (ItemLike)Items.f_42587_).m_126130_(" #g").m_126130_("l l").m_126130_(" l ").m_176498_(consumer);
        Allomancy.LOGGER.debug("Creating Special Recipe for Vial Filling");
        SpecialRecipeBuilder.m_245676_((RecipeSerializer)((RecipeSerializer)ConsumeSetup.VIAL_RECIPE_SERIALIZER.get())).m_126359_(consumer, "allomancy:vial_filling_recipe");
        Allomancy.LOGGER.debug("Creating Special Recipe for Lerasium investing");
    }

    protected void buildShaped(Consumer<FinishedRecipe> consumer, RecipeCategory cat, ItemLike result, int count, Item criterion, String ... lines) {
        Allomancy.LOGGER.debug("Creating Shaped Recipe for " + String.valueOf(ForgeRegistries.ITEMS.getKey((Object)result.m_5456_())));
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_246608_((RecipeCategory)cat, (ItemLike)result, (int)count);
        builder.m_126132_("has_" + ForgeRegistries.ITEMS.getKey((Object)criterion).m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{criterion}));
        HashSet characters = new HashSet();
        for (String line : lines) {
            builder.m_126130_(line);
            line.chars().forEach(value -> characters.add(Character.valueOf((char)value)));
        }
        for (Character c : characters) {
            if (!this.defaultIngredients.containsKey(c)) continue;
            builder.m_126124_(c, this.defaultIngredients.get(c));
        }
        builder.m_176498_(consumer);
    }

    protected void buildShaped(Consumer<FinishedRecipe> consumer, RecipeCategory cat, ItemLike result, Item criterion, String ... lines) {
        this.buildShaped(consumer, cat, result, 1, criterion, lines);
    }

    protected void add(char c, TagKey<Item> itemTag) {
        this.defaultIngredients.put(Character.valueOf(c), Ingredient.m_204132_(itemTag));
    }

    protected void add(char c, ItemLike itemProvider) {
        this.defaultIngredients.put(Character.valueOf(c), Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemProvider}));
    }

    protected void add(char c, Ingredient ingredient) {
        this.defaultIngredients.put(Character.valueOf(c), ingredient);
    }
}

