/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.powers.PowersConfig;
import com.legobmw99.allomancy.modules.powers.data.AllomancerCapability;
import com.legobmw99.allomancy.modules.powers.data.AllomancerDataProvider;
import com.legobmw99.allomancy.modules.powers.network.UpdateEnhancedPacket;
import com.legobmw99.allomancy.modules.powers.util.Emotional;
import com.legobmw99.allomancy.modules.powers.util.Enhancement;
import com.legobmw99.allomancy.modules.powers.util.Physical;
import com.legobmw99.allomancy.modules.powers.util.Temporal;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import com.legobmw99.allomancy.network.Network;
import com.legobmw99.allomancy.util.AllomancyTags;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;

public final class CommonEventHandler {
    private static final Metal[] USEFUL_MISTINGS = new Metal[]{Metal.IRON, Metal.STEEL, Metal.TIN, Metal.PEWTER, Metal.ZINC, Metal.BRASS, Metal.BRONZE, Metal.COPPER, Metal.CHROMIUM, Metal.NICROSIL, Metal.GOLD, Metal.ELECTRUM, Metal.CADMIUM, Metal.BENDALLOY};
    private static final Metal[] USEFUL_MISTINGS_SSP = new Metal[]{Metal.IRON, Metal.STEEL, Metal.TIN, Metal.PEWTER, Metal.ZINC, Metal.BRASS, Metal.GOLD, Metal.ELECTRUM, Metal.CADMIUM, Metal.BENDALLOY};

    private CommonEventHandler() {
    }

    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player p = (Player)object;
            AllomancerDataProvider provider = new AllomancerDataProvider();
            event.addCapability(AllomancerCapability.IDENTIFIER, (ICapabilityProvider)provider);
        }
    }

    private static Metal getRandomMistingForPlayer(ServerPlayer player, Metal[] options) {
        if (((Boolean)PowersConfig.respect_player_UUID.get()).booleanValue()) {
            return options[Math.abs(player.m_20148_().hashCode()) % options.length];
        }
        return options[player.m_217043_().m_188503_(options.length)];
    }

    @SubscribeEvent
    public static void onJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player2.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
                if (((Boolean)PowersConfig.random_mistings.get()).booleanValue() && data.isUninvested()) {
                    Metal randomMisting = FMLEnvironment.dist.isClient() ? CommonEventHandler.getRandomMistingForPlayer(player2, USEFUL_MISTINGS_SSP) : CommonEventHandler.getRandomMistingForPlayer(player2, USEFUL_MISTINGS);
                    data.addPower(randomMisting);
                    ItemStack flakes = new ItemStack((ItemLike)WorldSetup.FLAKES.get(randomMisting.getIndex()).get());
                    if (!player2.m_150109_().m_36054_(flakes)) {
                        ItemEntity entity = new ItemEntity(player2.m_9236_(), player2.m_20182_().m_7096_(), player2.m_20182_().m_7098_(), player2.m_20182_().m_7094_(), flakes);
                        player2.m_9236_().m_7967_((Entity)entity);
                    }
                }
            });
            Network.syncAllomancerData(player2);
        }
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player;
        if (!event.getEntity().m_9236_().m_5776_() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!event.isEndConquered()) {
                player2.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> data.drainMetals(Metal.values()));
            }
            Network.syncAllomancerData(player2);
        }
    }

    @SubscribeEvent
    public static void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player;
        if (!event.getEntity().m_20193_().m_5776_() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Network.syncAllomancerData(player2);
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity entity;
        if (!event.getTarget().m_9236_().f_46443_ && (entity = event.getTarget()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Network.syncAllomancerData(player);
        }
    }

    @SubscribeEvent
    public static void onSetSpawn(PlayerSetSpawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player2.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> data.setSpawnLoc(event.getNewSpawn(), (ResourceKey<Level>)event.getSpawnLevel()));
            Network.syncAllomancerData(player2);
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer source = (ServerPlayer)entity;
            source.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
                ServerPlayer player;
                LivingEntity patt7269$temp;
                if (data.isBurning(Metal.PEWTER)) {
                    if (data.isEnhanced()) {
                        if (source.m_21205_().m_204117_(AllomancyTags.ONE_HIT_WEAPONS)) {
                            event.setAmount(550.0f);
                            Enhancement.wipePlayer((Player)source);
                        } else {
                            event.setAmount(event.getAmount() * 3.0f);
                        }
                    } else {
                        event.setAmount(event.getAmount() + 2.0f);
                    }
                }
                if (data.isBurning(Metal.CHROMIUM) && (patt7269$temp = event.getEntity()) instanceof ServerPlayer && !Emotional.hasTinFoilHat((LivingEntity)(player = (ServerPlayer)patt7269$temp))) {
                    Enhancement.wipePlayer((Player)player);
                }
            });
        }
        if ((entity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
                if (data.isBurning(Metal.PEWTER)) {
                    Allomancy.LOGGER.debug("Reducing Damage");
                    event.setAmount(event.getAmount() - 2.0f);
                    data.setDamageStored(data.getDamageStored() + 2);
                    Network.syncAllomancerData(player);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerAttacked(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
                if (data.isBurning(Metal.PEWTER) && data.isEnhanced()) {
                    Allomancy.LOGGER.debug("Canceling Damage");
                    event.setCanceled(true);
                }
                if (data.isBurning(Metal.STEEL) && event.getSource().m_269415_().equals(player.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268671_).m_203334_())) {
                    BlockPos on = player.m_20097_();
                    if (Physical.isBlockStateMetallic(player.m_9236_().m_8055_(on)) || Physical.isBlockStateMetallic(player.m_9236_().m_8055_(on.m_7494_()))) {
                        event.setCanceled(true);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Level level = event.level;
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            List list = l.m_6907_();
            for (int i = list.size() - 1; i >= 0; --i) {
                ServerPlayer curPlayer = (ServerPlayer)list.get(i);
                CommonEventHandler.playerPowerTick(curPlayer, l);
            }
        }
    }

    private static void playerPowerTick(ServerPlayer curPlayer, ServerLevel level) {
        curPlayer.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
            boolean syncRequired = data.tickBurning();
            if (curPlayer.m_6844_(EquipmentSlot.HEAD).m_204117_(AllomancyTags.SPECIAL_EARRINGS)) {
                BlockPos raised;
                GlobalPos seeking = data.getSpecialSeekingLoc();
                if (seeking == null) {
                    BlockPos blockpos = level.m_215011_(AllomancyTags.SEEKABLE, curPlayer.m_20183_(), 100, false);
                    if (blockpos != null) {
                        data.setSpecialSeekingLoc(blockpos, (ResourceKey<Level>)curPlayer.m_9236_().m_46472_());
                        syncRequired = true;
                    }
                } else if (level.m_46749_(seeking.m_122646_()) && (raised = level.m_5452_(Heightmap.Types.WORLD_SURFACE, seeking.m_122646_()).m_6625_(18)) != seeking.m_122646_()) {
                    data.setSpecialSeekingLoc(raised, (ResourceKey<Level>)seeking.m_122640_());
                    syncRequired = true;
                }
            } else {
                syncRequired = syncRequired || data.getSpecialSeekingLoc() != null;
                data.setSpecialSeekingLoc(null, null);
            }
            if (!data.isUninvested()) {
                if (data.isBurning(Metal.ALUMINUM)) {
                    Enhancement.wipePlayer((Player)curPlayer);
                    syncRequired = true;
                }
                if (data.isBurning(Metal.DURALUMIN) && !data.isEnhanced()) {
                    data.setEnhanced(2);
                    Network.sync(new UpdateEnhancedPacket(2, curPlayer.m_19879_()), curPlayer);
                } else if (!data.isBurning(Metal.DURALUMIN) && data.isEnhanced()) {
                    data.decrementEnhanced();
                    if (!data.isEnhanced()) {
                        Network.sync(new UpdateEnhancedPacket(0, curPlayer.m_19879_()), curPlayer);
                        data.drainMetals((Metal[])Arrays.stream(Metal.values()).filter(data::isBurning).toArray(Metal[]::new));
                        syncRequired = true;
                    }
                }
                if (data.isEnhanced() && data.isBurning(Metal.CHROMIUM)) {
                    Enhancement.wipeNearby((Player)curPlayer, (Level)level);
                }
                if (data.isEnhanced() && data.isBurning(Metal.ELECTRUM) && data.getStored(Metal.ELECTRUM) >= 9) {
                    Enhancement.teleportToSpawn((Player)curPlayer, (Level)level, data);
                    syncRequired = true;
                } else if (data.isEnhanced() && data.isBurning(Metal.GOLD) && data.getStored(Metal.GOLD) >= 9) {
                    Enhancement.teleportToLastDeath((Player)curPlayer, (Level)level, data);
                    syncRequired = true;
                }
                if (data.isBurning(Metal.BENDALLOY) && !data.isBurning(Metal.CADMIUM)) {
                    Temporal.speedUpNearby((Player)curPlayer, (Level)level, data);
                }
                if (data.isBurning(Metal.CADMIUM) && !data.isBurning(Metal.BENDALLOY)) {
                    Temporal.slowDownNearby((Player)curPlayer, (Level)level, data);
                }
                if (data.isBurning(Metal.TIN)) {
                    curPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19611_, -1, 5, true, false));
                    if (data.isEnhanced() && level.f_46441_.m_188503_(50) == 0) {
                        curPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100, 0, true, false));
                    }
                    if (curPlayer.m_21023_(MobEffects.f_19610_)) {
                        curPlayer.m_21195_(MobEffects.f_19610_);
                    }
                }
                if (!data.isBurning(Metal.TIN) && curPlayer.m_21124_(MobEffects.f_19611_) != null && curPlayer.m_21124_(MobEffects.f_19611_).m_19564_() == 5) {
                    curPlayer.m_21195_(MobEffects.f_19611_);
                }
                if (data.isBurning(Metal.PEWTER)) {
                    curPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 11, 1, true, false));
                    curPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 11, 0, true, false));
                    curPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 11, 1, true, false));
                    if (data.getDamageStored() > 0 && level.f_46441_.m_188503_(200) == 0) {
                        data.setDamageStored(data.getDamageStored() - 1);
                    }
                }
                if (!data.isBurning(Metal.PEWTER) && data.getDamageStored() > 0) {
                    data.setDamageStored(data.getDamageStored() - 1);
                    curPlayer.m_6469_(level.m_269111_().m_269425_(), 2.0f);
                }
                if (data.isEnhanced() && data.isBurning(Metal.COPPER)) {
                    curPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 20, 50, true, false));
                }
            }
            if (syncRequired) {
                Network.syncAllomancerData(curPlayer);
            }
        });
    }
}

