/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.client.gui;

import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.powers.PowersConfig;
import com.legobmw99.allomancy.modules.powers.client.network.PowerRequests;
import com.legobmw99.allomancy.modules.powers.client.util.Inputs;
import com.legobmw99.allomancy.modules.powers.data.AllomancerCapability;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MetalSelectScreen
extends Screen {
    private static final String[] METAL_NAMES = (String[])Arrays.stream(Metal.values()).map(Metal::getName).toArray(String[]::new);
    private static final String GUI_METAL = "allomancy:textures/gui/metals/%s_symbol.png";
    private static final String[] METAL_LOCAL = (String[])Arrays.stream(METAL_NAMES).map(s -> "metals." + s).toArray(String[]::new);
    private static final ResourceLocation[] METAL_ICONS = (ResourceLocation[])Arrays.stream(METAL_NAMES).map(s -> new ResourceLocation(String.format(GUI_METAL, s))).toArray(ResourceLocation[]::new);
    final Minecraft mc;
    int timeIn = (Boolean)PowersConfig.animate_selection.get() != false ? 0 : 16;
    protected Metal selectedMetal = null;

    public MetalSelectScreen() {
        super((Component)Component.m_237115_((String)"allomancy_gui"));
        this.mc = Minecraft.m_91087_();
    }

    private static double mouseAngle(int x, int y, int mx, int my) {
        return (Mth.m_14136_((double)(my - y), (double)(mx - x)) + Math.PI * 2) % (Math.PI * 2);
    }

    private static int toMetalIndex(int segment) {
        return (segment + 5) % Metal.values().length;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mx, int my, float partialTicks) {
        super.m_88315_(guiGraphics, mx, my, partialTicks);
        this.mc.f_91074_.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
            float radius;
            boolean mouseInSector;
            Metal mt;
            int seg;
            int x = this.f_96543_ / 2;
            int y = this.f_96544_ / 2;
            int maxRadius = 80;
            double angle = MetalSelectScreen.mouseAngle(x, y, mx, my);
            int segments = METAL_NAMES.length;
            float step = (float)Math.PI / 180;
            float degPer = (float)Math.PI * 2 / (float)segments;
            this.selectedMetal = null;
            Tesselator tess = Tesselator.m_85913_();
            BufferBuilder buf = tess.m_85915_();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::m_172811_);
            buf.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            for (seg = 0; seg < segments; ++seg) {
                mt = Metal.getMetal(MetalSelectScreen.toMetalIndex(seg));
                mouseInSector = data.hasPower(mt) && (double)(degPer * (float)seg) < angle && angle < (double)(degPer * (float)(seg + 1));
                radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
                if (mouseInSector) {
                    this.selectedMetal = Metal.getMetal(MetalSelectScreen.toMetalIndex(seg));
                    radius *= 1.025f;
                }
                int gs = 85;
                if (seg % 2 == 0) {
                    gs += 25;
                }
                gs = !data.hasPower(mt) || data.getStored(mt) == 0 ? 0 : gs;
                int r = data.isBurning(mt) ? 255 : gs;
                int g = gs;
                int b = gs;
                int a = 153;
                if (seg == 0) {
                    buf.m_5483_((double)x, (double)y, 0.0).m_6122_(25, 25, 25, 21).m_5752_();
                }
                for (float v = 0.0f; v < degPer + step / 2.0f; v += step) {
                    float rad = v + (float)seg * degPer;
                    float xp = (float)x + Mth.m_14089_((float)rad) * radius;
                    float yp = (float)y + Mth.m_14031_((float)rad) * radius;
                    if (v == 0.0f) {
                        buf.m_5483_((double)xp, (double)yp, 0.0).m_6122_(r, g, b, a).m_5752_();
                    }
                    buf.m_5483_((double)xp, (double)yp, 0.0).m_6122_(r, g, b, a).m_5752_();
                }
            }
            tess.m_85914_();
            for (seg = 0; seg < segments; ++seg) {
                mt = Metal.getMetal(MetalSelectScreen.toMetalIndex(seg));
                mouseInSector = data.hasPower(mt) && (double)(degPer * (float)seg) < angle && angle < (double)(degPer * (float)(seg + 1));
                radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
                if (mouseInSector) {
                    radius *= 1.025f;
                }
                float rad = ((float)seg + 0.5f) * degPer;
                float xp = (float)x + Mth.m_14089_((float)rad) * radius;
                float yp = (float)y + Mth.m_14031_((float)rad) * radius;
                float xsp = xp - 4.0f;
                float ysp = yp;
                String name = String.valueOf(mouseInSector ? ChatFormatting.UNDERLINE : ChatFormatting.RESET) + Component.m_237115_((String)METAL_LOCAL[MetalSelectScreen.toMetalIndex(seg)]).getString();
                int textwidth = this.mc.f_91062_.m_92895_(name);
                if (xsp < (float)x) {
                    xsp -= (float)(textwidth - 8);
                }
                if (ysp < (float)y) {
                    ysp -= 9.0f;
                }
                guiGraphics.drawString(this.f_96547_, name, xsp, ysp, 0xFFFFFF, true);
                double mod = 0.8;
                int xdp = (int)((double)(xp - (float)x) * mod + (double)x);
                int ydp = (int)((double)(yp - (float)y) * mod + (double)y);
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)METAL_ICONS[MetalSelectScreen.toMetalIndex(seg)]);
                guiGraphics.m_280163_(METAL_ICONS[MetalSelectScreen.toMetalIndex(seg)], xdp - 8, ydp - 8, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            RenderSystem.disableBlend();
        });
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.toggleSelected();
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void m_86600_() {
        ++this.timeIn;
    }

    public boolean m_7920_(int keysym, int scancode, int modifiers) {
        if (Inputs.burn.m_90832_(keysym, scancode)) {
            this.mc.m_91152_(null);
            this.mc.f_91067_.m_91601_();
            return true;
        }
        return super.m_7920_(keysym, scancode, modifiers);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (Inputs.burn.m_90830_(button)) {
            this.mc.m_91152_(null);
            this.mc.f_91067_.m_91601_();
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void toggleSelected() {
        if (this.selectedMetal != null) {
            this.mc.f_91074_.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
                PowerRequests.toggleBurn(this.selectedMetal, data);
                this.mc.f_91074_.m_5496_((SoundEvent)SoundEvents.f_12490_.get(), 0.1f, 2.0f);
            });
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

