/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.network;

import com.legobmw99.allomancy.api.data.IAllomancerData;
import com.legobmw99.allomancy.modules.powers.data.AllomancerCapability;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class AllomancerDataPacket {
    private final CompoundTag nbt;
    private final UUID uuid;

    public AllomancerDataPacket(IAllomancerData data, Player player) {
        this.uuid = player.m_20148_();
        this.nbt = data != null && AllomancerCapability.PLAYER_CAP != null ? data.save() : new CompoundTag();
    }

    private AllomancerDataPacket(CompoundTag nbt, UUID uuid) {
        this.nbt = nbt;
        this.uuid = uuid;
    }

    public static AllomancerDataPacket decode(FriendlyByteBuf buf) {
        return new AllomancerDataPacket(buf.m_130260_(), buf.m_130259_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130079_(this.nbt);
        buf.m_130077_(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Player player = Minecraft.m_91087_().f_91073_.m_46003_(this.uuid);
            if (player != null && AllomancerCapability.PLAYER_CAP != null) {
                player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> data.load(this.nbt));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

