/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.network;

import com.legobmw99.allomancy.modules.powers.util.Physical;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraftforge.network.NetworkEvent;

public class TryPushPullEntity {
    private final int entityIDOther;
    private final int direction;

    public TryPushPullEntity(int entityIDOther, int direction) {
        this.entityIDOther = entityIDOther;
        this.direction = direction;
    }

    public static TryPushPullEntity decode(FriendlyByteBuf buf) {
        return new TryPushPullEntity(buf.readInt(), buf.readInt());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityIDOther);
        buf.writeInt(this.direction);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Entity target = player.m_9236_().m_6815_(this.entityIDOther);
            if (target != null && Physical.isEntityMetallic(target)) {
                if (target instanceof IronGolem || target instanceof ItemFrame) {
                    Physical.lurch(this.direction, (Entity)player, target.m_20183_());
                } else if (target instanceof ItemEntity || target instanceof FallingBlockEntity || target instanceof ArmorStand || target instanceof AbstractMinecart && !target.m_20160_()) {
                    Physical.lurch((double)this.direction / 2.0, target, player.m_20183_());
                } else if (!(target instanceof ThrowableItemProjectile)) {
                    Physical.lurch((double)this.direction / 2.0, target, player.m_20183_());
                    Physical.lurch((double)this.direction / 2.0, (Entity)player, target.m_20183_());
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

